/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control;

import com.rameses.rcp.common.DocViewModel;
import com.rameses.rcp.common.PopupItem;
import com.rameses.rcp.common.PropertySupport;
import com.rameses.rcp.common.TextDocumentModel;
import com.rameses.rcp.common.TextEditorModel;
import com.rameses.rcp.common.TextWriter;
import com.rameses.rcp.constant.TextCase;
import com.rameses.rcp.constant.TrimSpaceOption;
import com.rameses.rcp.control.table.ExprBeanSupport;
import com.rameses.rcp.control.text.TextComponentSupport;
import com.rameses.rcp.control.text.TextEditorPopupSelector;
import com.rameses.rcp.framework.ActionHandler;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.support.FontSupport;
import com.rameses.rcp.support.MouseEventSupport;
import com.rameses.rcp.support.TextDocument;
import com.rameses.rcp.ui.ActiveControl;
import com.rameses.rcp.ui.ControlProperty;
import com.rameses.rcp.ui.UIInput;
import com.rameses.rcp.ui.Validatable;
import com.rameses.rcp.util.ActionMessage;
import com.rameses.rcp.util.TimerManager;
import com.rameses.rcp.util.UIControlUtil;
import com.rameses.rcp.util.UIInputUtil;
import com.rameses.util.ValueUtil;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.Beans;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

@Deprecated
public class XTextArea
extends JTextArea
implements UIInput,
Validatable,
ActiveControl,
MouseEventSupport.ComponentInfo {
    final String ACTION_MAPPING_VK_SPACE = "ACTION_MAPPING_VK_SPACE";
    final String ACTION_MAPPING_VK_ESC = "ACTION_MAPPING_VK_ESCAPE";
    final String ACTION_MAPPING_VK_DOWN = "ACTION_MAPPING_VK_DOWN";
    final String ACTION_MAPPING_VK_UP = "ACTION_MAPPING_VK_UP";
    final String ACTION_MAPPING_VK_ENTER = "ACTION_MAPPING_VK_ENTER";
    private Color focusBackground;
    private Color disabledBackground;
    private Color enabledBackground;
    private Binding binding;
    private int index;
    private boolean readonly;
    private boolean nullWhenEmpty = true;
    private String[] depends;
    private String fontStyle;
    private Font sourceFont;
    private ControlProperty property = new ControlProperty();
    private ActionMessage actionMessage = new ActionMessage();
    private TextDocument textDocument = new TextDocument();
    private TrimSpaceOption trimSpaceOption = TrimSpaceOption.NONE;
    private ActionHandlerImpl actionHandler = new ActionHandlerImpl();
    private String handler;
    private TextWriter textWriterObject;
    private TextDocumentModel handlerObject;
    private TextEditorModel editorModel;
    private String itemExpression;
    private String varName = "item";
    private String hint;
    private boolean showHint;
    private boolean autoScrollDown;
    private VerticalAdjustmentListener verticalAdjHandler;
    private TextWriterHandler textWriterHandler;
    private int stretchWidth;
    private int stretchHeight;
    private boolean exitOnTabKey;
    private String visibleWhen;
    private TextEditorPopupSelector jpopup;

    public XTextArea() {
        this.initComponent();
    }

    private void initComponent() {
        TextComponentSupport.getInstance().installUIDefaults(this);
        this.setColumns(5);
        this.setRows(2);
        for (FocusListener l : this.getFocusListeners()) {
            this.removeFocusListener(l);
        }
        new MouseEventSupport(this).install();
        if (Beans.isDesignTime()) {
            return;
        }
        this.verticalAdjHandler = new VerticalAdjustmentListener();
        this.textWriterHandler = new TextWriterHandler();
        KeyStroke vkspace = KeyStroke.getKeyStroke(32, 128, true);
        this.getInputMap().put(vkspace, "ACTION_MAPPING_VK_SPACE");
        this.getActionMap().put("ACTION_MAPPING_VK_SPACE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XTextArea.this.fireSearch();
            }
        });
        KeyStroke vkescape = KeyStroke.getKeyStroke(27, 0);
        this.getInputMap().put(vkescape, "ACTION_MAPPING_VK_ESCAPE");
        this.getActionMap().put("ACTION_MAPPING_VK_ESCAPE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XTextArea.this.fireEscapeKeyEvent();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 9: {
                        if (!XTextArea.this.isExitOnTabKey() || !XTextArea.this.hasFocus() || e.isControlDown() || e.isAltDown()) break;
                        if (e.isShiftDown()) {
                            e.consume();
                            XTextArea.this.transferFocusBackward();
                            break;
                        }
                        e.consume();
                        XTextArea.this.transferFocus();
                        break;
                    }
                    case 27: {
                        break;
                    }
                    case 40: {
                        if (!XTextArea.this.getPopup().isVisible() || !XTextArea.this.getPopup().isShowing()) break;
                        e.consume();
                        XTextArea.this.getPopup().moveDown();
                        break;
                    }
                    case 38: {
                        if (!XTextArea.this.getPopup().isVisible() || !XTextArea.this.getPopup().isShowing()) break;
                        e.consume();
                        XTextArea.this.getPopup().moveUp();
                        break;
                    }
                    case 10: {
                        if (!XTextArea.this.getPopup().isVisible() || !XTextArea.this.getPopup().isShowing()) break;
                        e.consume();
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                XTextArea.this.fireSelectItem();
                            }
                        });
                        break;
                    }
                    default: {
                        try {
                            boolean ctrlDown;
                            boolean bl = ctrlDown = (e.getModifiers() & 2) == 2;
                            if (ctrlDown && e.getKeyCode() == 32) {
                                e.consume();
                                return;
                            }
                            int pos = XTextArea.this.getCaretPosition() - 1;
                            if (pos < 0) {
                                return;
                            }
                            String str = e.getKeyChar() + "";
                            boolean whitespace = str.matches("\\s");
                            if (whitespace) {
                                XTextArea.this.getPopup().setVisible(false);
                                return;
                            }
                            if (!XTextArea.this.getPopup().isVisible() || !XTextArea.this.getPopup().isShowing() || whitespace) break;
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    XTextArea.this.fireSearch();
                                }
                            });
                            break;
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                }
            }
        });
    }

    @Override
    public void paint(Graphics origGraphics) {
        super.paint(origGraphics);
        if (this.showHint && this.getDocument().getLength() == 0) {
            Graphics g = origGraphics.create();
            Font f = this.getFont();
            FontMetrics fm = g.getFontMetrics(f);
            g.setColor(Color.LIGHT_GRAY);
            g.setFont(f);
            Insets margin = this.getInsets();
            int x = margin.left;
            int y = margin.top + fm.getAscent();
            g.drawString(" " + this.getHint(), x, y);
            g.dispose();
        }
    }

    @Override
    public void refresh() {
        int oldCaretPos;
        block9: {
            oldCaretPos = this.getCaretPosition();
            try {
                this.updateBackground();
                Object value = UIControlUtil.getBeanValue(this);
                if (this.textWriterObject != null) {
                    value = this.textWriterObject.getText();
                }
                this.setValue(value);
            }
            catch (Throwable e) {
                this.setText("");
                if (!ClientContext.getCurrentContext().isDebugMode()) break block9;
                e.printStackTrace();
            }
        }
        try {
            this.setCaretPosition(oldCaretPos);
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (this.textWriterObject != null) {
            this.setEditable(false);
        }
        Object bean = this.getBinding() == null ? null : this.getBinding().getBean();
        String whenExpr = this.getVisibleWhen();
        if (whenExpr != null && whenExpr.length() > 0 && bean != null) {
            boolean result = false;
            try {
                result = UIControlUtil.evaluateExprBoolean(bean, whenExpr);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.setVisible(result);
        }
    }

    @Override
    public void load() {
        this.setInputVerifier(UIInputUtil.VERIFIER);
        this.setDocument(this.textDocument);
        String shandler = this.getHandler();
        if (shandler != null) {
            Object obj = UIControlUtil.getBeanValue(this.getBinding(), shandler);
            if (obj instanceof TextDocumentModel) {
                this.handlerObject = (TextDocumentModel)obj;
                this.handlerObject.setProvider(new DocumentProvider());
            } else {
                this.handlerObject = null;
            }
            this.editorModel = obj instanceof TextEditorModel ? (TextEditorModel)obj : null;
            if (obj instanceof TextWriter) {
                this.textWriterObject = (TextWriter)obj;
                this.textWriterObject.setHandler(this.textWriterHandler);
            } else {
                this.textWriterObject = null;
            }
        }
        if (this.getParent() instanceof JViewport && this.getParent().getParent() instanceof JScrollPane) {
            JScrollPane jsp = (JScrollPane)this.getParent().getParent();
            jsp.getVerticalScrollBar().addAdjustmentListener(this.verticalAdjHandler);
        }
    }

    public int compareTo(Object o) {
        return UIControlUtil.compare(this, o);
    }

    @Override
    public Map getInfo() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("focusAccelerator", Character.valueOf(this.getFocusAccelerator()));
        map.put("handler", this.getHandler());
        map.put("exitOnTabKey", this.isExitOnTabKey());
        map.put("nullWhenEmpty", this.isNullWhenEmpty());
        map.put("required", this.isRequired());
        return map;
    }

    @Override
    public void validateInput() {
        this.actionMessage.clearMessages();
        this.property.setErrorMessage(null);
        if (this.isRequired() && ValueUtil.isEmpty((Object)this.getText())) {
            this.actionMessage.addMessage("", "{0} is required", new Object[]{this.getCaption()});
            this.property.setErrorMessage(this.actionMessage.toString());
        }
    }

    @Override
    public int getStretchWidth() {
        return this.stretchWidth;
    }

    @Override
    public void setStretchWidth(int stretchWidth) {
        this.stretchWidth = stretchWidth;
    }

    @Override
    public int getStretchHeight() {
        return this.stretchHeight;
    }

    @Override
    public void setStretchHeight(int stretchHeight) {
        this.stretchHeight = stretchHeight;
    }

    @Override
    public String getVisibleWhen() {
        return this.visibleWhen;
    }

    @Override
    public void setVisibleWhen(String visibleWhen) {
        this.visibleWhen = visibleWhen;
    }

    public boolean isAutoScrollDown() {
        return this.autoScrollDown;
    }

    public void setAutoScrollDown(boolean autoScrollDown) {
        this.autoScrollDown = autoScrollDown;
    }

    public boolean isExitOnTabKey() {
        return this.exitOnTabKey;
    }

    public void setExitOnTabKey(boolean exitOnTabKey) {
        this.exitOnTabKey = exitOnTabKey;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (Beans.isDesignTime()) {
            super.setText(name);
        }
    }

    @Override
    public Object getValue() {
        String text;
        String string = text = this.textWriterObject == null ? this.getText() : null;
        if (ValueUtil.isEmpty((Object)text) && this.nullWhenEmpty) {
            return null;
        }
        if (this.trimSpaceOption != null) {
            text = this.trimSpaceOption.trim(text);
        }
        return text;
    }

    @Override
    public void setValue(Object value) {
        this.setText(value == null ? "" : value.toString());
    }

    @Override
    public boolean isNullWhenEmpty() {
        return this.nullWhenEmpty;
    }

    public void setNullWhenEmpty(boolean nullWhenEmpty) {
        this.nullWhenEmpty = nullWhenEmpty;
    }

    @Override
    public String[] getDepends() {
        return this.depends;
    }

    public void setDepends(String[] depends) {
        this.depends = depends;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    @Override
    public void setBinding(Binding binding) {
        if (this.binding != null) {
            this.binding.getActionHandlerSupport().remove(this.actionHandler);
        }
        this.binding = binding;
        if (binding != null) {
            binding.getActionHandlerSupport().add(this.actionHandler);
        }
    }

    @Override
    public String getCaption() {
        return this.property.getCaption();
    }

    @Override
    public void setCaption(String caption) {
        this.property.setCaption(caption);
    }

    public char getCaptionMnemonic() {
        return this.property.getCaptionMnemonic();
    }

    public void setCaptionMnemonic(char c) {
        this.property.setCaptionMnemonic(c);
    }

    @Override
    public boolean isRequired() {
        return this.property.isRequired();
    }

    @Override
    public void setRequired(boolean required) {
        this.property.setRequired(required);
    }

    public boolean isShowCaption() {
        return this.property.isShowCaption();
    }

    public void setShowCaption(boolean show) {
        this.property.setShowCaption(show);
    }

    public int getCaptionWidth() {
        return this.property.getCaptionWidth();
    }

    public void setCaptionWidth(int width) {
        this.property.setCaptionWidth(width);
    }

    public Font getCaptionFont() {
        return this.property.getCaptionFont();
    }

    public void setCaptionFont(Font f) {
        this.property.setCaptionFont(f);
    }

    public String getCaptionFontStyle() {
        return this.property.getCaptionFontStyle();
    }

    public void setCaptionFontStyle(String captionFontStyle) {
        this.property.setCaptionFontStyle(captionFontStyle);
    }

    public String getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(String fontStyle) {
        this.fontStyle = fontStyle;
        if (this.sourceFont == null) {
            this.sourceFont = super.getFont();
        } else {
            super.setFont(this.sourceFont);
        }
        new FontSupport().applyStyles((JComponent)this, fontStyle);
    }

    public Insets getCellPadding() {
        return this.property.getCellPadding();
    }

    public void setCellPadding(Insets padding) {
        this.property.setCellPadding(padding);
    }

    @Override
    public ActionMessage getActionMessage() {
        return this.actionMessage;
    }

    @Override
    public ControlProperty getControlProperty() {
        return this.property;
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    public TextCase getTextCase() {
        return this.textDocument.getTextCase();
    }

    public void setTextCase(TextCase textCase) {
        this.textDocument.setTextCase(textCase);
    }

    public TrimSpaceOption getTrimSpaceOption() {
        return this.trimSpaceOption;
    }

    public void setTrimSpaceOption(TrimSpaceOption option) {
        this.trimSpaceOption = option;
    }

    @Override
    public boolean isReadonly() {
        return this.readonly;
    }

    @Override
    public void setReadonly(boolean readonly) {
        if (!this.isEnabled()) {
            return;
        }
        this.readonly = readonly;
        this.setEditable(!readonly);
        super.firePropertyChange("editable", readonly, !readonly);
    }

    @Override
    public void setRequestFocus(boolean focus) {
        if (focus) {
            this.requestFocus();
        }
    }

    public String getHint() {
        return this.hint;
    }

    public void setHint(String hint) {
        this.hint = hint;
        this.showHint = !ValueUtil.isEmpty((Object)hint);
    }

    public String getHandler() {
        return this.handler;
    }

    public void setHandler(String handler) {
        this.handler = handler;
    }

    @Override
    public void setPropertyInfo(PropertySupport.PropertyInfo info) {
    }

    public String getItemExpression() {
        return this.itemExpression;
    }

    public void setItemExpression(String itemExpression) {
        this.itemExpression = itemExpression;
    }

    public String getVarName() {
        return this.varName;
    }

    public void setVarName(String varName) {
        this.varName = varName;
    }

    public Color getFocusBackground() {
        return this.focusBackground;
    }

    @Override
    public Color getBackground() {
        Color newColor;
        if (Beans.isDesignTime()) {
            return super.getBackground();
        }
        if (this.enabledBackground == null) {
            this.enabledBackground = UIManager.getLookAndFeelDefaults().getColor("TextField.background");
        }
        if (this.disabledBackground == null) {
            this.disabledBackground = UIManager.getLookAndFeelDefaults().getColor("TextField.disabledBackground");
        }
        Color preferredColor = null;
        boolean enabled = this.isEnabled();
        preferredColor = enabled ? (this.hasFocus() ? ((newColor = this.getFocusBackground()) == null ? this.enabledBackground : newColor) : this.enabledBackground) : this.disabledBackground;
        return preferredColor == null ? super.getBackground() : preferredColor;
    }

    protected void updateBackground() {
        if (this.enabledBackground == null) {
            this.enabledBackground = UIManager.getLookAndFeelDefaults().getColor("TextField.background");
        }
        if (this.disabledBackground == null) {
            this.disabledBackground = UIManager.getLookAndFeelDefaults().getColor("TextField.disabledBackground");
        }
        Color newColor = this.getBackground();
        this.setBackground(newColor);
        this.repaint();
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        if (e.getID() == 1004) {
            this.updateBackground();
        } else if (e.getID() == 1005 && !e.isTemporary()) {
            this.updateBackground();
        }
        super.processFocusEvent(e);
    }

    protected List fetchList(Map params) {
        return this.editorModel == null ? null : this.editorModel.fetchList(params);
    }

    protected Object getFormattedText(Object item) {
        String expression = this.getItemExpression();
        if (expression == null || expression.length() == 0) {
            return item.toString();
        }
        Object exprBean = this.createExpressionBean(item);
        return UIControlUtil.evaluateExpr(exprBean, expression);
    }

    protected String getTemplate(Object item) {
        Object o = this.editorModel == null ? null : this.editorModel.getTemplate(item);
        return o == null ? null : o.toString();
    }

    private Object createExpressionBean(Object itemBean) {
        Object bean = this.getBinding().getBean();
        ExprBeanSupport beanSupport = new ExprBeanSupport(bean);
        beanSupport.setItem(this.getVarName(), itemBean);
        return beanSupport.createProxy();
    }

    private String getSearchtext() {
        try {
            String str;
            int caretpos = this.getCaretPosition();
            StringBuffer sb = new StringBuffer();
            for (int i = caretpos - 1; i >= 0 && !(str = this.getDocument().getText(i, 1)).matches("\\s"); --i) {
                if (sb.length() == 0) {
                    sb.append(str);
                    continue;
                }
                sb.insert(0, str);
            }
            return sb.length() == 0 ? null : sb.toString();
        }
        catch (Throwable t) {
            return null;
        }
    }

    private void fireSearch() {
        if (!this.isEnabled() || !this.isEditable()) {
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("searchtext", this.getSearchtext());
        TimerManager.getInstance().schedule(new LookupTask(params), 300L);
    }

    private int getWhitespacePositionBefore(int pos) {
        try {
            for (int i = pos - 1; i >= 0; --i) {
                String str = this.getDocument().getText(i, 1);
                if (!str.matches("\\s")) continue;
                return i;
            }
            return -1;
        }
        catch (Throwable t) {
            return -1;
        }
    }

    private void fireSelectItem() {
        PopupItem pi = this.getPopup().getSelectedItem();
        if (pi == null) {
            return;
        }
        String template = this.getTemplate(pi.getUserObject());
        if (template == null) {
            template = "";
        }
        Document doc = this.getDocument();
        int doclen = doc.getLength();
        int curpos = this.getCaretPosition();
        int startpos = this.getWhitespacePositionBefore(curpos) + 1;
        try {
            doc.remove(startpos, curpos - startpos);
            doc.insertString(startpos, template, null);
            this.getPopup().setVisible(false);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void fireEscapeKeyEvent() {
        if (this.getPopup().isVisible() && this.getPopup().isShowing()) {
            this.getPopup().setVisible(false);
        }
    }

    protected void fireMoveDown() {
        if (this.getPopup().isVisible() && this.getPopup().isShowing()) {
            this.getPopup().moveDown();
        }
    }

    protected void fireMoveUp() {
        if (this.getPopup().isVisible() && this.getPopup().isShowing()) {
            this.getPopup().moveUp();
        }
    }

    private TextEditorPopupSelector getPopup() {
        if (this.jpopup == null) {
            this.jpopup = new TextEditorPopupSelector(this);
            this.jpopup.add(new TextEditorPopupSelector.SelectionListener(){

                @Override
                public void onselect(PopupItem item) {
                    XTextArea.this.fireSelectItem();
                }
            });
        }
        return this.jpopup;
    }

    private void showPopup() {
        try {
            Rectangle rect = this.modelToView(this.getCaretPosition());
            TextEditorPopupSelector popup = this.getPopup();
            popup.pack();
            popup.setSize(100, 20);
            popup.show(this, rect.x, rect.y + rect.height);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private class TextWriterHandler
    implements TextWriter.Handler {
        XTextArea root;

        private TextWriterHandler() {
            this.root = XTextArea.this;
        }

        @Override
        public void write(String str) {
            this.root.append(str == null ? "null" : str);
            this.root.verticalAdjHandler.setAllowScrollDown(true);
            this.repaint();
        }

        @Override
        public void clear() {
            this.root.setText("");
            this.repaint();
        }

        private void repaint() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TextWriterHandler.this.root.repaint();
                }
            });
        }
    }

    private class VerticalAdjustmentListener
    implements AdjustmentListener {
        XTextArea root;
        private boolean allowScrollDown;

        private VerticalAdjustmentListener() {
            this.root = XTextArea.this;
        }

        public void setAllowScrollDown(boolean allowScrollDown) {
            this.allowScrollDown = allowScrollDown;
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            if (this.allowScrollDown || this.root.isAutoScrollDown()) {
                e.getAdjustable().setValue(e.getAdjustable().getMaximum());
                this.allowScrollDown = false;
            }
        }
    }

    private class ResultDataLoader
    implements Runnable {
        XTextArea root;
        private List result;

        ResultDataLoader(List result) {
            this.root = XTextArea.this;
            this.result = result;
        }

        @Override
        public void run() {
            TextEditorPopupSelector popup = this.root.getPopup();
            if (this.result == null || this.result.isEmpty()) {
                popup.setVisible(false);
                return;
            }
            ArrayList<PopupItem> items = new ArrayList<PopupItem>();
            for (int i = 0; i < popup.getRowSize(); ++i) {
                try {
                    Object o = this.result.get(i);
                    Object caption = this.root.getFormattedText(o);
                    items.add(new PopupItem(o, caption == null ? "" : caption.toString()));
                    continue;
                }
                catch (Throwable t) {
                    break;
                }
            }
            if (items.isEmpty()) {
                popup.setVisible(false);
                return;
            }
            popup.setData(items);
            XTextArea.this.showPopup();
        }
    }

    private class LookupTask
    implements Runnable {
        XTextArea root;
        private String searchtext;
        private Map params;

        LookupTask(Map params) {
            this.root = XTextArea.this;
            this.params = params;
            this.searchtext = params == null ? null : (String)params.get("searchtext");
        }

        @Override
        public void run() {
            String str = this.root.getSearchtext() + "";
            if (!str.equals(this.searchtext + "")) {
                return;
            }
            List list = this.root.fetchList(this.params);
            EventQueue.invokeLater(new ResultDataLoader(list));
        }
    }

    private class ActionHandlerImpl
    implements ActionHandler {
        XTextArea root;

        private ActionHandlerImpl() {
            this.root = XTextArea.this;
        }

        @Override
        public void onBeforeExecute() {
        }

        @Override
        public void onAfterExecute() {
            if (this.root.isReadonly() || !this.root.isEnabled() || !this.root.isEditable()) {
                return;
            }
            if (!this.root.textDocument.isDirty()) {
                return;
            }
            UIInputUtil.updateBeanValue(this.root);
        }
    }

    private class DocumentProvider
    implements DocViewModel.Provider {
        private XTextArea root;

        private DocumentProvider() {
            this.root = XTextArea.this;
        }

        @Override
        public String getText() {
            return this.root.getText();
        }

        @Override
        public void setText(String text) {
            this.root.setText(text == null ? "" : text);
            this.repaint();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertText(String text) {
            if (text == null) {
                return;
            }
            int caretPos = this.root.getCaretPosition();
            try {
                int caretCharPos;
                int n = caretCharPos = text == null ? -1 : text.indexOf(124);
                if (caretCharPos >= 0) {
                    StringBuffer sb = new StringBuffer();
                    sb.append(text.substring(0, caretCharPos));
                    sb.append(' ');
                    sb.append(text.substring(caretCharPos + 1));
                    text = sb.toString();
                }
                this.root.textDocument.insertString(caretPos, text, null);
                if (caretCharPos >= 0) {
                    this.root.setCaretPosition(caretPos + caretCharPos);
                }
            }
            catch (BadLocationException ex) {
                System.out.println("[XTextArea] failed to insert text at position " + caretPos + " caused by " + ex.getMessage());
            }
            finally {
                this.repaint();
            }
        }

        @Override
        public void appendText(String text) {
            this.root.append(text == null ? "null" : text);
            this.root.verticalAdjHandler.setAllowScrollDown(true);
            this.repaint();
        }

        @Override
        public void requestFocus() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DocumentProvider.this.root.requestFocus();
                    DocumentProvider.this.root.grabFocus();
                }
            });
        }

        @Override
        public void load() {
            this.root.load();
        }

        @Override
        public void refresh() {
            this.root.refresh();
        }

        private void repaint() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DocumentProvider.this.root.repaint();
                }
            });
        }

        @Override
        public int getWidth() {
            return 0;
        }

        @Override
        public int getHeight() {
            return 0;
        }
    }
}

