/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control;

import com.rameses.common.MethodResolver;
import com.rameses.rcp.common.MsgBox;
import com.rameses.rcp.common.Opener;
import com.rameses.rcp.common.PropertySupport;
import com.rameses.rcp.common.TextColumnHandler;
import com.rameses.rcp.constant.TextCase;
import com.rameses.rcp.constant.TrimSpaceOption;
import com.rameses.rcp.control.text.DefaultTextField;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.support.MouseEventSupport;
import com.rameses.rcp.support.TextDocument;
import com.rameses.rcp.ui.ActiveControl;
import com.rameses.rcp.ui.ControlProperty;
import com.rameses.rcp.ui.UIInput;
import com.rameses.rcp.ui.Validatable;
import com.rameses.rcp.util.ActionMessage;
import com.rameses.rcp.util.UIControlUtil;
import com.rameses.rcp.util.UIInputUtil;
import com.rameses.util.ValueUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.InputVerifier;

public class XTextField
extends DefaultTextField
implements UIInput,
Validatable,
ActiveControl,
MouseEventSupport.ComponentInfo {
    protected Binding binding;
    protected ControlProperty property = new ControlProperty();
    protected ActionMessage actionMessage = new ActionMessage();
    private int index;
    private char spaceChar;
    private String[] replaceExpr;
    private String[] replaceString;
    private String[] depends = new String[0];
    private String hint;
    private String inputFormat;
    private String inputFormatErrorMsg;
    private boolean nullWhenEmpty = true;
    private boolean showHint;
    private boolean isHintShown;
    private TextDocument document = new TextDocument();
    private TrimSpaceOption trimSpaceOption = TrimSpaceOption.ALL;
    private ActionCommandInvoker actionCommandInvoker;
    private String securityPattern;
    private String securityChar;
    private String securedValue;
    private int stretchWidth;
    private int stretchHeight;
    private KeyEvent keValue;

    public XTextField() {
        this.initComponent();
    }

    private void initComponent() {
        this.document.setTextCase(TextCase.UPPER);
        this.actionCommandInvoker = new ActionCommandInvoker();
        this.addActionMapping("ACTION_MAPPING_KEY_ESCAPE", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    XTextField.this.refresh();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        new MouseEventSupport(this).install();
    }

    @Override
    public void paint(Graphics origGraphics) {
        super.paint(origGraphics);
        if (this.showHint && this.getDocument().getLength() == 0) {
            Graphics g = origGraphics.create();
            Font f = this.getFont();
            FontMetrics fm = g.getFontMetrics(f);
            g.setColor(Color.LIGHT_GRAY);
            g.setFont(f);
            Insets margin = this.getInsets();
            int width = this.getWidth() - 1 - margin.left - margin.right;
            int height = this.getHeight() - 1 - margin.top - margin.bottom;
            int x = margin.left;
            int y = height / 2 + fm.getAscent() / 2 + margin.top;
            g.setClip(margin.left, margin.top, width, height);
            g.drawString(" " + this.getHint(), x, y);
            g.dispose();
        }
    }

    @Override
    public void refresh() {
        block12: {
            try {
                this.updateBackground();
                String whenExpr = this.getVisibleWhen();
                if (whenExpr != null && whenExpr.length() > 0) {
                    boolean result = false;
                    try {
                        result = UIControlUtil.evaluateExprBoolean(this.binding.getBean(), whenExpr);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    this.setVisible(result);
                }
                if ((whenExpr = this.getDisableWhen()) != null && whenExpr.length() > 0) {
                    boolean disabled = false;
                    try {
                        disabled = UIControlUtil.evaluateExprBoolean(this.binding.getBean(), whenExpr);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    this.setEnabled(!disabled);
                }
                Object value = UIControlUtil.getBeanValue(this);
                if (this.isSecured()) {
                    this.securedValue = (String)value;
                    String txtValue = "";
                    if (value != null) {
                        StringBuffer text = new StringBuffer();
                        Matcher m = Pattern.compile(this.securityPattern).matcher(value.toString());
                        while (m.find()) {
                            m.appendReplacement(text, this.repeat(this.securityChar, m.group().length()));
                        }
                        m.appendTail(text);
                        txtValue = text.toString();
                    }
                    super.setText(txtValue);
                } else {
                    this.setValue(value);
                }
            }
            catch (Exception e) {
                this.setText("");
                if (!ClientContext.getCurrentContext().isDebugMode()) break block12;
                e.printStackTrace();
            }
        }
    }

    private String repeat(String str, int count) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < count && sb.length() < count; ++i) {
            sb.append(str);
        }
        if (sb.length() > count) {
            sb.setLength(count);
        }
        return sb.toString();
    }

    @Override
    protected InputVerifier getChildInputVerifier() {
        return UIInputUtil.VERIFIER;
    }

    @Override
    public void load() {
        String cmd;
        this.setDocument(this.document);
        if (this.showHint) {
            this.isHintShown = true;
        }
        if ((cmd = this.getActionCommand()) != null && cmd.length() > 0) {
            this.removeActionMapping("ACTION_MAPPING_KEY_ENTER", this.actionCommandInvoker);
            this.addActionMapping("ACTION_MAPPING_KEY_ENTER", this.actionCommandInvoker);
        }
    }

    public int compareTo(Object o) {
        return UIControlUtil.compare(this, o);
    }

    @Override
    public void validateInput() {
        this.actionMessage.clearMessages();
        this.property.setErrorMessage(null);
        if (ValueUtil.isEmpty((Object)this.getText())) {
            if (this.isRequired()) {
                this.actionMessage.addMessage("1001", "{0} is required.", new Object[]{this.getCaption()});
            }
        } else if (!ValueUtil.isEmpty((Object)this.inputFormat) && !this.getText().matches(this.inputFormat)) {
            String msg = null;
            msg = this.inputFormatErrorMsg != null ? this.inputFormatErrorMsg : "Invalid input format for {0}";
            this.actionMessage.addMessage(null, msg, new Object[]{this.getCaption()});
        }
        if (this.actionMessage.hasMessages()) {
            this.property.setErrorMessage(this.actionMessage.toString());
        }
    }

    @Override
    public Map getInfo() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("actionCommand", this.getActionCommand());
        map.put("nullWhenEmpty", this.isNullWhenEmpty());
        map.put("required", this.isRequired());
        map.put("focusAccelerator", Character.valueOf(this.getFocusAccelerator()));
        return map;
    }

    @Override
    public int getStretchWidth() {
        return this.stretchWidth;
    }

    @Override
    public void setStretchWidth(int stretchWidth) {
        this.stretchWidth = stretchWidth;
    }

    @Override
    public int getStretchHeight() {
        return this.stretchHeight;
    }

    @Override
    public void setStretchHeight(int stretchHeight) {
        this.stretchHeight = stretchHeight;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        super.setText(name);
    }

    @Override
    public Object getValue() {
        if (this.isSecured()) {
            return this.securedValue;
        }
        String txtValue = this.getText();
        if (ValueUtil.isEmpty((Object)txtValue) && this.nullWhenEmpty) {
            return null;
        }
        if (this.trimSpaceOption != null) {
            txtValue = this.trimSpaceOption.trim(txtValue);
        }
        if (this.replaceExpr != null && this.replaceString != null) {
            for (int i = 0; i < this.replaceExpr.length && this.replaceString.length > i; ++i) {
                txtValue = txtValue.replaceAll(this.replaceExpr[i], this.replaceString[i]);
            }
        }
        txtValue = this.renderSpaceChar(txtValue);
        super.setText(txtValue);
        return txtValue;
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof EventObject) {
            if (value instanceof KeyEvent) {
                KeyEvent ke = (KeyEvent)value;
                String sval = ke.getKeyChar() + "";
                super.setText(sval);
            }
        } else {
            this.setText(value == null ? "" : value.toString());
        }
    }

    @Override
    public String[] getDepends() {
        return this.depends;
    }

    public void setDepends(String[] depends) {
        this.depends = depends;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    @Override
    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    @Override
    public ActionMessage getActionMessage() {
        return this.actionMessage;
    }

    @Override
    public ControlProperty getControlProperty() {
        return this.property;
    }

    @Override
    public boolean isRequired() {
        return this.property.isRequired();
    }

    @Override
    public void setRequired(boolean required) {
        this.property.setRequired(required);
    }

    @Override
    public String getCaption() {
        return this.property.getCaption();
    }

    @Override
    public void setCaption(String caption) {
        this.property.setCaption(caption);
    }

    public char getCaptionMnemonic() {
        return this.property.getCaptionMnemonic();
    }

    public void setCaptionMnemonic(char c) {
        this.property.setCaptionMnemonic(c);
    }

    public int getCaptionWidth() {
        return this.property.getCaptionWidth();
    }

    public void setCaptionWidth(int width) {
        this.property.setCaptionWidth(width);
    }

    @Override
    public boolean isNullWhenEmpty() {
        return this.nullWhenEmpty;
    }

    public void setNullWhenEmpty(boolean nullWhenEmpty) {
        this.nullWhenEmpty = nullWhenEmpty;
    }

    public boolean isShowCaption() {
        return this.property.isShowCaption();
    }

    public void setShowCaption(boolean showCaption) {
        this.property.setShowCaption(showCaption);
    }

    public Font getCaptionFont() {
        return this.property.getCaptionFont();
    }

    public void setCaptionFont(Font f) {
        this.property.setCaptionFont(f);
    }

    public String getCaptionFontStyle() {
        return this.property.getCaptionFontStyle();
    }

    public void setCaptionFontStyle(String captionFontStyle) {
        this.property.setCaptionFontStyle(captionFontStyle);
    }

    public Insets getCellPadding() {
        return this.property.getCellPadding();
    }

    public void setCellPadding(Insets padding) {
        this.property.setCellPadding(padding);
    }

    public TextCase getTextCase() {
        return this.document.getTextCase();
    }

    public void setTextCase(TextCase textCase) {
        this.document.setTextCase(textCase);
    }

    public int getMaxLength() {
        return this.document.getMaxlength();
    }

    public void setMaxLength(int length) {
        this.document.setMaxlength(length);
    }

    public TrimSpaceOption getTrimSpaceOption() {
        return this.trimSpaceOption;
    }

    public void setTrimSpaceOption(TrimSpaceOption option) {
        this.trimSpaceOption = option;
    }

    @Override
    public void setRequestFocus(boolean focus) {
        if (focus) {
            this.requestFocus();
        }
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    @Override
    public String getHint() {
        return this.hint;
    }

    @Override
    public void setHint(String hint) {
        this.hint = hint;
        this.showHint = !ValueUtil.isEmpty((Object)hint);
    }

    public String getInputFormat() {
        return this.inputFormat;
    }

    public void setInputFormat(String inputFormat) {
        this.inputFormat = inputFormat;
    }

    public String getInputFormatErrorMsg() {
        return this.inputFormatErrorMsg;
    }

    public void setInputFormatErrorMsg(String inputFormatErrorMsg) {
        this.inputFormatErrorMsg = inputFormatErrorMsg;
    }

    public String[] getReplaceExpr() {
        return this.replaceExpr;
    }

    public void setReplaceExpr(String[] replaceExpr) {
        this.replaceExpr = replaceExpr;
    }

    public String[] getReplaceString() {
        return this.replaceString;
    }

    public void setReplaceString(String[] replaceString) {
        this.replaceString = replaceString;
    }

    public String getSecurityPattern() {
        return this.securityPattern;
    }

    public void setSecurityPattern(String securityPattern) {
        this.securityPattern = securityPattern;
    }

    public String getSecurityChar() {
        return this.securityChar;
    }

    public void setSecurityChar(String securityChar) {
        this.securityChar = securityChar;
    }

    public boolean isSecured() {
        return this.securityPattern != null && this.securityPattern.length() > 0 && this.securityChar != null && this.securityChar.length() > 0;
    }

    public char getSpaceChar() {
        return this.spaceChar;
    }

    public void setSpaceChar(char spaceChar) {
        this.spaceChar = spaceChar;
    }

    @Override
    public void setPropertyInfo(PropertySupport.PropertyInfo info) {
        if (!(info instanceof TextColumnHandler)) {
            return;
        }
        TextColumnHandler chandler = (TextColumnHandler)info;
        if (chandler.getColumn() == null) {
            return;
        }
        TextCase textcase = chandler.getColumn().getTextCase();
        if (textcase != null) {
            this.document.setTextCase(textcase);
        }
    }

    public TextDocument.Filter getFilter() {
        return this.document == null ? null : this.document.getFilter();
    }

    public void setFilter(TextDocument.Filter filter) {
        if (this.document != null) {
            this.document.setFilter(filter);
        }
    }

    private String renderSpaceChar(String value) {
        if (value != null && this.spaceChar != '\u0000') {
            value = value.replaceAll(" ", String.valueOf(this.spaceChar));
        }
        return value;
    }

    private class ActionCommandInvoker
    implements ActionListener {
        XTextField root;

        private ActionCommandInvoker() {
            this.root = XTextField.this;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                String cmd = this.root.getActionCommand();
                if (cmd == null || cmd.length() == 0) {
                    return;
                }
                UIInputUtil.updateBeanValue(this.root);
                Object bean = this.root.getBinding().getBean();
                Object outcome = MethodResolver.getInstance().invoke(bean, cmd, new Object[0]);
                if (outcome instanceof Opener) {
                    this.root.getBinding().fireNavigation(outcome);
                }
            }
            catch (Throwable t) {
                MsgBox.err(t);
            }
        }
    }
}

