/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.border.AbstractBorder;

public class XEtchedBorder
extends AbstractBorder {
    private Color highlight;
    private Color shadow;
    private Insets padding;
    private boolean raised;
    private boolean hideTop;
    private boolean hideLeft;
    private boolean hideBottom;
    private boolean hideRight;

    public XEtchedBorder() {
        this(null, null, false);
    }

    public XEtchedBorder(Color highlight, Color shadow, boolean raised) {
        this.highlight = highlight;
        this.shadow = shadow;
        this.raised = raised;
        this.setPadding(null);
    }

    public Color getHighlightColor() {
        return this.highlight;
    }

    public void setHighlightColor(Color highlight) {
        this.highlight = highlight;
    }

    public Color getShadowColor() {
        return this.shadow;
    }

    public void setShadowColor(Color shadow) {
        this.shadow = shadow;
    }

    public boolean isRaised() {
        return this.raised;
    }

    public void setRaised(boolean raised) {
        this.raised = raised;
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets padding) {
        this.padding = padding == null ? new Insets(0, 0, 0, 0) : padding;
    }

    public boolean isHideTop() {
        return this.hideTop;
    }

    public void setHideTop(boolean hideTop) {
        this.hideTop = hideTop;
    }

    public boolean isHideLeft() {
        return this.hideLeft;
    }

    public void setHideLeft(boolean hideLeft) {
        this.hideLeft = hideLeft;
    }

    public boolean isHideBottom() {
        return this.hideBottom;
    }

    public void setHideBottom(boolean hideBottom) {
        this.hideBottom = hideBottom;
    }

    public boolean isHideRight() {
        return this.hideRight;
    }

    public void setHideRight(boolean hideRight) {
        this.hideRight = hideRight;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        Insets ins = new Insets(0, 0, 0, 0);
        return this.getBorderInsets(c, ins);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets ins) {
        if (ins == null) {
            ins = new Insets(0, 0, 0, 0);
        }
        ins.right = 0;
        ins.bottom = 0;
        ins.left = 0;
        ins.top = 0;
        if (!this.isHideTop()) {
            ins.top += 2;
        }
        if (!this.isHideLeft()) {
            ins.left += 2;
        }
        if (!this.isHideBottom()) {
            ins.bottom += 2;
        }
        if (!this.isHideRight()) {
            ins.right += 2;
        }
        ins.top += this.padding.top;
        ins.left += this.padding.left;
        ins.bottom += this.padding.bottom;
        ins.right += this.padding.right;
        return ins;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color oldColor = g.getColor();
        Color shadColor = this.getShadowColor(c);
        Color highColor = this.getHighlightColor(c);
        if (!this.isHideLeft()) {
            g2.setColor(shadColor);
            g2.drawLine(x, y, x, height);
            g2.setColor(highColor);
            g2.drawLine(x + 1, y + 1, x + 1, height);
        }
        if (!this.isHideRight()) {
            g2.setColor(shadColor);
            g2.drawLine(width - 2, y, width - 2, height);
            g2.setColor(highColor);
            g2.drawLine(width - 1, y, width - 1, height);
        }
        if (!this.isHideTop()) {
            g2.setColor(shadColor);
            g2.drawLine(x, y, width, y);
            g2.setColor(highColor);
            g2.drawLine(x + 1, y + 1, width, y + 1);
        }
        if (!this.isHideBottom()) {
            g2.setColor(shadColor);
            g2.drawLine(x, height - 2, width, height - 2);
            g2.setColor(highColor);
            g2.drawLine(x, height - 1, width, height - 1);
        }
        g2.dispose();
    }

    protected Color getHighlightColor(Component c) {
        Color color = this.getHighlightColor();
        return color != null ? color : c.getBackground().brighter();
    }

    protected Color getShadowColor(Component c) {
        Color color = this.getShadowColor();
        return color != null ? color : c.getBackground().darker();
    }
}

