/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;

public class XLineBorder
extends AbstractBorder {
    private Border sourceBorder;
    private Color color;
    private Insets padding;
    private int thickness;
    private boolean hideTop;
    private boolean hideLeft;
    private boolean hideBottom;
    private boolean hideRight;

    public XLineBorder() {
        this.color = Color.BLACK;
        this.thickness = 1;
        this.padding = new Insets(0, 0, 0, 0);
    }

    public XLineBorder(Color color, int thickness, Insets padding, boolean hideTop, boolean hideLeft, boolean hideBottom, boolean hideRight) {
        this.color = color;
        this.thickness = Math.max(thickness, 1);
        this.padding = padding;
        this.hideTop = hideTop;
        this.hideLeft = hideLeft;
        this.hideBottom = hideBottom;
        this.hideRight = hideRight;
    }

    public Color getLineColor() {
        return this.color;
    }

    public void setLineColor(Color color) {
        this.color = color;
    }

    public int getThickness() {
        return this.thickness;
    }

    public void setThickness(int thickness) {
        this.thickness = thickness;
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets padding) {
        this.padding = padding == null ? new Insets(0, 0, 0, 0) : padding;
    }

    public boolean isHideTop() {
        return this.hideTop;
    }

    public void setHideTop(boolean hideTop) {
        this.hideTop = hideTop;
    }

    public boolean isHideLeft() {
        return this.hideLeft;
    }

    public void setHideLeft(boolean hideLeft) {
        this.hideLeft = hideLeft;
    }

    public boolean isHideBottom() {
        return this.hideBottom;
    }

    public void setHideBottom(boolean hideBottom) {
        this.hideBottom = hideBottom;
    }

    public boolean isHideRight() {
        return this.hideRight;
    }

    public void setHideRight(boolean hideRight) {
        this.hideRight = hideRight;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        Insets ins = new Insets(0, 0, 0, 0);
        return this.getBorderInsets(c, ins);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets ins) {
        if (ins == null) {
            ins = new Insets(0, 0, 0, 0);
        }
        ins.right = 0;
        ins.bottom = 0;
        ins.left = 0;
        ins.top = 0;
        int thickness = this.getThickness();
        if (thickness > 0) {
            if (!this.isHideTop()) {
                ins.top += thickness;
            }
            if (!this.isHideLeft()) {
                ins.left += thickness;
            }
            if (!this.isHideBottom()) {
                ins.bottom += thickness;
            }
            if (!this.isHideRight()) {
                ins.right += thickness;
            }
        }
        ins.top += this.padding.top;
        ins.left += this.padding.left;
        ins.bottom += this.padding.bottom;
        ins.right += this.padding.right;
        return ins;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int i;
        int thickness = this.getThickness();
        if (thickness <= 0) {
            return;
        }
        Color color = this.getLineColor();
        if (color == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(color);
        if (!this.isHideTop()) {
            for (i = 0; i < thickness; ++i) {
                g2.drawLine(x, y + i, width, y + i);
            }
        }
        if (!this.isHideLeft()) {
            for (i = 0; i < thickness; ++i) {
                g2.drawLine(x + i, y, x + i, height);
            }
        }
        if (!this.isHideBottom()) {
            for (i = 1; i <= thickness; ++i) {
                g2.drawLine(x, height - i, width, height - i);
            }
        }
        if (!this.isHideRight()) {
            for (i = 1; i <= thickness; ++i) {
                g2.drawLine(width - i, y, width - i, height);
            }
        }
        g2.dispose();
    }
}

