/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.date;

import com.rameses.rcp.control.date.DatePickerModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MonthCalendarRenderer
extends JPanel {
    private JButton previousMonth = new JButton("<");
    private JButton nextMonth = new JButton(">");
    private JButton previousYear = new JButton("<");
    private JButton nextYear = new JButton(">");
    private JLabel displayMonth = new JLabel();
    private JLabel displayYear = new JLabel();
    private GridBagConstraints gridBagCons = new GridBagConstraints();
    private JPanel panel = new JPanel();
    private JPanel datePanel = new JPanel();
    private Calendar calendar = Calendar.getInstance();
    private Calendar resultDate = Calendar.getInstance();
    private int currDay;
    private int days;
    private String[] months = new String[]{"JANUARY", "FEBRUARY", "MARCH", "APRIL", "MAY", "JUNE", "JULY", "AUGUST", "SEPTEMBER", "OCTOBER", "NOVEMBER", "DECEMBER"};
    private JLabel[] lblDays = new JLabel[56];
    private Color normalFontColor;
    private Color normalBackgroundColor;
    private Font normalFont;
    private Color selectedFontColor;
    private Color selectedBackgroundColor;
    private Font selectedFont;
    private SimpleDateFormat selectedValueFormat = new SimpleDateFormat("yyyy-MM-dd");
    private String selectedValue;
    private DatePickerModel parent;
    private Listener listener;

    public MonthCalendarRenderer() {
        this.init();
    }

    public MonthCalendarRenderer(DatePickerModel parent) {
        this();
        this.parent = parent;
    }

    public void init() {
        this.normalFont = new Font(this.getFont().getName(), 0, this.getFont().getSize());
        this.selectedFont = new Font(this.normalFont.getName(), 1, this.normalFont.getSize());
        this.calendar.setFirstDayOfWeek(1);
        this.days = this.calendar.getActualMaximum(5);
        for (int i = 0; i < this.lblDays.length; ++i) {
            this.lblDays[i] = new JLabel();
            this.lblDays[i].setOpaque(true);
            this.lblDays[i].addMouseListener(new AbstractCalendarSupport());
            this.lblDays[i].setPreferredSize(new Dimension(32, 24));
            this.lblDays[i].setHorizontalAlignment(0);
        }
        this.nextYear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MonthCalendarRenderer.this.calendar.add(1, 1);
                MonthCalendarRenderer.this.displayYear.setText("" + MonthCalendarRenderer.this.calendar.get(1));
                MonthCalendarRenderer.this.resultDate.set(MonthCalendarRenderer.this.calendar.get(1), MonthCalendarRenderer.this.resultDate.get(2), MonthCalendarRenderer.this.resultDate.get(5));
                MonthCalendarRenderer.this.buildCalendar();
                MonthCalendarRenderer.this.setSelectedValue(MonthCalendarRenderer.this.selectedValueFormat.format(MonthCalendarRenderer.this.resultDate.getTime()));
                MonthCalendarRenderer.this.parent.setSelectedValue(MonthCalendarRenderer.this.getSelectedValue());
            }
        });
        this.previousYear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MonthCalendarRenderer.this.calendar.add(1, -1);
                MonthCalendarRenderer.this.displayYear.setText("" + MonthCalendarRenderer.this.calendar.get(1));
                MonthCalendarRenderer.this.resultDate.set(MonthCalendarRenderer.this.calendar.get(1), MonthCalendarRenderer.this.resultDate.get(2), MonthCalendarRenderer.this.resultDate.get(5));
                MonthCalendarRenderer.this.buildCalendar();
                MonthCalendarRenderer.this.setSelectedValue(MonthCalendarRenderer.this.selectedValueFormat.format(MonthCalendarRenderer.this.resultDate.getTime()));
                MonthCalendarRenderer.this.parent.setSelectedValue(MonthCalendarRenderer.this.getSelectedValue());
            }
        });
        this.nextMonth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MonthCalendarRenderer.this.calendar.add(2, 1);
                MonthCalendarRenderer.this.displayMonth.setText("" + MonthCalendarRenderer.this.months[MonthCalendarRenderer.this.calendar.get(2)]);
                MonthCalendarRenderer.this.displayYear.setText("" + MonthCalendarRenderer.this.calendar.get(1));
                MonthCalendarRenderer.this.resultDate.set(MonthCalendarRenderer.this.resultDate.get(1), MonthCalendarRenderer.this.calendar.get(2), MonthCalendarRenderer.this.resultDate.get(5));
                MonthCalendarRenderer.this.buildCalendar();
                MonthCalendarRenderer.this.setSelectedValue(MonthCalendarRenderer.this.selectedValueFormat.format(MonthCalendarRenderer.this.resultDate.getTime()));
                MonthCalendarRenderer.this.parent.setSelectedValue(MonthCalendarRenderer.this.getSelectedValue());
            }
        });
        this.previousMonth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MonthCalendarRenderer.this.calendar.add(2, -1);
                MonthCalendarRenderer.this.displayMonth.setText("" + MonthCalendarRenderer.this.months[MonthCalendarRenderer.this.calendar.get(2)]);
                MonthCalendarRenderer.this.displayYear.setText("" + MonthCalendarRenderer.this.calendar.get(1));
                MonthCalendarRenderer.this.resultDate.set(MonthCalendarRenderer.this.resultDate.get(1), MonthCalendarRenderer.this.calendar.get(2), MonthCalendarRenderer.this.resultDate.get(5));
                MonthCalendarRenderer.this.buildCalendar();
                MonthCalendarRenderer.this.setSelectedValue(MonthCalendarRenderer.this.selectedValueFormat.format(MonthCalendarRenderer.this.resultDate.getTime()));
                MonthCalendarRenderer.this.parent.setSelectedValue(MonthCalendarRenderer.this.getSelectedValue());
            }
        });
        this.setLayout(new BorderLayout());
        this.panel.add(this.previousMonth);
        this.panel.add(this.displayMonth);
        this.panel.add(this.nextMonth);
        this.panel.add(this.previousYear);
        this.panel.add(this.displayYear);
        this.panel.add(this.nextYear);
        this.add((Component)this.panel, "North");
        this.datePanel.setLayout(new GridBagLayout());
        this.lblDays[1] = new JLabel("Sun");
        this.lblDays[2] = new JLabel("Mon");
        this.lblDays[3] = new JLabel("Tue");
        this.lblDays[4] = new JLabel("Wed");
        this.lblDays[5] = new JLabel("Thu");
        this.lblDays[6] = new JLabel("Fri");
        this.lblDays[7] = new JLabel("Sat");
        this.currDay = 0;
        for (int y = 1; y < 8; ++y) {
            for (int x = 1; x < 8; ++x) {
                ++this.currDay;
                this.gridBagCons.gridx = x;
                this.gridBagCons.gridy = y;
                if (this.currDay >= this.lblDays.length) continue;
                this.datePanel.add((Component)this.lblDays[this.currDay], this.gridBagCons);
            }
        }
        this.add((Component)this.datePanel, "Center");
        this.displayMonth.setText("" + this.months[this.calendar.get(2)]);
        this.displayYear.setText("" + this.calendar.get(1));
        this.buildCalendar();
        this.normalFontColor = this.getForeground();
        this.normalBackgroundColor = this.getBackground();
    }

    public void buildCalendar() {
        int i;
        this.currDay = 0;
        this.calendar.set(this.calendar.get(1), this.calendar.get(2), 1);
        this.days = this.calendar.getActualMaximum(5);
        for (i = this.calendar.get(7) + 7; i < this.days + this.calendar.get(7) + 7; ++i) {
            ++this.currDay;
            if (this.resultDate.get(5) == this.currDay) {
                this.lblDays[i].setFont(this.selectedFont);
                this.lblDays[i].setBackground(this.selectedBackgroundColor);
                this.lblDays[i].setForeground(this.selectedFontColor);
            } else {
                this.lblDays[i].setFont(this.normalFont);
                this.lblDays[i].setBackground(this.normalBackgroundColor);
                this.lblDays[i].setForeground(this.normalFontColor);
            }
            this.lblDays[i].setText("" + this.currDay);
        }
        for (i = 8; i < this.calendar.get(7) + 7; ++i) {
            this.lblDays[i].setBackground(this.normalBackgroundColor);
            this.lblDays[i].setForeground(this.normalFontColor);
            this.lblDays[i].setText(" ");
            this.lblDays[i].setFont(this.normalFont);
        }
        for (i = this.days + this.calendar.get(7) + 7; i < this.lblDays.length; ++i) {
            this.lblDays[i].setBackground(this.normalBackgroundColor);
            this.lblDays[i].setForeground(this.normalFontColor);
            this.lblDays[i].setText(" ");
            this.lblDays[i].setFont(this.normalFont);
        }
    }

    public Color getSelectedFontColor() {
        return this.selectedFontColor;
    }

    public void setSelectedFontColor(Color selectedFontColor) {
        this.selectedFontColor = selectedFontColor;
    }

    public Color getSelectedBackgroundColor() {
        return this.selectedBackgroundColor;
    }

    public void setSelectedBackgroundColor(Color selectedBackgroundColor) {
        this.selectedBackgroundColor = selectedBackgroundColor;
    }

    public String getSelectedValue() {
        return this.selectedValue;
    }

    public void setSelectedValue(String selectedValue) {
        this.selectedValue = selectedValue;
    }

    public Listener getListener() {
        return this.listener;
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public static interface Listener {
        public void onSelect(Object var1);
    }

    private class AbstractCalendarSupport
    implements MouseListener {
        private AbstractCalendarSupport() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            try {
                if (e.getSource() instanceof JLabel) {
                    String result = ((JLabel)e.getSource()).getText();
                    MonthCalendarRenderer.this.resultDate.set(MonthCalendarRenderer.this.calendar.get(1), MonthCalendarRenderer.this.calendar.get(2), Integer.parseInt(result));
                    MonthCalendarRenderer.this.buildCalendar();
                    MonthCalendarRenderer.this.setSelectedValue(MonthCalendarRenderer.this.selectedValueFormat.format(MonthCalendarRenderer.this.resultDate.getTime()));
                    MonthCalendarRenderer.this.parent.setSelectedValue(MonthCalendarRenderer.this.getSelectedValue());
                    if (MonthCalendarRenderer.this.listener != null) {
                        MonthCalendarRenderer.this.listener.onSelect(MonthCalendarRenderer.this.getSelectedValue());
                    }
                } else {
                    e.consume();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }
}

