/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.image;

import com.rameses.rcp.control.image.ImageCropItem;
import com.rameses.rcp.control.image.ImageCropToolbar;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class ImageCropPanel
extends JPanel {
    private Dimension cropSize;
    private ImageCropItem imageView;
    private ImageCropToolbar imageToolbar;

    public ImageCropPanel() {
        this.initComponent();
    }

    private void initComponent() {
        super.setLayout(new DefaultLayout());
        this.imageToolbar = new ImageCropToolbar();
        this.add(this.imageToolbar);
        this.imageView = new ImageCropItem();
        this.add(this.imageView);
        this.imageToolbar.setAction("zoom-in", new ZoomInAction());
        this.imageToolbar.setAction("zoom-out", new ZoomOutAction());
        this.imageToolbar.setAction("fit-screen", new FitScreenAction());
    }

    @Override
    public void setLayout(LayoutManager layoutManager) {
    }

    public Dimension getCropSize() {
        return this.cropSize;
    }

    public void setCropSize(int width, int height) {
        this.cropSize = new Dimension(width, height);
        this.imageView.setBoxWidth(width);
        this.imageView.setBoxHeight(height);
    }

    public BufferedImage getCropImage() {
        return this.imageView.getCropImage();
    }

    public void loadImage(File file) {
        try {
            this.loadImage(new ImageIcon(file.toURI().toURL()));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void loadImage(byte[] bytes) {
        this.loadImage(new ImageIcon(bytes));
    }

    public void loadImage(ImageIcon value) {
        this.imageView.setValue(value);
        this.repaintImage();
    }

    public void repaintImage() {
        this.imageView.repaint();
    }

    public byte[] getBytes(BufferedImage image) {
        if (image == null) {
            return null;
        }
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "jpg", baos);
            baos.flush();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            try {
                baos.close();
            }
            catch (Throwable throwable) {}
        }
    }

    private class DefaultLayout
    implements LayoutManager,
    LayoutManager2 {
        ImageCropPanel root;

        private DefaultLayout() {
            this.root = ImageCropPanel.this;
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.layoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.layoutSize(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dimension layoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets margin = parent.getInsets();
                int width = margin.left + margin.right;
                int height = margin.top + margin.bottom;
                return new Dimension(width, height);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets margin = parent.getInsets();
                int pw = parent.getWidth();
                int ph = parent.getHeight();
                int x = margin.left;
                int y = margin.top;
                int w = pw - (margin.left + margin.right);
                int h = ph - (margin.top + margin.bottom);
                JPanel c = this.root.imageView;
                if (c == null || !c.isVisible()) {
                    return;
                }
                c.setBounds(x, y, w, h);
                c = this.root.imageToolbar;
                System.out.println(c);
                if (c != null && c.isVisible()) {
                    Dimension dim = ((Component)c).getPreferredSize();
                    y = Math.max(ph - margin.bottom - dim.height, margin.top);
                    x = Math.max(w / 2 - dim.width / 2, margin.left);
                    c.setBounds(x, y, dim.width, dim.height);
                }
            }
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
        }

        @Override
        public float getLayoutAlignmentX(Container target) {
            return 0.5f;
        }

        @Override
        public float getLayoutAlignmentY(Container target) {
            return 0.5f;
        }

        @Override
        public Dimension maximumLayoutSize(Container target) {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        @Override
        public void invalidateLayout(Container target) {
            this.layoutContainer(target);
        }
    }

    private class FitScreenAction
    implements ActionListener {
        private FitScreenAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ImageCropItem c = ImageCropPanel.this.imageView;
            if (c != null) {
                c.fit();
            }
        }
    }

    private class ZoomOutAction
    implements ActionListener {
        private ZoomOutAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ImageCropItem c = ImageCropPanel.this.imageView;
            if (c != null) {
                c.zoomOut();
            }
        }
    }

    private class ZoomInAction
    implements ActionListener {
        private ZoomInAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ImageCropItem c = ImageCropPanel.this.imageView;
            if (c != null) {
                c.zoomIn();
            }
        }
    }
}

