/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.menu;

import com.rameses.rcp.common.MenuRootElement;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EventListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class VMenu
extends JMenu {
    private boolean borderPainted;
    private final Object ItemSelectionLocked = new Object();
    private ItemSelectionModel ism = new ItemSelectionModel();

    public VMenu(String text) {
        super(text);
        this.initComponent();
    }

    private void initComponent() {
        Insets p = this.getMargin();
        if (p == null) {
            p = new Insets(0, 0, 0, 0);
        }
        Insets newpad = new Insets(p.top, p.left, p.bottom, p.right);
        newpad.right += 5;
        this.setMargin(newpad);
    }

    private VMenu getRoot() {
        return this;
    }

    public VMenu addMenu(String text) {
        VMenu m = new VMenu(text);
        this.add(m);
        return m;
    }

    public JMenuItem addMenuItem(String text) {
        JMenuItem mi = new JMenuItem(text);
        this.add(mi);
        return mi;
    }

    @Override
    public JMenuItem add(JMenuItem menuItem) {
        if (menuItem == null) {
            return null;
        }
        this.installItemDefaults(menuItem);
        return super.add(menuItem);
    }

    @Override
    public boolean isBorderPainted() {
        return this.borderPainted;
    }

    @Override
    public void setBorderPainted(boolean borderPainted) {
        super.setBorderPainted(borderPainted);
        this.borderPainted = borderPainted;
    }

    @Override
    protected Point getPopupMenuOrigin() {
        Point p = super.getPopupMenuOrigin();
        Rectangle prect = this.getParent().getBounds();
        Rectangle crect = this.getBounds();
        p.x += prect.width;
        p.y -= crect.height;
        return p;
    }

    @Override
    public JPopupMenu getPopupMenu() {
        JPopupMenu pm = super.getPopupMenu();
        Object o = pm.getClientProperty(ContainerHandler.class);
        if (!(o instanceof ContainerHandler)) {
            ContainerHandler ch = new ContainerHandler();
            pm.addContainerListener(ch);
            pm.putClientProperty(ContainerHandler.class, ch);
        }
        return pm;
    }

    private void installItemDefaults(JMenuItem mi) {
        EventListener h;
        Object o = mi.getClientProperty(MenuItemMouseHandler.class);
        if (!(o instanceof MenuItemMouseHandler)) {
            h = new MenuItemMouseHandler();
            mi.addMouseListener((MouseListener)h);
            mi.putClientProperty(MenuItemMouseHandler.class, h);
        }
        if (!(mi instanceof JMenu) && !((o = mi.getClientProperty(ActionHandler.class)) instanceof ActionHandler)) {
            h = new ActionHandler();
            mi.addActionListener((ActionListener)h);
            mi.putClientProperty(ActionHandler.class, h);
        }
    }

    private void uninstallItemDefaults(JMenuItem mi) {
        EventListener h;
        Object o = mi.getClientProperty(MenuItemMouseHandler.class);
        if (o instanceof MenuItemMouseHandler) {
            h = (MenuItemMouseHandler)o;
            mi.removeMouseListener((MouseListener)h);
        }
        if ((o = mi.getClientProperty(ActionHandler.class)) instanceof ActionHandler) {
            h = (ActionHandler)o;
            mi.removeActionListener((ActionListener)h);
        }
    }

    private class MenuItemMouseHandler
    extends MouseAdapter {
        private MenuItemMouseHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            JMenuItem mi = (JMenuItem)e.getSource();
            VMenu.this.ism.select(mi);
        }
    }

    private class ItemSelectionModel {
        private JMenuItem selItem;

        private ItemSelectionModel() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void select(JMenuItem mi) {
            Object object = VMenu.this.getRoot().ItemSelectionLocked;
            synchronized (object) {
                this.selectImpl(mi);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void deselect(JMenuItem mi) {
            Object object = VMenu.this.getRoot().ItemSelectionLocked;
            synchronized (object) {
                this.deselectImpl(mi);
            }
        }

        void selectImpl(JMenuItem mi) {
            JMenu jm;
            if (this.selItem != null) {
                this.deselect(this.selItem);
                this.selItem = null;
            }
            mi.setArmed(true);
            mi.setSelected(true);
            mi.setRolloverEnabled(true);
            mi.setBorderPainted(true);
            mi.repaint();
            this.selItem = mi;
            if (mi instanceof JMenu && (jm = (JMenu)mi).getMenuComponentCount() > 0) {
                Rectangle rect = jm.getBounds();
                jm.isPopupMenuVisible();
                jm.getPopupMenu().show(jm, rect.width, 0);
            }
        }

        void deselectImpl(JMenuItem mi) {
            mi.setArmed(false);
            mi.setSelected(false);
            mi.setRolloverEnabled(false);
            mi.setBorderPainted(false);
            mi.repaint();
            if (mi instanceof JMenu) {
                JMenu jm = (JMenu)mi;
                jm.isPopupMenuVisible();
                jm.getPopupMenu().setVisible(false);
            }
        }
    }

    public static class ActionHandler
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (!(source instanceof JMenu) && source instanceof JMenuItem) {
                this.closeParentPopups((JMenuItem)e.getSource());
            }
        }

        private void closeParentPopups(Component comp) {
            if (comp == null) {
                return;
            }
            if (comp instanceof MenuRootElement) {
                MenuRootElement e = (MenuRootElement)((Object)comp);
                e.dispose();
            } else if (comp instanceof JPopupMenu) {
                JPopupMenu pm = (JPopupMenu)comp;
                Component inv = pm.getInvoker();
                if (inv instanceof JMenu) {
                    ((JMenu)inv).setPopupMenuVisible(false);
                }
                this.closeParentPopups(inv);
            } else {
                this.closeParentPopups(comp.getParent());
            }
        }
    }

    private class ContainerHandler
    implements ContainerListener {
        private ContainerHandler() {
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            if (e.getChild() instanceof JMenuItem) {
                JMenuItem mi = (JMenuItem)e.getChild();
                VMenu.this.getRoot().installItemDefaults(mi);
            }
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            if (e.getChild() instanceof JMenuItem) {
                JMenuItem mi = (JMenuItem)e.getChild();
                VMenu.this.getRoot().uninstallItemDefaults(mi);
            }
        }
    }
}

