/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.tabbedpane;

import com.rameses.rcp.common.Opener;
import com.rameses.rcp.control.XSubFormPanel;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.support.ImageIconSupport;
import com.rameses.rcp.util.ControlSupport;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class TabbedItemPanel
extends JPanel {
    private Opener opener;
    private Layout layout;
    private XSubFormPanel content;
    private boolean processing;
    private ImageIcon processIcon;
    private char mnemonic;
    private Provider provider;

    public TabbedItemPanel(Opener opener) {
        this.opener = opener;
        this.mnemonic = '\u0000';
        this.layout = new Layout();
        super.setLayout(this.layout);
    }

    @Override
    public final LayoutManager getLayout() {
        return this.layout;
    }

    @Override
    public final void setLayout(LayoutManager mgr) {
    }

    public char getMnemonic() {
        return this.mnemonic;
    }

    public void setMnemonic(char mnemonic) {
        this.mnemonic = mnemonic;
    }

    public Opener getOpener() {
        return this.opener;
    }

    public boolean hasContent() {
        return this.content != null;
    }

    public JComponent getContent() {
        return this.content;
    }

    public void loadContent() {
        if (this.content == null) {
            this.processing = true;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    TabbedItemPanel.this.repaint();
                }
            };
            new Thread(runnable).start();
            EventQueue.invokeLater(new ContentLoader());
        }
    }

    public void reloadContent() {
        if (this.opener.getController() == null) {
            this.loadContent();
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TabbedItemPanel.this.reloadContentImpl();
                }
            });
        }
    }

    private void reloadContentImpl() {
        Map udfParams;
        HashMap openerParams;
        Opener newOpener = this.opener.createInstance(null, null);
        if (newOpener == null) {
            newOpener = this.opener;
        }
        if ((openerParams = newOpener.getParams()) == null) {
            openerParams = new HashMap();
            newOpener.setParams(openerParams);
        }
        Map map = udfParams = this.provider == null ? null : this.provider.getOpenerParams(newOpener);
        if (udfParams != null) {
            openerParams.putAll(udfParams);
        }
        this.setContent(newOpener);
    }

    public void refreshContent() {
        if (this.opener.getController() == null) {
            this.loadContent();
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TabbedItemPanel.this.refreshContentImpl();
                }
            });
        }
    }

    private void refreshContentImpl() {
        Map udfParams;
        HashMap openerParams = this.opener.getParams();
        if (openerParams == null) {
            openerParams = new HashMap();
            this.opener.setParams(openerParams);
        }
        Map map = udfParams = this.provider == null ? null : this.provider.getOpenerParams(this.opener);
        if (udfParams != null) {
            openerParams.putAll(udfParams);
        }
        Object o = this.opener.getHandle();
        ControlSupport.setProperties(o, openerParams);
        if (this.content != null) {
            this.content.refreshViews();
        }
    }

    private void setContent(Opener opener) {
        XSubFormPanel xsf = new XSubFormPanel(opener);
        xsf.setBinding(this.provider.getBinding());
        xsf.load();
        this.removeAll();
        this.content = xsf;
        this.add(xsf);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.processing) {
            ImageIcon iicon = this.getProcessIcon();
            if (iicon == null) {
                return;
            }
            iicon.paintIcon(this, g, 10, 10);
        }
    }

    private ImageIcon getProcessIcon() {
        if (this.processIcon == null) {
            this.processIcon = ImageIconSupport.getInstance().getIcon("com/rameses/rcp/icons/loading32.gif");
        }
        return this.processIcon;
    }

    public final void setProvider(Provider provider) {
        this.provider = provider;
    }

    private class ContentLoader
    implements Runnable {
        TabbedItemPanel root;

        private ContentLoader() {
            this.root = TabbedItemPanel.this;
        }

        @Override
        public void run() {
            try {
                this.runImpl();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            finally {
                this.root.processing = false;
                this.root.repaint();
                this.root.validate();
            }
        }

        private void runImpl() {
            Map udfParams;
            Opener opener = this.root.opener;
            HashMap openerParams = opener.getParams();
            if (openerParams == null) {
                openerParams = new HashMap();
                opener.setParams(openerParams);
            }
            Map map = udfParams = this.root.provider == null ? null : this.root.provider.getOpenerParams(opener);
            if (udfParams != null) {
                openerParams.putAll(udfParams);
            }
            this.root.setContent(opener);
        }
    }

    private class Layout
    implements LayoutManager {
        TabbedItemPanel root;

        private Layout() {
            this.root = TabbedItemPanel.this;
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dimension getLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets margin = parent.getInsets();
                int w = margin.left + margin.right;
                int h = margin.top + margin.bottom;
                return new Dimension(w, h);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets margin = parent.getInsets();
                int pw = parent.getWidth();
                int ph = parent.getHeight();
                int x = margin.left;
                int y = margin.top;
                int w = pw - (margin.left + margin.right);
                int h = ph - (margin.top + margin.bottom);
                XSubFormPanel c = this.root.content;
                if (c != null && c.isVisible()) {
                    c.setBounds(x, y, w, h);
                }
            }
        }
    }

    public static interface Provider {
        public Binding getBinding();

        public Map getOpenerParams(Object var1);
    }
}

