/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.table;

import com.rameses.common.ExpressionResolver;
import com.rameses.common.PropertyResolver;
import com.rameses.rcp.common.AbstractListDataProvider;
import com.rameses.rcp.common.Column;
import com.rameses.rcp.common.EditorListSupport;
import com.rameses.rcp.common.ListItem;
import com.rameses.rcp.common.MultiSelectionHandler;
import com.rameses.rcp.common.TableModelHandler;
import com.rameses.rcp.control.table.DataTableBinding;
import com.rameses.rcp.control.table.ExprBeanSupport;
import com.rameses.rcp.control.table.SelectionColumnHandler;
import com.rameses.rcp.control.table.TableControlModel;
import com.rameses.util.ValueUtil;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;

public class DataTableModel
extends AbstractTableModel
implements TableControlModel,
TableModelHandler {
    public static final String DEFAULT_MULTI_SELECT_NAME = "listHandler.checkedItems";
    private PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    private List<Column> columnList = new ArrayList<Column>();
    private AbstractListDataProvider dataProvider;
    private EditorListSupport editorSupport;
    private DataTableBinding binding;
    private String multiSelectName;
    private String varName = "item";
    private String varStatus;
    private String id;
    private Object bindingBean;
    private MultiSelectionHandlerImpl multiSelectionHandlerImpl;
    private int sortType;
    private int sortIndex = -1;

    void setBinding(DataTableBinding binding) {
        this.binding = binding;
    }

    void setBindingBean(Object bindingBean) {
        this.bindingBean = bindingBean;
    }

    public void removeHandler(PropertyChangeListener handler) {
        if (handler != null) {
            this.propertySupport.removePropertyChangeListener(handler);
        }
    }

    public void addHandler(PropertyChangeListener handler) {
        if (handler != null) {
            this.propertySupport.removePropertyChangeListener(handler);
            this.propertySupport.addPropertyChangeListener(handler);
        }
    }

    public void firePropertyChange(String name, Object oldValue, Object newValue) {
        this.propertySupport.firePropertyChange(name, oldValue, newValue);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getVarName() {
        return this.varName;
    }

    public void setVarName(String varName) {
        this.varName = varName;
    }

    public String getVarStatus() {
        return this.varStatus;
    }

    public void setVarStatus(String varStatus) {
        this.varStatus = varStatus;
    }

    public String getMultiSelectName() {
        return this.multiSelectName;
    }

    public void setMultiSelectName(String multiSelectName) {
        this.multiSelectName = multiSelectName;
    }

    public AbstractListDataProvider getDataProvider() {
        return this.dataProvider;
    }

    public void setDataProvider(AbstractListDataProvider dataProvider) {
        AbstractListDataProvider oldDataProvider = this.dataProvider;
        if (oldDataProvider != null) {
            oldDataProvider.removeHandler(this);
            oldDataProvider.getMultiSelectionSupport().remove(this.getMultiSelectionHandler());
        }
        this.dataProvider = dataProvider;
        if (dataProvider != null) {
            dataProvider.addHandler(this);
            dataProvider.getMultiSelectionSupport().add(this.getMultiSelectionHandler());
        }
        this.reIndexColumns();
    }

    void setEditorListSupport(EditorListSupport editorSupport) {
        this.editorSupport = editorSupport;
    }

    void dispose() {
        if (this.dataProvider == null) {
            return;
        }
        this.dataProvider.removeHandler(this);
        this.columnList.clear();
        this.dataProvider = null;
    }

    public void reIndexColumns() {
        Column[] columns;
        this.columnList.clear();
        if (this.dataProvider == null) {
            return;
        }
        if (this.dataProvider.isMultiSelect()) {
            String multiName = this.getMultiSelectName();
            if (multiName == null) {
                multiName = DEFAULT_MULTI_SELECT_NAME;
            }
            Column col = new Column(multiName, " ");
            col.setTypeHandler(new SelectionColumnHandler());
            this.columnList.add(col);
        }
        if ((columns = this.dataProvider.getColumns()) == null) {
            List<Map> list = this.dataProvider.getColumnList();
            if (list == null) {
                list = new ArrayList<Map>();
            }
            columns = new Column[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                columns[i] = new Column(list.get(i));
            }
            columns = this.dataProvider.initColumns(columns);
        }
        Object exprBean = this.createExpressionBean(new HashMap());
        ExpressionResolver exprResolver = ExpressionResolver.getInstance();
        for (Column col : columns) {
            if (!col.isVisible()) continue;
            boolean b = col.isVisible();
            String expr = col.getVisibleWhen();
            if (expr != null && expr.trim().length() > 0) {
                try {
                    b = exprResolver.evalBoolean(expr, exprBean);
                }
                catch (Throwable t) {
                    continue;
                }
            }
            if (!b) continue;
            this.columnList.add(col);
        }
    }

    @Override
    public int getRowCount() {
        return this.dataProvider.getListItems().size();
    }

    @Override
    public Column getColumn(int index) {
        if (index >= 0 && index < this.columnList.size()) {
            return this.columnList.get(index);
        }
        return null;
    }

    public int getColumnIndex(String name) {
        for (int i = 0; i < this.columnList.size(); ++i) {
            String cname = this.columnList.get(i).getName();
            if (cname == null || !cname.equals(name)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnList.get(column).getCaption();
    }

    @Override
    public int getColumnCount() {
        return this.columnList.size();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public Object getItem(int rowIndex) {
        ListItem item = this.getListItem(rowIndex);
        return item == null ? null : item.getItem();
    }

    public ListItem getListItem(int rowIndex) {
        try {
            return this.dataProvider.getListItem(rowIndex);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String name;
        PropertyResolver resolver = PropertyResolver.getInstance();
        ListItem item = this.getListItem(rowIndex);
        if (item == null) {
            return null;
        }
        Column oColumn = this.getColumn(columnIndex);
        String string = name = oColumn == null ? null : oColumn.getName();
        if (ValueUtil.isEmpty((Object)name)) {
            return null;
        }
        if (this.varStatus != null) {
            if (name.equals(this.varStatus)) {
                return item;
            }
            if (name.startsWith(this.varStatus + ".")) {
                return resolver.getProperty((Object)item, name.substring(name.indexOf(".") + 1));
            }
        }
        if (item.getItem() != null) {
            return resolver.getProperty(item.getItem(), name);
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        AbstractListDataProvider dp = this.getDataProvider();
        boolean forceUpdate = dp == null ? false : dp.isForceUpdate();
        this.setValueAt(value, rowIndex, columnIndex, forceUpdate);
    }

    public void setValueAt(Object value, int rowIndex, int columnIndex, boolean forceUpdate) {
        Column column = this.getColumn(columnIndex);
        if (column == null) {
            return;
        }
        if (ValueUtil.isEmpty((Object)column.getName())) {
            return;
        }
        Object item = this.getItem(rowIndex);
        if (item == null) {
            throw new NullPointerException("The item object in row " + rowIndex + " column " + columnIndex + " is not initialized");
        }
        PropertyResolver resolver = PropertyResolver.getInstance();
        if (column.getTypeHandler() instanceof SelectionColumnHandler) {
            boolean selected = "true".equals(value + "");
            int multiSelectMode = this.getDataProvider().getMultiSelectMode();
            AbstractListDataProvider.ListSelectionSupport lss = this.getDataProvider().getSelectionSupport();
            if (multiSelectMode == 2) {
                Object rowdata;
                int idx;
                boolean row_selection_changed = false;
                for (idx = rowIndex + 1; idx < this.getRowCount(); ++idx) {
                    rowdata = this.getItem(idx);
                    if (!lss.contains(rowdata)) continue;
                    lss.setItemChecked(rowdata, selected, idx);
                    row_selection_changed = true;
                }
                if (row_selection_changed) {
                    this.fireTableRowsUpdated(rowIndex, this.getRowCount() - 1);
                } else {
                    for (idx = 0; idx <= rowIndex; ++idx) {
                        rowdata = this.getItem(idx);
                        lss.setItemChecked(rowdata, selected, idx);
                    }
                    this.fireTableRowsUpdated(0, rowIndex);
                }
            } else {
                lss.setItemChecked(item, selected, rowIndex);
                this.fireTableRowsUpdated(rowIndex, rowIndex);
            }
            this.firePropertyChange("checkedItemsChanged", !selected, selected);
        } else {
            Object oldValue = null;
            try {
                oldValue = resolver.getProperty(item, column.getName());
            }
            catch (Throwable multiSelectMode) {
                // empty catch block
            }
            boolean has_value_changed = this.hasValueChanged(oldValue, value);
            if (!forceUpdate && !has_value_changed) {
                return;
            }
            ListItem li = this.getListItem(rowIndex);
            if (this.editorSupport != null) {
                this.editorSupport.fireBeforeColumnUpdate(li, value);
            }
            resolver.setProperty(item, column.getName(), value);
            if (li.getState() == 1) {
                li.setState(3);
            }
            this.fireTableRowsUpdated(rowIndex, rowIndex);
            if (has_value_changed) {
                try {
                    this.binding.getChangeLog().addEntry(item, column.getName(), oldValue, value);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (this.editorSupport != null) {
                this.editorSupport.fireColumnUpdate(li);
            }
        }
    }

    @Override
    public void fireTableRowSelected(int row, boolean focusOnItemDataOnly) {
    }

    private boolean hasValueChanged(Object oldValue, Object newValue) {
        if (oldValue == null && newValue == null) {
            return false;
        }
        return oldValue == null || newValue == null || !oldValue.equals(newValue);
    }

    public Object createExpressionBean(int rowIndex) {
        Object item = this.dataProvider.getListItemData(rowIndex);
        return this.createExpressionBean(item);
    }

    public Object createExpressionBean(Object itemBean) {
        Object rootBean = this.bindingBean;
        if (rootBean == null) {
            return null;
        }
        ExprBeanSupport support = new ExprBeanSupport(rootBean);
        support.setItem("listHandler", this.dataProvider);
        if (this.getVarName() != null) {
            if (itemBean == null) {
                itemBean = new HashMap();
            }
            support.setItem(this.getVarName(), itemBean);
        }
        return support.createProxy();
    }

    @Override
    public final void fireTableDataProviderChanged() {
    }

    @Override
    public void fireTableStructureChanged() {
        this.reIndexColumns();
        super.fireTableStructureChanged();
    }

    private MultiSelectionHandlerImpl getMultiSelectionHandler() {
        if (this.multiSelectionHandlerImpl == null) {
            this.multiSelectionHandlerImpl = new MultiSelectionHandlerImpl();
        }
        return this.multiSelectionHandlerImpl;
    }

    public void toggleSort(int index) {
        if (this.sortIndex == index) {
            ++this.sortType;
            if (this.sortType > 2) {
                this.sortType = 0;
                this.sortIndex = -1;
            }
        } else if (index >= 0 && index < this.getColumnCount()) {
            this.sortIndex = index;
            this.sortType = 1;
        } else {
            this.sortType = 0;
            this.sortIndex = -1;
        }
    }

    public int getSortType() {
        return this.sortType;
    }

    public int getSortIndex() {
        return this.sortIndex;
    }

    private class MultiSelectionHandlerImpl
    implements MultiSelectionHandler {
        private DataTableModel root;

        private MultiSelectionHandlerImpl() {
            this.root = DataTableModel.this;
        }

        @Override
        public void selectAll() {
            if (this.root.dataProvider == null) {
                return;
            }
            int rowCount = this.root.getRowCount();
            if (rowCount <= 0) {
                return;
            }
            for (int idx = 0; idx < rowCount; ++idx) {
                Object rowdata = DataTableModel.this.getItem(idx);
                if (rowdata == null) continue;
                this.root.getDataProvider().getSelectionSupport().setItemChecked(rowdata, true, idx);
            }
            this.root.fireTableRowsUpdated(0, rowCount - 1);
            this.root.firePropertyChange("checkedItemsChanged", false, true);
        }

        @Override
        public void deselectAll() {
            if (this.root.dataProvider == null) {
                return;
            }
            int rowCount = this.root.getRowCount();
            if (rowCount <= 0) {
                return;
            }
            for (int idx = 0; idx < rowCount; ++idx) {
                Object rowdata = DataTableModel.this.getItem(idx);
                this.root.getDataProvider().getSelectionSupport().setItemChecked(rowdata, false, idx);
            }
            this.root.fireTableRowsUpdated(0, rowCount - 1);
            this.root.firePropertyChange("checkedItemsChanged", true, false);
        }
    }
}

