/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.table;

import com.rameses.rcp.common.Column;
import com.rameses.rcp.control.table.DataTableComponent;
import com.rameses.rcp.control.table.SelectionColumnHandler;
import com.rameses.rcp.control.table.TableUtil;
import com.rameses.rcp.support.ColorUtil;
import com.rameses.rcp.support.ComponentSupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

class DataTableModelDesignTime
extends AbstractTableModel {
    private Column[] columns;

    public DataTableModelDesignTime(Column[] columns) {
        this.columns = columns;
    }

    @Override
    public int getRowCount() {
        return 1;
    }

    @Override
    public int getColumnCount() {
        return this.columns == null ? 0 : this.columns.length;
    }

    @Override
    public String getColumnName(int index) {
        Column col = this.getColumn(index);
        return col == null ? "" : col.getCaption();
    }

    public Column getColumn(int index) {
        int colCount = this.getColumnCount();
        if (index >= 0 && index < colCount) {
            return this.columns[index];
        }
        return null;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return "";
    }

    void applyColumnAttributes(DataTableComponent table) {
        int columnCount = this.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            Column oColumn = this.columns[i];
            if (oColumn.getTypeHandler() instanceof SelectionColumnHandler) {
                oColumn.setEditable(true);
            }
            TableColumn oTableColumn = table.getColumnModel().getColumn(i);
            if (oColumn.getWidth() >= 0) {
                oTableColumn.setPreferredWidth(oColumn.getWidth());
                oTableColumn.setWidth(oColumn.getWidth());
            }
            if (oColumn.getMinWidth() > 0) {
                oTableColumn.setMinWidth(oColumn.getMinWidth());
            }
            if (oColumn.getMaxWidth() > 0) {
                oTableColumn.setMaxWidth(oColumn.getMaxWidth());
            }
            oTableColumn.setResizable(oColumn.isResizable());
            oTableColumn.setCellRenderer(new DefaultRenderer());
        }
    }

    private class DefaultRenderer
    implements TableCellRenderer {
        private Insets CELL_MARGIN = TableUtil.CELL_MARGIN;
        private Color FOCUS_BG = TableUtil.FOCUS_BG;
        private ComponentSupport componentSupport;
        private JLabel comp = new JLabel();

        DefaultRenderer() {
            this.comp.setOpaque(false);
        }

        private ComponentSupport getComponentSupport() {
            if (this.componentSupport == null) {
                this.componentSupport = new ComponentSupport();
            }
            return this.componentSupport;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int columnIndex) {
            this.getComponentSupport().setEmptyBorder(this.comp, this.CELL_MARGIN);
            this.comp.setFont(table.getFont());
            if (isSelected) {
                this.comp.setBackground(table.getSelectionBackground());
                this.comp.setForeground(table.getSelectionForeground());
                this.comp.setOpaque(true);
                if (hasFocus) {
                    this.comp.setBackground(this.FOCUS_BG);
                    this.comp.setForeground(table.getForeground());
                }
            } else {
                this.comp.setForeground(table.getForeground());
                this.comp.setOpaque(false);
                DataTableComponent dtc = (DataTableComponent)table;
                if ((rowIndex + 1) % 2 == 0) {
                    if (dtc.getEvenBackground() != null) {
                        this.comp.setBackground(dtc.getEvenBackground());
                        this.comp.setOpaque(true);
                    }
                    if (dtc.getEvenForeground() != null) {
                        this.comp.setForeground(dtc.getEvenForeground());
                    }
                } else {
                    if (dtc.getOddBackground() != null) {
                        this.comp.setBackground(dtc.getOddBackground());
                        this.comp.setOpaque(true);
                    }
                    if (dtc.getOddForeground() != null) {
                        this.comp.setForeground(dtc.getOddForeground());
                    }
                }
            }
            if (!table.isEnabled()) {
                Color c = this.comp.getBackground();
                this.comp.setBackground(ColorUtil.brighter(c, 5));
                c = this.comp.getForeground();
                this.comp.setForeground(ColorUtil.brighter(c, 5));
            }
            Border inner = this.getComponentSupport().createEmptyBorder(this.CELL_MARGIN);
            Border border = BorderFactory.createEmptyBorder(1, 1, 1, 1);
            if (hasFocus) {
                if (isSelected) {
                    border = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
                }
                if (border == null) {
                    border = UIManager.getBorder("Table.focusCellHighlightBorder");
                }
            }
            this.comp.setBorder(BorderFactory.createCompoundBorder(border, inner));
            return this.comp;
        }
    }
}

