/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.table;

import com.rameses.rcp.support.ColorUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.SystemColor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.AbstractBorder;

public class TableBorders {
    public static final Color BORDER_COLOR = new Color(204, 204, 204);

    public static class CellBorder
    extends AbstractBorder {
        private JTable table;
        private int rowIndex;
        private int columnIndex;

        public CellBorder(JTable table, int rowIndex, int columnIndex) {
            this.table = table;
            this.rowIndex = rowIndex;
            this.columnIndex = columnIndex;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, null);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            if (insets == null) {
                insets = new Insets(0, 0, 0, 0);
            }
            return super.getBorderInsets(c, insets);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        }
    }

    public static class ViewPortBorder
    extends AbstractBorder {
        private Color defaultColor = SystemColor.control;

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            if (insets == null) {
                insets = new Insets(0, 0, 0, 0);
            }
            insets.bottom = 5;
            insets.top = 5;
            insets.right = 5;
            insets.left = 5;
            return insets;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            Color oldColor = g.getColor();
            Color newColor = ColorUtil.brighter(this.defaultColor.darker(), 20);
            g.setColor(newColor);
            g.drawLine(0, 0, 0, h);
            g.setColor(oldColor);
        }
    }

    public static class RowBorder
    extends AbstractBorder {
        private Color defaultColor = SystemColor.control;

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            if (insets == null) {
                insets = new Insets(0, 0, 0, 0);
            }
            insets.bottom = 2;
            insets.top = 2;
            insets.right = 2;
            insets.left = 2;
            return insets;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            Color oldColor = g.getColor();
            Color newColor = ColorUtil.brighter(this.defaultColor.darker(), 20);
            g.setColor(newColor);
            g.drawLine(w - 1, 0, w - 1, h);
            g.setColor(oldColor);
        }
    }

    public static class HeaderBorder
    extends AbstractBorder {
        private boolean hideTop = true;
        private boolean hideLeft = false;
        private boolean hideBottom = false;
        private boolean hideRight = false;
        private JLabel jlabel = new JLabel();

        public HeaderBorder() {
            this.init();
        }

        public HeaderBorder(boolean hideTop, boolean hideLeft, boolean hideBottom, boolean hideRight) {
            this.init();
            this.hideTop = hideTop;
            this.hideLeft = hideLeft;
            this.hideBottom = hideBottom;
            this.hideRight = hideRight;
        }

        private void init() {
            this.jlabel.setOpaque(true);
        }

        public boolean isHideTop() {
            return this.hideTop;
        }

        public void setHideTop(boolean hideTop) {
            this.hideTop = hideTop;
        }

        public boolean isHideLeft() {
            return this.hideLeft;
        }

        public void setHideLeft(boolean hideLeft) {
            this.hideLeft = hideLeft;
        }

        public boolean isHideBottom() {
            return this.hideBottom;
        }

        public void setHideBottom(boolean hideBottom) {
            this.hideBottom = hideBottom;
        }

        public boolean isHideRight() {
            return this.hideRight;
        }

        public void setHideRight(boolean hideRight) {
            this.hideRight = hideRight;
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            if (insets == null) {
                insets = new Insets(0, 0, 0, 0);
            }
            insets.bottom = 5;
            insets.top = 5;
            insets.right = 5;
            insets.left = 5;
            return insets;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            Color oldColor = g.getColor();
            Color color = new Helper().getBorderColor(c);
            c.setBackground(this.jlabel.getBackground());
            if (!this.hideTop) {
                g.setColor(color);
                g.drawLine(0, 0, w, 0);
            }
            if (!this.hideLeft) {
                g.setColor(color);
                g.drawLine(0, 2, 0, h - 5);
            }
            if (!this.hideBottom) {
                g.setColor(color);
                g.drawLine(0, h - 2, w, h - 2);
            }
            if (!this.hideRight) {
                g.setColor(color);
                g.drawLine(w - 1, 2, w - 1, h - 5);
            }
            g.setColor(oldColor);
        }

        protected Color getHighlightColor(Component c) {
            return c.getBackground().brighter();
        }

        protected Color getShadowColor(Component c) {
            return c.getBackground().darker();
        }
    }

    public static class DefaultBorder
    extends AbstractBorder {
        private Insets PADDING = new Insets(1, 1, 1, 1);

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            if (insets == null) {
                insets = new Insets(0, 0, 0, 0);
            }
            insets.right = 0;
            insets.bottom = 0;
            insets.left = 0;
            insets.top = 0;
            insets.top += this.PADDING.top;
            insets.left += this.PADDING.left;
            insets.bottom += this.PADDING.bottom;
            insets.right += this.PADDING.right;
            return insets;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            Color oldColor = g.getColor();
            Color newColor = null;
            if (c instanceof JComponent) {
                newColor = (Color)((JComponent)c).getClientProperty("Border.color");
            }
            if (newColor == null) {
                newColor = BORDER_COLOR;
            }
            g.setColor(newColor);
            g.drawRect(0, 0, w - 1, h - 1);
            g.setColor(oldColor);
        }
    }

    public static class Helper {
        public Color getBorderColor(Component c) {
            if (c instanceof JComponent) {
                return this.getBorderColor((JComponent)c);
            }
            return null;
        }

        public Color getBorderColor(JComponent jc) {
            Color color = null;
            Object obj = jc.getClientProperty("Component.proxy");
            if (obj instanceof JComponent) {
                color = (Color)((JComponent)obj).getClientProperty("Border.color");
            }
            if (color == null) {
                color = (Color)jc.getClientProperty("Border.color");
            }
            return color == null ? BORDER_COLOR : color;
        }
    }
}

