/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.table;

import com.rameses.common.ExpressionResolver;
import com.rameses.rcp.common.AbstractListDataProvider;
import com.rameses.rcp.common.Column;
import com.rameses.rcp.common.StyleRule;
import com.rameses.rcp.control.XCheckBox;
import com.rameses.rcp.control.XComboBox;
import com.rameses.rcp.control.XDateField;
import com.rameses.rcp.control.XDecimalField;
import com.rameses.rcp.control.XIntegerField;
import com.rameses.rcp.control.XLookupField;
import com.rameses.rcp.control.XOpenerField;
import com.rameses.rcp.control.XTextField;
import com.rameses.rcp.control.table.CellRenderers;
import com.rameses.rcp.control.table.ColumnHandlerUtil;
import com.rameses.rcp.control.table.DataTableComponent;
import com.rameses.rcp.control.table.DataTableHeader;
import com.rameses.rcp.control.table.DataTableModel;
import com.rameses.rcp.control.table.DynamicCellRenderer;
import com.rameses.rcp.control.table.SelectionCellEditor;
import com.rameses.rcp.control.table.SelectionCellRenderer;
import com.rameses.rcp.control.table.SelectionColumnHandler;
import com.rameses.rcp.control.table.TableControl;
import com.rameses.rcp.control.table.TableControlModel;
import com.rameses.rcp.control.table.TableHeaderRenderer;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.support.ColorUtil;
import com.rameses.rcp.support.ComponentSupport;
import com.rameses.rcp.ui.UIControl;
import com.rameses.rcp.ui.Validatable;
import com.rameses.rcp.util.ControlSupport;
import com.rameses.rcp.util.UIControlUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;

public final class TableUtil {
    public static final Insets CELL_MARGIN = new Insets(1, 4, 4, 1);
    public static final Color FOCUS_BG = new Color(254, 255, 208);
    public static final String HIDE_ON_ENTER = "hide.on.enter";
    private static Map<String, Class<? extends JComponent>> editors = new HashMap<String, Class<? extends JComponent>>();
    private static Map<String, Class> numClass = new HashMap<String, Class>();
    private static Map<Object, TableCellRenderer> renderers = new HashMap<Object, TableCellRenderer>();
    private static TableCellRenderer headerRenderer = new TableHeaderRenderer();

    public static JComponent createCellEditor(Column oColumn) {
        if (oColumn.getTypeHandler() == null) {
            oColumn.setTypeHandler(ColumnHandlerUtil.newInstance().createTypeHandler(oColumn));
        }
        oColumn.setType(oColumn.getTypeHandler().getType());
        Class<? extends JComponent> editorClass = editors.get(oColumn.getType());
        JComponent editor = null;
        try {
            JComponent jComponent = editor = editorClass == null ? null : editorClass.newInstance();
            if (editor != null) {
                TableUtil.customize(editor, oColumn);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return editor;
    }

    public static TableCellRenderer getCellRenderer(Column oColumn) {
        ColumnHandlerUtil u = ColumnHandlerUtil.newInstance();
        if (oColumn.getTypeHandler() == null) {
            oColumn.setTypeHandler(u.createTypeHandler(oColumn));
        }
        oColumn.setType(oColumn.getTypeHandler().getType());
        CellRenderers.getPreferredAlignment(oColumn);
        TableCellRenderer renderer = renderers.get(oColumn.getType());
        if (renderer == null) {
            return renderers.get(oColumn.getTypeHandler().getClass());
        }
        return renderer;
    }

    public static TableCellRenderer getHeaderRenderer() {
        return headerRenderer;
    }

    public static JComponent getTableCornerComponent(Color borderColor) {
        JLabel label = new JLabel(" ");
        Border bb = BorderFactory.createLineBorder(borderColor);
        Border eb = BorderFactory.createEmptyBorder(2, 5, 2, 1);
        label.setBorder(BorderFactory.createCompoundBorder(bb, eb));
        return label;
    }

    public static synchronized void customize(JScrollPane scrollPane, JTable table) {
        JComponent corner = new DataTableHeader.CornerBorder(table, "UPPER_RIGHT_CORNER").createComponent();
        corner.putClientProperty("Component.proxy", table);
        scrollPane.setCorner("UPPER_RIGHT_CORNER", corner);
    }

    private static void customize(JComponent editor, Column col) {
        editor.putClientProperty(JTable.class, true);
        for (FocusListener l : editor.getFocusListeners()) {
            editor.removeFocusListener(l);
        }
        if (editor instanceof Validatable) {
            Validatable v = (Validatable)((Object)editor);
            v.setRequired(col.isRequired());
            v.setCaption(col.getCaption());
        }
        Column.TypeHandler oHandler = ColumnHandlerUtil.newInstance().createTypeHandler(col);
        if (col.getTypeHandler() == null) {
            col.setTypeHandler(oHandler);
        }
        if (editor instanceof UIControl && oHandler != null) {
            ((UIControl)((Object)editor)).setPropertyInfo(oHandler);
        }
        if (editor instanceof XCheckBox) {
            XCheckBox xcomp = (XCheckBox)editor;
            xcomp.setHorizontalAlignment(0);
            xcomp.setBorderPainted(true);
        } else if (editor instanceof XComboBox) {
            XComboBox xcomp = (XComboBox)editor;
            xcomp.setDynamic(col.isDynamic());
            xcomp.setImmediate(true);
            if (col.isRequired()) {
                xcomp.setAllowNull(false);
            }
            if (col.getFieldType() != null) {
                xcomp.setFieldType(col.getFieldType());
            }
        } else if (editor instanceof XLookupField) {
            XLookupField xcomp = (XLookupField)editor;
            xcomp.setTransferFocusOnSelect(false);
        }
        Font font = (Font)UIManager.get("Table.font");
        editor.setFont(font);
        editor.setBackground(FOCUS_BG);
        if (col.getAlignment() != null && editor instanceof JTextField) {
            JTextField jtf = (JTextField)editor;
            if ("right".equals(col.getAlignment().toLowerCase())) {
                jtf.setHorizontalAlignment(4);
            } else if ("center".equals(col.getAlignment().toLowerCase())) {
                jtf.setHorizontalAlignment(0);
            } else if ("left".equals(col.getAlignment().toLowerCase())) {
                jtf.setHorizontalAlignment(2);
            }
        } else {
            Border inner = BorderFactory.createEmptyBorder(TableUtil.CELL_MARGIN.top, TableUtil.CELL_MARGIN.left, TableUtil.CELL_MARGIN.bottom, TableUtil.CELL_MARGIN.right);
            Border border = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
            if (border == null) {
                border = UIManager.getBorder("Table.focusCellHighlightBorder");
            }
            editor.setBorder(BorderFactory.createCompoundBorder(border, inner));
        }
    }

    static {
        editors.put("string", XTextField.class);
        editors.put("text", XTextField.class);
        editors.put("boolean", XCheckBox.class);
        editors.put("checkbox", XCheckBox.class);
        editors.put("combo", XComboBox.class);
        editors.put("combobox", XComboBox.class);
        editors.put("date", XDateField.class);
        editors.put("double", XDecimalField.class);
        editors.put("decimal", XDecimalField.class);
        editors.put("integer", XIntegerField.class);
        editors.put("lookup", XLookupField.class);
        editors.put("opener", XOpenerField.class);
        editors.put("selection", SelectionCellEditor.class);
        renderers.put("string", new CellRenderers.TextRenderer());
        renderers.put("text", new CellRenderers.TextRenderer());
        renderers.put("boolean", new CellRenderers.CheckBoxRenderer());
        renderers.put("checkbox", new CellRenderers.CheckBoxRenderer());
        renderers.put("combo", new CellRenderers.ComboBoxRenderer());
        renderers.put("combobox", new CellRenderers.ComboBoxRenderer());
        renderers.put("date", new CellRenderers.DateRenderer());
        renderers.put("double", new CellRenderers.DecimalRenderer());
        renderers.put("decimal", new CellRenderers.DecimalRenderer());
        renderers.put("integer", new CellRenderers.IntegerRenderer());
        renderers.put("label", new CellRenderers.LabelRenderer());
        renderers.put("lookup", new CellRenderers.LookupRenderer());
        renderers.put("opener", new CellRenderers.OpenerRenderer());
        renderers.put("icon", new CellRenderers.IconRenderer());
        renderers.put("dynamic", new DynamicCellRenderer());
        renderers.put("button", new CellRenderers.ButtonRenderer());
        renderers.put(SelectionColumnHandler.class, new SelectionCellRenderer());
        numClass.put("decimal", BigDecimal.class);
        numClass.put("integer", Integer.class);
        numClass.put("double", Double.class);
    }

    private static class DefaultActionTextIcon
    implements Icon {
        private DefaultActionTextIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            JButton b = new JButton("...");
            b.setSize(this.getIconWidth(), this.getIconHeight());
            Rectangle r = g.getClipBounds();
            Graphics g2 = g.create(x, y, r.width, r.height);
            b.paint(g2);
            g2.dispose();
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    }

    public static class IntegerRenderer
    extends AbstractNumberRenderer {
        @Override
        protected String getFormattedValue(Column c, Object value) {
            Integer num = null;
            if (value != null) {
                if (value instanceof Integer) {
                    num = (Integer)value;
                } else {
                    try {
                        num = new Integer(value.toString());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (num == null) {
                return null;
            }
            if (c.getFormat() == null) {
                return ((Object)num).toString();
            }
            return this.formatValue(num, c.getFormat(), "0");
        }
    }

    public static class DecimalRenderer
    extends AbstractNumberRenderer {
        @Override
        protected String getFormattedValue(Column c, Object value) {
            BigDecimal num = null;
            if (value != null) {
                if (value instanceof BigDecimal) {
                    num = (BigDecimal)value;
                } else {
                    try {
                        num = new BigDecimal(value.toString());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (num == null) {
                return null;
            }
            return this.formatValue(num, c.getFormat(), "#,##0.00");
        }
    }

    public static abstract class AbstractNumberRenderer
    extends AbstractRenderer {
        private JLabel label = new JLabel();

        public AbstractNumberRenderer() {
            this.label.setHorizontalAlignment(4);
        }

        @Override
        public JComponent getComponent(JTable table, int row, int column) {
            return this.label;
        }

        protected abstract String getFormattedValue(Column var1, Object var2);

        @Override
        public void refresh(JTable table, Object value, boolean selected, boolean focus, int row, int column) {
            String alignment;
            TableControl tc = (TableControl)((Object)table);
            Column c = ((TableControlModel)((Object)tc.getModel())).getColumn(column);
            String result = this.getFormattedValue(c, value);
            this.label.setText(result == null ? "" : result);
            String string = alignment = c.getAlignment() == null ? null : c.getAlignment().toUpperCase();
            if (alignment != null) {
                if ("CENTER".equals(alignment)) {
                    this.label.setHorizontalAlignment(0);
                } else if ("LEFT".equals(alignment)) {
                    this.label.setHorizontalAlignment(2);
                } else {
                    this.label.setHorizontalAlignment(4);
                }
            }
        }

        protected String formatValue(Number value, String format, String defaultFormat) {
            if (value == null) {
                return null;
            }
            if ("".equals(format)) {
                return value.toString();
            }
            DecimalFormat formatter = null;
            formatter = format != null ? new DecimalFormat(format) : new DecimalFormat(defaultFormat);
            return formatter.format(value);
        }
    }

    public static class BooleanRenderer
    extends AbstractRenderer {
        private JCheckBox component = new JCheckBox();
        private JLabel empty;

        public BooleanRenderer() {
            this.component.setHorizontalAlignment(0);
            this.component.setBorderPainted(true);
            this.empty = new JLabel("");
        }

        @Override
        public JComponent getComponent(JTable table, int rowIndex, int colIndex) {
            AbstractListDataProvider ldp = ((TableControl)((Object)table)).getDataProvider();
            if (ldp.getListItemData(rowIndex) == null) {
                return this.empty;
            }
            return this.component;
        }

        @Override
        public void refresh(JTable table, Object value, boolean selected, boolean focus, int rowIndex, int colIndex) {
            AbstractListDataProvider ldp = ((TableControl)((Object)table)).getDataProvider();
            if (ldp.getListItemData(rowIndex) == null) {
                return;
            }
            this.component.setSelected(this.resolveValue(value));
        }

        private boolean resolveValue(Object value) {
            boolean selected = false;
            if (value != null) {
                if ("true".equals(value + "")) {
                    selected = true;
                } else if ("yes".equals(value + "")) {
                    selected = true;
                } else if ("t".equals(value + "")) {
                    selected = true;
                } else if ("y".equals(value + "")) {
                    selected = true;
                } else if ("1".equals(value + "")) {
                    selected = true;
                }
            }
            return selected;
        }
    }

    public static class StringRenderer
    extends AbstractRenderer {
        private JLabel label = new JLabel();

        public StringRenderer() {
            this.label.setVerticalAlignment(0);
        }

        @Override
        public JComponent getComponent(JTable table, int row, int column) {
            return this.label;
        }

        @Override
        public void refresh(JTable table, Object value, boolean selected, boolean focus, int row, int column) {
            TableControl tc = (TableControl)((Object)table);
            Column c = ((TableControlModel)((Object)tc.getModel())).getColumn(column);
            Object columnValue = value;
            if (c.getExpression() != null) {
                ExpressionResolver er = ExpressionResolver.getInstance();
                try {
                    Object bean = columnValue;
                    if (table.getModel() instanceof DataTableModel) {
                        bean = ((DataTableModel)table.getModel()).getItem(row);
                    }
                    if (table instanceof DataTableComponent) {
                        bean = ((DataTableComponent)table).createExpressionBean(bean);
                    }
                    columnValue = UIControlUtil.evaluateExpr(bean, c.getExpression());
                }
                catch (Exception bean) {
                    // empty catch block
                }
            }
            String format = c.getFormat();
            String type = c.getType();
            if ("decimal".equals(type) || "double".equals(type) || columnValue instanceof BigDecimal || columnValue instanceof Double) {
                this.label.setHorizontalAlignment(4);
                this.label.setText(columnValue == null ? "" : this.format(columnValue, format, "#,##0.00"));
            } else if ("integer".equals(type) || columnValue instanceof Number) {
                this.label.setHorizontalAlignment(0);
                this.label.setText(columnValue == null ? "" : this.format(columnValue, format, "#,##0"));
            } else if ("date".equals(type) || columnValue instanceof Date || columnValue instanceof Time || columnValue instanceof Timestamp) {
                this.label.setHorizontalAlignment(0);
                SimpleDateFormat formatter = null;
                formatter = format != null ? new SimpleDateFormat(format) : new SimpleDateFormat("yyyy-MM-dd");
                this.label.setText(columnValue == null ? "" : formatter.format(columnValue));
            } else {
                this.label.setHorizontalAlignment(2);
                if (columnValue != null && c.isHtmlDisplay()) {
                    columnValue = "<html>" + columnValue + "</html>";
                }
                this.label.setText(columnValue == null ? "" : columnValue.toString());
            }
            if (c.getAlignment() != null) {
                this.getComponentSupport().alignText(this.label, c.getAlignment());
            }
        }

        private String format(Object value, String format, String defaultFormat) {
            DecimalFormat formatter = null;
            formatter = format != null ? new DecimalFormat(format) : new DecimalFormat(defaultFormat);
            return formatter.format(value);
        }
    }

    public static abstract class AbstractRenderer
    implements TableCellRenderer {
        private ComponentSupport componentSupport;

        protected ComponentSupport getComponentSupport() {
            if (this.componentSupport == null) {
                this.componentSupport = new ComponentSupport();
            }
            return this.componentSupport;
        }

        public abstract JComponent getComponent(JTable var1, int var2, int var3);

        public abstract void refresh(JTable var1, Object var2, boolean var3, boolean var4, int var5, int var6);

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            TableControl xtable = (TableControl)((Object)table);
            TableControlModel xmodel = (TableControlModel)((Object)xtable.getModel());
            JComponent comp = this.getComponent(table, row, column);
            comp.setBorder(BorderFactory.createEmptyBorder(TableUtil.CELL_MARGIN.top, TableUtil.CELL_MARGIN.left, TableUtil.CELL_MARGIN.bottom, TableUtil.CELL_MARGIN.right));
            comp.setFont(table.getFont());
            if (isSelected) {
                comp.setBackground(table.getSelectionBackground());
                comp.setForeground(table.getSelectionForeground());
                comp.setOpaque(true);
                if (hasFocus) {
                    comp.setBackground(FOCUS_BG);
                    comp.setForeground(table.getForeground());
                }
            } else {
                comp.setForeground(table.getForeground());
                comp.setOpaque(false);
                if (row % 2 == 0) {
                    if (xtable.getEvenBackground() != null) {
                        comp.setBackground(xtable.getEvenBackground());
                        comp.setOpaque(true);
                    }
                    if (xtable.getEvenForeground() != null) {
                        comp.setForeground(xtable.getEvenForeground());
                    }
                } else {
                    if (xtable.getOddBackground() != null) {
                        comp.setBackground(xtable.getOddBackground());
                        comp.setOpaque(true);
                    }
                    if (xtable.getOddForeground() != null) {
                        comp.setForeground(xtable.getOddForeground());
                    }
                }
            }
            AbstractListDataProvider lm = xtable.getDataProvider();
            ClientContext clientCtx = ClientContext.getCurrentContext();
            ExpressionResolver exprRes = ExpressionResolver.getInstance();
            Column colModel = xmodel.getColumn(column);
            String errmsg = lm.getMessageSupport().getErrorMessage(row);
            if (errmsg != null && !hasFocus) {
                comp.setBackground(xtable.getErrorBackground());
                comp.setForeground(xtable.getErrorForeground());
                comp.setOpaque(true);
            }
            if (!table.isEnabled()) {
                Color c = comp.getBackground();
                comp.setBackground(ColorUtil.brighter(c, 5));
                c = comp.getForeground();
                comp.setForeground(ColorUtil.brighter(c, 5));
            }
            Border inner = BorderFactory.createEmptyBorder(TableUtil.CELL_MARGIN.top, TableUtil.CELL_MARGIN.left, TableUtil.CELL_MARGIN.bottom, TableUtil.CELL_MARGIN.right);
            Border border = BorderFactory.createEmptyBorder(1, 1, 1, 1);
            if (hasFocus) {
                if (isSelected) {
                    border = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
                }
                if (border == null) {
                    border = UIManager.getBorder("Table.focusCellHighlightBorder");
                }
            }
            comp.setBorder(BorderFactory.createCompoundBorder(border, inner));
            this.refresh(table, value, isSelected, hasFocus, row, column);
            return comp;
        }

        private void applyStyle(String name, Map bean, Component comp, StyleRule[] styles, ExpressionResolver exprRes) {
            if (styles == null) {
                return;
            }
            if (name == null) {
                name = "_any_name";
            }
            for (StyleRule r : styles) {
                String pattern = r.getPattern();
                String rule = r.getExpression();
                boolean applyStyles = false;
                if (rule != null && name.matches(pattern)) {
                    try {
                        Object o = exprRes.eval(rule, (Object)bean);
                        applyStyles = Boolean.valueOf(o + "");
                    }
                    catch (Exception ign) {
                        System.out.println("STYLE RULE ERROR: " + ign.getMessage());
                    }
                }
                if (!applyStyles) continue;
                ControlSupport.setStyles(r.getProperties(), comp);
            }
        }
    }
}

