/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.text;

import com.rameses.rcp.control.text.DateParser;
import com.rameses.rcp.control.text.DefaultTextField;
import java.awt.event.KeyEvent;
import java.beans.Beans;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.EventObject;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public abstract class AbstractDateField
extends DefaultTextField {
    private IDateDocument document;
    private String outputFormat;
    private String valueFormat;
    private String inputMask;
    private String hint;
    private int advanceYearLimit = 15;

    @Override
    protected final void initDefaults() {
        if (!Beans.isDesignTime()) {
            this.setDocumentImpl(new BasicDateDocument());
        }
    }

    @Override
    public String getHint() {
        return this.hint;
    }

    @Override
    public void setHint(String hint) {
        this.hint = hint;
    }

    public String getInputFormat() {
        return this.getInputMask();
    }

    public void setInputFormat(String inputFormat) {
        this.setInputMask(inputFormat);
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public String getValueFormat() {
        return this.valueFormat;
    }

    public void setValueFormat(String valueFormat) {
        this.valueFormat = valueFormat;
    }

    public String getInputMask() {
        return this.inputMask;
    }

    public void setInputMask(String inputMask) {
        this.inputMask = inputMask;
    }

    public int getAdvanceYearLimit() {
        return this.advanceYearLimit;
    }

    public void setAdvanceYearLimit(int advanceYearLimit) {
        this.advanceYearLimit = advanceYearLimit;
    }

    public Object getValue() {
        return this.document == null ? null : this.document.getValue();
    }

    public void setValue(Object value) {
        if (this.document == null) {
            super.setText("");
        } else {
            this.document.setValue(value);
        }
    }

    protected void reloadDocument() {
        String mask = this.getInputMask();
        if (mask == null || mask.length() == 0) {
            this.setDocumentImpl(new BasicDateDocument());
        } else {
            this.setDocumentImpl(new MaskDateDocument(mask));
        }
    }

    private void setDocumentImpl(Document document) {
        super.setDocument(document);
        this.document = document instanceof IDateDocument ? (IDateDocument)((Object)document) : null;
    }

    private DateParser createDateParser() {
        DateParser parser = new DateParser();
        parser.setAdvanceYearLimit(this.getAdvanceYearLimit());
        return parser;
    }

    private class PatternMaskChar
    implements MaskChar {
        private char pattern;
        private char value;

        private PatternMaskChar() {
        }

        @Override
        public boolean accept(char value) {
            return value == 'y' || value == 'M' || value == 'd' || value == 'H' || value == 'm' || value == 's';
        }

        @Override
        public MaskChar createMaskChar(char value) {
            PatternMaskChar mc = new PatternMaskChar();
            mc.pattern = value;
            return mc;
        }

        @Override
        public boolean isAllowInput() {
            return true;
        }

        @Override
        public char getValue() {
            return this.value;
        }

        @Override
        public void setValue(char value) {
            this.value = Character.isDigit(value) ? value : (char)'\u0000';
        }

        @Override
        public void reset() {
            this.value = '\u0000';
        }
    }

    private class LiteralMaskChar
    implements MaskChar {
        private char value;

        private LiteralMaskChar() {
        }

        @Override
        public boolean accept(char value) {
            return true;
        }

        @Override
        public MaskChar createMaskChar(char value) {
            LiteralMaskChar mc = new LiteralMaskChar();
            mc.value = value;
            return mc;
        }

        @Override
        public boolean isAllowInput() {
            return false;
        }

        @Override
        public char getValue() {
            return this.value;
        }

        @Override
        public void setValue(char value) {
        }

        @Override
        public void reset() {
        }
    }

    private static interface MaskChar {
        public boolean accept(char var1);

        public MaskChar createMaskChar(char var1);

        public boolean isAllowInput();

        public char getValue();

        public void setValue(char var1);

        public void reset();
    }

    private class MaskDateDocument
    extends PlainDocument
    implements IDateDocument {
        AbstractDateField root;
        private SimpleDateFormat valueFormatter;
        private MaskChar[] maskDefs;
        private MaskChar[] masks;

        MaskDateDocument(String mask) {
            this.root = AbstractDateField.this;
            char[] chars = mask.toCharArray();
            this.masks = new MaskChar[chars.length];
            for (int i = 0; i < chars.length; ++i) {
                this.masks[i] = this.getWhichMaskChar(chars[i]);
            }
        }

        @Override
        public Object getValue() {
            char[] chars = new char[this.masks.length];
            for (int i = 0; i < chars.length; ++i) {
                chars[i] = this.masks[i].getValue();
            }
            try {
                String sval = new String(chars);
                String dtval = Date.valueOf(sval).toString();
                if (sval.equals(dtval)) {
                    return sval;
                }
                return null;
            }
            catch (Throwable t) {
                return null;
            }
        }

        @Override
        public void setValue(Object value) {
            char[] chars = value == null ? new char[]{} : value.toString().toCharArray();
            for (MaskChar mc : this.masks) {
                mc.reset();
            }
            for (int i = 0; i < chars.length && i < this.masks.length; ++i) {
                this.masks[i].setValue(chars[i]);
            }
            chars = this.getMaskValues();
            try {
                super.remove(0, this.getLength());
                super.insertString(0, new String(chars), null);
            }
            catch (BadLocationException ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }

        private MaskChar getWhichMaskChar(char ch) {
            if (this.maskDefs == null) {
                this.maskDefs = new MaskChar[]{new PatternMaskChar(), new LiteralMaskChar()};
            }
            for (MaskChar mc : this.maskDefs) {
                if (!mc.accept(ch)) continue;
                return mc.createMaskChar(ch);
            }
            return null;
        }

        private char[] getMaskValues() {
            char[] chars = new char[this.masks.length];
            for (int i = 0; i < chars.length; ++i) {
                chars[i] = this.masks[i].getValue();
                if (chars[i] != '\u0000') continue;
                chars[i] = 95;
            }
            return chars;
        }

        private String getText() {
            try {
                return new StringBuffer(this.getText(0, this.getLength())).toString();
            }
            catch (BadLocationException ex) {
                ex.printStackTrace();
                return null;
            }
        }

        private SimpleDateFormat getValueFormatter() {
            if (this.valueFormatter == null) {
                String format = this.root.getValueFormat();
                if (format == null || format.length() == 0) {
                    format = "yyyy-MM-dd";
                }
                this.valueFormatter = new SimpleDateFormat(format);
            }
            return this.valueFormatter;
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (offs >= this.masks.length) {
                return;
            }
            boolean hasChanges = false;
            int index = 0;
            int updatedIndex = 0;
            char[] chars = str.toCharArray();
            for (int i = offs; i < this.masks.length && index < chars.length; ++i) {
                if (!this.masks[i].isAllowInput()) continue;
                this.masks[i].setValue(chars[index]);
                char ch = this.masks[i].getValue();
                if (ch == '\u0000') break;
                updatedIndex = i;
                hasChanges = true;
                super.remove(i, 1);
                super.insertString(i, ch + "", a);
                ++index;
            }
            if (!hasChanges) {
                return;
            }
            int caretPos = this.getNextUpdatableIndex(updatedIndex + 1);
            if (caretPos < 0) {
                caretPos = updatedIndex + 1 == this.masks.length ? this.masks.length : offs;
            }
            try {
                this.root.setCaretPosition(caretPos);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private int getNextUpdatableIndex(int start) {
            for (int i = start; i < this.masks.length; ++i) {
                if (!this.masks[i].isAllowInput()) continue;
                return i;
            }
            return -1;
        }

        @Override
        public void remove(int offs, int len) throws BadLocationException {
            super.remove(offs, len);
            StringBuffer sb = new StringBuffer();
            int limit = offs + len;
            for (int i = offs; i < limit && i < this.masks.length; ++i) {
                this.masks[i].reset();
                char ch = this.masks[i].getValue();
                sb.append(ch == '\u0000' ? (char)'_' : (char)ch);
            }
            super.insertString(offs, sb.toString(), null);
            int caretPos = offs;
            try {
                this.root.setCaretPosition(caretPos);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private int getUpdatableIndexBefore(int start) {
            for (int i = start - 1; i > 0 && i < this.masks.length; --i) {
                if (!this.masks[i].isAllowInput()) continue;
                return i;
            }
            return -1;
        }

        private boolean isUpdatableIndex(int index) {
            if (index >= 0 && index < this.masks.length) {
                return this.masks[index].isAllowInput();
            }
            return false;
        }
    }

    private class BasicDateDocument
    extends PlainDocument
    implements IDateDocument {
        AbstractDateField root;
        private SimpleDateFormat outputFormatter;
        private SimpleDateFormat valueFormatter;
        private boolean dirty;

        private BasicDateDocument() {
            this.root = AbstractDateField.this;
        }

        @Override
        public Object getValue() {
            String sval = this.getText();
            if (sval == null || sval.length() == 0) {
                return null;
            }
            try {
                java.util.Date dt = AbstractDateField.this.createDateParser().parse(sval);
                if (dt == null) {
                    dt = this.getOutputFormatter().parse(sval);
                }
                if (dt == null) {
                    return null;
                }
                return this.getValueFormatter().format(dt);
            }
            catch (Throwable t) {
                return null;
            }
        }

        @Override
        public void setValue(Object value) {
            String sval = null;
            if (value != null && value instanceof EventObject) {
                if (value instanceof KeyEvent) {
                    char ch = ((KeyEvent)value).getKeyChar();
                    this.root.setText(ch + "");
                }
                return;
            }
            if (value != null) {
                if (value instanceof java.util.Date) {
                    sval = this.getOutputFormatter().format((java.util.Date)value);
                } else {
                    java.util.Date dt = AbstractDateField.this.createDateParser().parse(value.toString());
                    if (dt != null) {
                        sval = this.getOutputFormatter().format(dt);
                    }
                }
            }
            try {
                super.remove(0, this.getLength());
                if (sval != null) {
                    this.insertString(0, sval, null);
                }
            }
            catch (BadLocationException ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
            finally {
                this.dirty = false;
            }
        }

        private String getText() {
            try {
                return new StringBuffer(this.getText(0, this.getLength())).toString();
            }
            catch (BadLocationException ex) {
                ex.printStackTrace();
                return null;
            }
        }

        private SimpleDateFormat getOutputFormatter() {
            if (this.outputFormatter == null) {
                String format = this.root.getOutputFormat();
                if (format == null || format.length() == 0) {
                    format = "yyyy-MM-dd";
                }
                this.outputFormatter = new SimpleDateFormat(format);
            }
            return this.outputFormatter;
        }

        private SimpleDateFormat getValueFormatter() {
            if (this.valueFormatter == null) {
                String format = this.root.getValueFormat();
                if (format == null || format.length() == 0) {
                    format = "yyyy-MM-dd";
                }
                this.valueFormatter = new SimpleDateFormat(format);
            }
            return this.valueFormatter;
        }
    }

    private static interface IDateDocument {
        public Object getValue();

        public void setValue(Object var1);
    }
}

