/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.text;

import com.rameses.rcp.support.FontSupport;
import com.rameses.rcp.support.ImageIconSupport;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.RoundRectangle2D;
import java.util.Map;
import javax.swing.JLabel;

public class DefaultLabel
extends JLabel {
    private FontSupport fontSupport;
    private Font preferredFont;
    private Font sourceFont;
    private String fontStyle;
    private String iconResource;
    private boolean roundEnabled;
    private Color roundBackground;
    private Color roundBorderColor;
    private int roundSize = 20;

    public FontSupport getFontSupport() {
        if (this.fontSupport == null) {
            this.fontSupport = new FontSupport();
        }
        return this.fontSupport;
    }

    @Override
    public Font getFont() {
        return this.preferredFont;
    }

    @Override
    public void setFont(Font font) {
        this.sourceFont = font;
        this.preferredFont = this.getPreferredFont();
        super.setFont(this.preferredFont);
    }

    public Font getSourceFont() {
        return this.sourceFont;
    }

    public String getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(String fontStyle) {
        this.fontStyle = fontStyle;
        this.preferredFont = this.getPreferredFont();
        super.setFont(this.preferredFont);
    }

    public String getIconResource() {
        return this.iconResource;
    }

    public void setIconResource(String iconResource) {
        this.iconResource = iconResource;
        this.setIcon(ImageIconSupport.getInstance().getIcon(iconResource));
    }

    public Font getBaseFont() {
        return this.sourceFont == null ? super.getFont() : this.sourceFont;
    }

    public Font getPreferredFont() {
        Font baseFont = this.getBaseFont();
        if (baseFont != null) {
            Map attrs = this.getFontSupport().createFontAttributes(this.getFontStyle());
            baseFont = this.getFontSupport().applyStyles(baseFont, attrs);
        }
        return baseFont;
    }

    public boolean isRoundEnabled() {
        return this.roundEnabled;
    }

    public void setRoundEnabled(boolean roundEnabled) {
        this.roundEnabled = roundEnabled;
    }

    public Color getRoundBackground() {
        return this.roundBackground;
    }

    public void setRoundBackground(Color roundBackground) {
        this.roundBackground = roundBackground;
    }

    public Color getRoundBorderColor() {
        return this.roundBorderColor;
    }

    public void setRoundBorderColor(Color roundBorderColor) {
        this.roundBorderColor = roundBorderColor;
    }

    public int getRoundSize() {
        return this.roundSize;
    }

    public void setRoundSize(int roundSize) {
        this.roundSize = roundSize;
    }

    @Override
    public Insets getInsets() {
        if (this.isRoundEnabled() && this.getRoundSize() > 0) {
            int rsize = this.getRoundSize();
            int rhalf = rsize / 2;
            rhalf = rhalf < 1 ? rsize : rhalf;
            return new Insets(rhalf, rhalf, rhalf, rhalf);
        }
        return super.getInsets();
    }

    @Override
    public Insets getInsets(Insets insets) {
        if (this.isRoundEnabled() && this.getRoundSize() > 0) {
            int rsize = this.getRoundSize();
            int rhalf = rsize / 2;
            int n = rhalf = rhalf < 1 ? rsize : rhalf;
            if (insets == null) {
                insets = new Insets(0, 0, 0, 0);
            }
            insets.bottom = insets.right = rhalf;
            insets.left = insets.right;
            insets.top = insets.right;
            return insets;
        }
        return super.getInsets(insets);
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.isRoundEnabled()) {
            int hh;
            int ww;
            Color rcolor = this.getRoundBackground();
            int rsize = this.getRoundSize();
            Graphics2D g2 = (Graphics2D)g.create();
            Color oldColor = g2.getColor();
            Insets pad = this.getInsets();
            if (pad == null) {
                pad = new Insets(0, 0, 0, 0);
            }
            int width = this.getWidth();
            int height = this.getHeight();
            if (rsize > 0 && rcolor != null) {
                ww = width - 1;
                hh = height - 1;
                g2.setColor(rcolor);
                g2.fill(new RoundRectangle2D.Double(0.0, 0.0, ww, hh, rsize, rsize));
            }
            rcolor = this.getRoundBorderColor();
            if (rsize > 0 && rcolor != null) {
                ww = width - 1;
                hh = height - 1;
                g2.setColor(rcolor);
                g2.draw(new RoundRectangle2D.Double(0.0, 0.0, ww, hh, rsize, rsize));
            }
            g2.setColor(oldColor);
            g2.dispose();
        }
        super.paintComponent(g);
    }
}

