/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.text;

import com.rameses.rcp.common.PopupItem;
import com.rameses.rcp.common.Task;
import com.rameses.rcp.control.text.HtmlEditorPopup;
import com.rameses.rcp.control.text.HtmlLinkDialog;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.support.FontSupport;
import com.rameses.rcp.util.TimerManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.Beans;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class HtmlEditorPanel
extends JPanel {
    final String ACTION_MAPPING_VK_SPACE = "ACTION_MAPPING_VK_SPACE";
    final String ACTION_MAPPING_VK_ESC = "ACTION_MAPPING_VK_ESCAPE";
    final String ACTION_MAPPING_VK_DOWN = "ACTION_MAPPING_VK_DOWN";
    final String ACTION_MAPPING_VK_UP = "ACTION_MAPPING_VK_UP";
    final String ACTION_MAPPING_VK_ENTER = "ACTION_MAPPING_VK_ENTER";
    private JPanel toolbar;
    private JTextPane editor;
    private JScrollPane scrollpane;
    private HTMLEditorKit htmlkit;
    private HTMLDocument htmldoc;
    private String fontStyle;
    private boolean toolbarVisible;
    private Style defaultStyle;
    private HtmlEditorPopup jpopup;

    public HtmlEditorPanel() {
        this.initComponent();
    }

    private void initComponent() {
        super.setLayout(new BorderLayout());
        JTextPane ed = this.getEditor();
        ed.setDocument(new HTMLDocument());
        ed.setEditable(true);
        if (!Beans.isDesignTime()) {
            ed.setContentType("text/html");
            this.htmldoc = (HTMLDocument)ed.getDocument();
            this.htmlkit = (HTMLEditorKit)ed.getEditorKit();
            this.htmlkit.getStyleSheet().addRule("A { color: #0000ff; }");
        }
        JPanel toolbar = this.getToolbar();
        toolbar.setLayout(new ToolbarLayout());
        toolbar.add(new BoldActionButton());
        toolbar.add(new ItalicActionButton());
        toolbar.add(new UnderlineActionButton());
        toolbar.add(new StrikeThroughActionButton());
        toolbar.add(Box.createHorizontalStrut(10));
        toolbar.add(new BulletActionButton());
        toolbar.add(new NumberListActionButton());
        toolbar.add(Box.createHorizontalStrut(10));
        toolbar.add(new LinkActionButton());
        toolbar.add(new TestActionButton());
        this.add((Component)toolbar, "North");
        this.toolbarVisible = true;
        JScrollPane scrollpane = new JScrollPane(ed);
        this.add(scrollpane);
        KeyStroke vkspace = KeyStroke.getKeyStroke(32, 128, true);
        ed.getInputMap().put(vkspace, "ACTION_MAPPING_VK_SPACE");
        ed.getActionMap().put("ACTION_MAPPING_VK_SPACE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HtmlEditorPanel.this.fireSearch();
            }
        });
        KeyStroke vkescape = KeyStroke.getKeyStroke(27, 0);
        ed.getInputMap().put(vkescape, "ACTION_MAPPING_VK_ESCAPE");
        ed.getActionMap().put("ACTION_MAPPING_VK_ESCAPE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HtmlEditorPanel.this.fireEscapeKeyEvent();
            }
        });
        ed.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 40: {
                        if (!HtmlEditorPanel.this.getPopup().isVisible() || !HtmlEditorPanel.this.getPopup().isShowing()) break;
                        e.consume();
                        HtmlEditorPanel.this.getPopup().moveDown();
                        break;
                    }
                    case 38: {
                        if (!HtmlEditorPanel.this.getPopup().isVisible() || !HtmlEditorPanel.this.getPopup().isShowing()) break;
                        e.consume();
                        HtmlEditorPanel.this.getPopup().moveUp();
                        break;
                    }
                    case 10: {
                        if (!HtmlEditorPanel.this.getPopup().isVisible() || !HtmlEditorPanel.this.getPopup().isShowing()) break;
                        e.consume();
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                HtmlEditorPanel.this.fireSelectItem();
                            }
                        });
                        break;
                    }
                    default: {
                        try {
                            int pos = HtmlEditorPanel.this.editor.getCaretPosition() - 1;
                            if (pos < 0) {
                                return;
                            }
                            String str = e.getKeyChar() + "";
                            boolean whitespace = str.matches("\\s");
                            if (whitespace) {
                                HtmlEditorPanel.this.getPopup().setVisible(false);
                                return;
                            }
                            if (!HtmlEditorPanel.this.getPopup().isVisible() || !HtmlEditorPanel.this.getPopup().isShowing() || whitespace) break;
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    HtmlEditorPanel.this.fireSearch();
                                }
                            });
                            break;
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                }
            }
        });
    }

    private JTextPane getEditor() {
        if (this.editor == null) {
            this.editor = new JTextPane();
        }
        return this.editor;
    }

    private JPanel getToolbar() {
        if (this.toolbar == null) {
            this.toolbar = new JPanel();
        }
        return this.toolbar;
    }

    private Style getDefaultStyle() {
        if (this.defaultStyle == null) {
            this.defaultStyle = StyleContext.getDefaultStyleContext().getStyle("default");
        }
        return this.defaultStyle;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (Beans.isDesignTime()) {
            this.setText(name == null ? "" : name);
        }
    }

    public String getText() {
        String sval;
        String string = sval = this.editor == null ? null : this.editor.getText();
        if (sval == null || sval.length() == 0) {
            return null;
        }
        return sval;
    }

    public void setText(String text) {
        if (this.editor != null) {
            this.editor.setText(text == null ? "" : text);
        }
    }

    public Object getValue() {
        return this.getText();
    }

    public void setValue(Object value) {
        try {
            URL url = null;
            if (value == null) {
                this.editor.setText("");
                this.editor.setCaretPosition(0);
            } else if (value instanceof URL) {
                url = (URL)value;
            } else if (value.toString().toLowerCase().matches("^[a-zA-Z0-9]{1,}://.*$")) {
                url = new URL(value.toString());
            } else {
                this.editor.setText(value.toString());
                this.editor.setCaretPosition(0);
            }
            if (url != null) {
                URLWorkerTask uwt = new URLWorkerTask(url);
                ClientContext.getCurrentContext().getTaskManager().addTask(uwt);
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected HTMLDocument getDocument() {
        return this.htmldoc;
    }

    public String getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(String fontStyle) {
        this.fontStyle = fontStyle;
        new FontSupport().applyStyles((JComponent)this, fontStyle);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.getEditor().setFont(font);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.isToolbarVisible()) {
            this.toolbar.setVisible(enabled);
        }
    }

    public boolean isEditable() {
        return this.editor.isEditable();
    }

    public void setEditable(boolean editable) {
        this.editor.setEditable(editable);
        if (this.isToolbarVisible()) {
            this.toolbar.setVisible(editable);
        }
    }

    public boolean isToolbarVisible() {
        return this.toolbarVisible;
    }

    public void setToolbarVisible(boolean toolbarVisible) {
        this.toolbarVisible = toolbarVisible;
        this.getToolbar().setVisible(toolbarVisible);
    }

    public void setRequestFocus(boolean focus) {
        if (this.editor.isEnabled()) {
            this.editor.requestFocus();
        }
    }

    protected Object getEditorClientProperty(Object key) {
        return this.editor.getClientProperty(key);
    }

    protected void setEditorClientProperty(Object key, Object value) {
        this.editor.putClientProperty(key, value);
    }

    private String getSearchtext() {
        try {
            String str;
            int caretpos = this.editor.getCaretPosition();
            StringBuffer sb = new StringBuffer();
            for (int i = caretpos - 1; i >= 0 && !(str = this.htmldoc.getText(i, 1)).matches("\\s"); --i) {
                if (sb.length() == 0) {
                    sb.append(str);
                    continue;
                }
                sb.insert(0, str);
            }
            return sb.length() == 0 ? null : sb.toString();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    private void fireSearch() {
        String searchtext = this.getSearchtext();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("searchtext", searchtext);
        List results = this.fetchList(params);
        if (results == null) {
            return;
        }
        TimerManager.getInstance().schedule(new LookupTask(params), 300L);
    }

    private int getWhitespacePositionBefore(int pos) {
        try {
            for (int i = pos - 1; i >= 0; --i) {
                String str = this.htmldoc.getText(i, 1);
                if (!str.matches("\\s")) continue;
                return i;
            }
            return -1;
        }
        catch (Throwable t) {
            return -1;
        }
    }

    private void fireSelectItem() {
        PopupItem pi = this.getPopup().getSelectedItem();
        String template = this.getTemplate(pi.getUserObject());
        if (template == null) {
            template = "";
        }
        int doclen = this.htmldoc.getLength();
        int curpos = this.editor.getCaretPosition();
        int startpos = this.getWhitespacePositionBefore(curpos) + 1;
        try {
            this.htmldoc.replace(startpos, curpos - startpos, "", null);
            this.htmldoc.insertString(startpos, template, null);
            this.getPopup().setVisible(false);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void fireEscapeKeyEvent() {
        if (this.getPopup().isVisible() && this.getPopup().isShowing()) {
            this.getPopup().setVisible(false);
        }
    }

    protected void fireMoveDown() {
        if (this.getPopup().isVisible() && this.getPopup().isShowing()) {
            this.getPopup().moveDown();
        }
    }

    protected void fireMoveUp() {
        if (this.getPopup().isVisible() && this.getPopup().isShowing()) {
            this.getPopup().moveUp();
        }
    }

    protected List fetchList(Map params) {
        return null;
    }

    protected Object getFormattedText(Object item) {
        return item == null ? null : item.toString();
    }

    protected String getTemplate(Object item) {
        return item == null ? null : item.toString();
    }

    protected void setEditorInputVerifier(InputVerifier inputVerifier) {
        this.getEditor().setInputVerifier(inputVerifier);
    }

    private ImageIcon getImageIcon(String name) {
        try {
            ClassLoader loader = null;
            loader = Beans.isDesignTime() ? this.getClass().getClassLoader() : ClientContext.getCurrentContext().getClassLoader();
            URL url = loader.getResource(name);
            return new ImageIcon(url);
        }
        catch (Throwable ex) {
            System.out.println("[WARN] failed to load icon caused by " + ex.getClass().getName() + ": " + ex.getMessage());
            return null;
        }
    }

    private HtmlEditorPopup getPopup() {
        if (this.jpopup == null) {
            this.jpopup = new HtmlEditorPopup(this.editor);
            this.jpopup.add(new HtmlEditorPopup.SelectionListener(){

                @Override
                public void onselect(PopupItem item) {
                    HtmlEditorPanel.this.fireSelectItem();
                }
            });
        }
        return this.jpopup;
    }

    private void showPopup() {
        try {
            Rectangle rect = this.editor.modelToView(this.editor.getCaretPosition());
            HtmlEditorPopup popup = this.getPopup();
            popup.pack();
            popup.setSize(100, 20);
            popup.show(this.editor, rect.x, rect.y + rect.height);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private class ResultDataLoader
    implements Runnable {
        HtmlEditorPanel root;
        private List result;

        ResultDataLoader(List result) {
            this.root = HtmlEditorPanel.this;
            this.result = result;
        }

        @Override
        public void run() {
            HtmlEditorPopup popup = this.root.getPopup();
            if (this.result == null || this.result.isEmpty()) {
                popup.setVisible(false);
                return;
            }
            ArrayList<PopupItem> items = new ArrayList<PopupItem>();
            for (int i = 0; i < popup.getRowSize(); ++i) {
                try {
                    Object o = this.result.get(i);
                    Object caption = this.root.getFormattedText(o);
                    items.add(new PopupItem(o, caption == null ? "" : caption.toString()));
                    continue;
                }
                catch (Throwable t) {
                    break;
                }
            }
            if (items.isEmpty()) {
                popup.setVisible(false);
                return;
            }
            popup.setData(items);
            HtmlEditorPanel.this.showPopup();
        }
    }

    private class LookupTask
    implements Runnable {
        HtmlEditorPanel root;
        private String searchtext;
        private Map params;

        LookupTask(Map params) {
            this.root = HtmlEditorPanel.this;
            this.params = params;
            this.searchtext = params == null ? null : (String)params.get("searchtext");
        }

        @Override
        public void run() {
            String str = this.root.getSearchtext() + "";
            if (!str.equals(this.searchtext + "")) {
                return;
            }
            List list = this.root.fetchList(this.params);
            EventQueue.invokeLater(new ResultDataLoader(list));
        }
    }

    private class URLWorkerTask
    extends Task {
        private URL url;
        private boolean done;

        URLWorkerTask(URL url) {
            this.url = url;
        }

        @Override
        public boolean accept() {
            return !this.done;
        }

        @Override
        public void execute() {
            try {
                HtmlEditorPanel.this.editor.setText("<html><body><b>Loading...</b></body></html>");
                if (this.url != null) {
                    HtmlEditorPanel.this.editor.setPage(this.url);
                }
                HtmlEditorPanel.this.editor.setCaretPosition(0);
            }
            catch (Throwable t) {
                HtmlEditorPanel.this.editor.setText("<html><body color=\"red\">error caused by " + t.getMessage() + "</body></html>");
                if (ClientContext.getCurrentContext().isDebugMode()) {
                    t.printStackTrace();
                }
            }
            finally {
                this.done = true;
            }
        }
    }

    private class ToolbarLayout
    implements LayoutManager {
        private ToolbarLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dimension getLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                int w = 0;
                int h = 0;
                Component[] comps = parent.getComponents();
                for (int i = 0; i < comps.length; ++i) {
                    Component c = comps[i];
                    if (!c.isVisible()) continue;
                    Dimension dim = c.getPreferredSize();
                    w += dim.width;
                    h = Math.max(dim.height, h);
                }
                Insets margin = parent.getInsets();
                return new Dimension(w += margin.left + margin.right, h += margin.top + margin.bottom);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets margin = parent.getInsets();
                int pw = parent.getWidth();
                int ph = parent.getHeight();
                int x = margin.left;
                int y = margin.top;
                int w = pw - (margin.left + margin.right);
                int h = ph - (margin.top + margin.bottom);
                Component[] comps = parent.getComponents();
                for (int i = 0; i < comps.length; ++i) {
                    Component c = comps[i];
                    if (!c.isVisible()) continue;
                    Dimension dim = c.getPreferredSize();
                    c.setBounds(x, y, dim.width, h);
                    x += dim.width;
                }
            }
        }
    }

    private class TestActionButton
    extends JButton
    implements ActionListener {
        private Style style;

        TestActionButton() {
            super("Test");
            this.setMargin(new Insets(1, 3, 1, 3));
            this.setFocusable(false);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Document doc = HtmlEditorPanel.this.editor.getDocument();
            String text = "";
            try {
                text = doc.getText(0, doc.getLength());
            }
            catch (BadLocationException ex) {
                ex.printStackTrace();
            }
            StringBuffer sb = new StringBuffer();
            int len = doc.getLength();
            StyledDocument sdoc = HtmlEditorPanel.this.editor.getStyledDocument();
            for (int i = 0; i < len; ++i) {
            }
        }
    }

    private class LinkActionButton
    extends JButton
    implements ActionListener {
        LinkActionButton() {
            this.setMargin(new Insets(1, 3, 1, 3));
            this.setToolTipText("Hyperlink");
            this.setFocusable(false);
            this.setIcon(HtmlEditorPanel.this.getImageIcon("com/rameses/rcp/icons/editor/link.png"));
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!HtmlEditorPanel.this.editor.isEnabled()) {
                return;
            }
            if (!HtmlEditorPanel.this.editor.hasFocus()) {
                HtmlEditorPanel.this.editor.grabFocus();
            }
            StyledDocument doc = HtmlEditorPanel.this.editor.getStyledDocument();
            int startpos = HtmlEditorPanel.this.editor.getSelectionStart();
            String seltext = HtmlEditorPanel.this.editor.getSelectedText();
            if (seltext != null && seltext.length() != 0) {
                Object initialValue = null;
                MutableAttributeSet attr = HtmlEditorPanel.this.htmlkit.getInputAttributes();
                Object anchor = attr.getAttribute(HTML.Tag.A);
                if (anchor instanceof SimpleAttributeSet) {
                    SimpleAttributeSet aset = (SimpleAttributeSet)anchor;
                    initialValue = aset.getAttribute(HTML.Attribute.HREF);
                }
                HtmlLinkDialog dialog = new HtmlLinkDialog();
                dialog.setCaption("Enter a URL: ");
                dialog.setValue(initialValue);
                if (dialog.open(HtmlEditorPanel.this) != 1) {
                    return;
                }
                String surl = dialog.getValue();
                if (surl == null || surl.length() == 0) {
                    if (anchor == null) {
                        return;
                    }
                    attr.removeAttribute(HTML.Tag.A);
                    try {
                        int len = seltext.length();
                        HtmlEditorPanel.this.htmldoc.remove(startpos, len);
                        HtmlEditorPanel.this.htmldoc.insertString(startpos, seltext, attr);
                        HtmlEditorPanel.this.editor.select(startpos, startpos + len);
                    }
                    catch (Throwable len) {}
                } else {
                    SimpleAttributeSet ahref = new SimpleAttributeSet();
                    ahref.addAttribute(HTML.Attribute.HREF, surl);
                    SimpleAttributeSet alink = new SimpleAttributeSet();
                    alink.addAttribute(HTML.Tag.A, ahref);
                    this.setCharacterAttributes(alink, false);
                }
            }
        }

        private void setCharacterAttributes(AttributeSet attr, boolean replace) {
            int p1;
            int p0 = HtmlEditorPanel.this.editor.getSelectionStart();
            if (p0 != (p1 = HtmlEditorPanel.this.editor.getSelectionEnd())) {
                HtmlEditorPanel.this.htmldoc.setCharacterAttributes(p0, p1 - p0, attr, replace);
            }
            MutableAttributeSet inputAttributes = HtmlEditorPanel.this.htmlkit.getInputAttributes();
            if (replace) {
                inputAttributes.removeAttributes(inputAttributes);
            }
            inputAttributes.addAttributes(attr);
        }

        private boolean isStyleApplied(StyledDocument doc, String seltext, int startpos) {
            int len;
            int n = len = seltext == null ? 0 : seltext.length();
            if (len == 0) {
                return false;
            }
            for (int i = 0; i < len; ++i) {
                AttributeSet attrs = doc.getCharacterElement(startpos + i).getAttributes();
                if (StyleConstants.isStrikeThrough(attrs)) continue;
                return false;
            }
            return true;
        }
    }

    private class NumberListActionButton
    extends JButton {
        NumberListActionButton() {
            this.setMargin(new Insets(1, 3, 1, 3));
            this.setFocusable(false);
            String html = "<ol><li></li></ol>";
            HTMLEditorKit.InsertHTMLTextAction action = new HTMLEditorKit.InsertHTMLTextAction("NumberedList", html, HTML.Tag.OL, HTML.Tag.LI, HTML.Tag.BODY, HTML.Tag.OL);
            this.setAction(action);
            this.setText("");
            this.setToolTipText("Number list");
            this.setIcon(HtmlEditorPanel.this.getImageIcon("com/rameses/rcp/icons/editor/numberlist.png"));
        }
    }

    private class BulletActionButton
    extends JButton {
        BulletActionButton() {
            this.setMargin(new Insets(1, 3, 1, 3));
            this.setFocusable(false);
            String html = "<ul><li></li></ul>";
            HTMLEditorKit.InsertHTMLTextAction action = new HTMLEditorKit.InsertHTMLTextAction("Bullets", html, HTML.Tag.UL, HTML.Tag.LI, HTML.Tag.BODY, HTML.Tag.UL);
            this.setAction(action);
            this.setText("");
            this.setToolTipText("Bullet list");
            this.setIcon(HtmlEditorPanel.this.getImageIcon("com/rameses/rcp/icons/editor/bullet.png"));
        }
    }

    private class StrikeThroughActionButton
    extends JButton
    implements ActionListener {
        StrikeThroughActionButton() {
            this.setMargin(new Insets(1, 3, 1, 3));
            this.setToolTipText("StrikeThrough");
            this.setFocusable(false);
            this.setIcon(HtmlEditorPanel.this.getImageIcon("com/rameses/rcp/icons/editor/strikethrough.png"));
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MutableAttributeSet attr;
            if (!HtmlEditorPanel.this.editor.isEnabled()) {
                return;
            }
            if (!HtmlEditorPanel.this.editor.hasFocus()) {
                HtmlEditorPanel.this.editor.grabFocus();
            }
            boolean toggle = !StyleConstants.isStrikeThrough(attr = HtmlEditorPanel.this.htmlkit.getInputAttributes());
            SimpleAttributeSet sas = new SimpleAttributeSet();
            StyleConstants.setStrikeThrough(sas, toggle);
            this.setCharacterAttributes(sas, false);
        }

        private void setCharacterAttributes(AttributeSet attr, boolean replace) {
            int p1;
            int p0 = HtmlEditorPanel.this.editor.getSelectionStart();
            if (p0 != (p1 = HtmlEditorPanel.this.editor.getSelectionEnd())) {
                HtmlEditorPanel.this.htmldoc.setCharacterAttributes(p0, p1 - p0, attr, replace);
            }
            MutableAttributeSet inputAttributes = HtmlEditorPanel.this.htmlkit.getInputAttributes();
            if (replace) {
                inputAttributes.removeAttributes(inputAttributes);
            }
            inputAttributes.addAttributes(attr);
        }
    }

    private class UnderlineActionButton
    extends JButton {
        UnderlineActionButton() {
            this.setMargin(new Insets(1, 3, 1, 3));
            this.setToolTipText("Underline");
            this.setFocusable(false);
            this.setIcon(HtmlEditorPanel.this.getImageIcon("com/rameses/rcp/icons/editor/underline.png"));
            this.addActionListener(new StyledEditorKit.UnderlineAction());
        }
    }

    private class ItalicActionButton
    extends JButton {
        ItalicActionButton() {
            this.setMargin(new Insets(1, 3, 1, 3));
            this.setToolTipText("Italic");
            this.setFocusable(false);
            this.setIcon(HtmlEditorPanel.this.getImageIcon("com/rameses/rcp/icons/editor/italic.png"));
            this.addActionListener(new StyledEditorKit.ItalicAction());
        }
    }

    private class BoldActionButton
    extends JButton {
        BoldActionButton() {
            this.setMargin(new Insets(1, 3, 1, 3));
            this.setFocusable(false);
            this.setToolTipText("Bold");
            this.setIcon(HtmlEditorPanel.this.getImageIcon("com/rameses/rcp/icons/editor/bold.png"));
            this.addActionListener(new StyledEditorKit.BoldAction());
        }
    }
}

