/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.text;

import com.rameses.rcp.ui.UIInputVerifier;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;

public class InputVerifierProxy
extends InputVerifier {
    private InputVerifier verifier;
    private InputVerifier child;
    private boolean processing;
    private boolean enabled;

    public InputVerifierProxy() {
        this(null);
    }

    public InputVerifierProxy(InputVerifier verifier) {
        this.verifier = verifier;
        this.processing = false;
        this.enabled = true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public InputVerifier getChild() {
        return this.child;
    }

    public void setChild(InputVerifier child) {
        this.child = child;
    }

    public void destroy() {
        this.verifier = null;
        this.child = null;
    }

    @Override
    public boolean verify(JComponent input) {
        if (!this.enabled) {
            return true;
        }
        if (this.processing) {
            return false;
        }
        try {
            InputVerifier[] verifiers;
            boolean b;
            this.processing = true;
            input.firePropertyChange("detachInputVerifier", false, true);
            if (!input.isEnabled()) {
                boolean bl = true;
                return bl;
            }
            if (input instanceof JTextComponent) {
                JTextComponent jtxt = (JTextComponent)input;
                if (jtxt.getClientProperty("InputVerifierRouter") instanceof InputVerifier) {
                    InputVerifier router = (InputVerifier)jtxt.getClientProperty("InputVerifierRouter");
                    boolean bl = router.verify(input);
                    return bl;
                }
                if (!jtxt.isEditable()) {
                    boolean bl = true;
                    return bl;
                }
            }
            if (input instanceof UIInputVerifier && !(b = ((UIInputVerifier)((Object)input)).verify(input))) {
                boolean bl = false;
                return bl;
            }
            for (InputVerifier iv : verifiers = new InputVerifier[]{this.verifier, this.child}) {
                if (iv == null) continue;
                boolean b2 = iv.verify(input);
                this.processing = true;
                if (b2) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (RuntimeException rex) {
            throw rex;
        }
        finally {
            input.firePropertyChange("detachInputVerifier", true, false);
            this.processing = false;
        }
    }
}

