/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.text;

import com.rameses.rcp.common.DocViewModel;
import com.rameses.rcp.common.PopupItem;
import com.rameses.rcp.common.TextDocumentModel;
import com.rameses.rcp.common.TextWriter;
import com.rameses.rcp.constant.TextCase;
import com.rameses.rcp.constant.TrimSpaceOption;
import com.rameses.rcp.control.text.TextComponentSupport;
import com.rameses.rcp.control.text.TextEditorPopupSelector;
import com.rameses.rcp.support.TextDocument;
import com.rameses.rcp.util.TimerManager;
import com.rameses.rcp.util.UIInputUtil;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.Beans;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class TextAreaImpl
extends JTextArea {
    public final String ACTION_MAPPING_VK_SPACE = "ACTION_MAPPING_VK_SPACE";
    public final String ACTION_MAPPING_VK_ESC = "ACTION_MAPPING_VK_ESCAPE";
    public final String ACTION_MAPPING_VK_DOWN = "ACTION_MAPPING_VK_DOWN";
    public final String ACTION_MAPPING_VK_UP = "ACTION_MAPPING_VK_UP";
    public final String ACTION_MAPPING_VK_ENTER = "ACTION_MAPPING_VK_ENTER";
    private Color focusBackground;
    private Color disabledBackground;
    private Color enabledBackground;
    private TextDocument textDocument;
    private VerticalAdjustmentListener verticalAdjHandler;
    private TextWriterHandler textWriterHandler;
    private String hint;
    private boolean allowShowHint;
    private boolean autoScrollDown;
    private boolean exitOnTabKey;
    private boolean readonly;
    private TrimSpaceOption trimSpaceOption;
    private TextEditorPopupSelector jpopup;

    public TextAreaImpl() {
        this.initComponent();
    }

    private void initComponent() {
        this.textDocument = new TextDocument();
        this.trimSpaceOption = TrimSpaceOption.NONE;
        this.textWriterHandler = new TextWriterHandler();
        this.verticalAdjHandler = new VerticalAdjustmentListener();
        TextComponentSupport.getInstance().installUIDefaults(this);
        for (FocusListener l : this.getFocusListeners()) {
            this.removeFocusListener(l);
        }
        if (Beans.isDesignTime()) {
            return;
        }
        KeyStroke vkspace = KeyStroke.getKeyStroke(32, 128, true);
        this.getInputMap().put(vkspace, "ACTION_MAPPING_VK_SPACE");
        this.getActionMap().put("ACTION_MAPPING_VK_SPACE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextAreaImpl.this.fireSearch();
            }
        });
        KeyStroke vkescape = KeyStroke.getKeyStroke(27, 0);
        this.getInputMap().put(vkescape, "ACTION_MAPPING_VK_ESCAPE");
        this.getActionMap().put("ACTION_MAPPING_VK_ESCAPE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextAreaImpl.this.fireEscapeKeyEvent();
            }
        });
        this.addKeyListener(new KeyAdapterImpl());
    }

    public final TextDocument getTextDocument() {
        return this.textDocument;
    }

    @Override
    public void paint(Graphics origGraphics) {
        super.paint(origGraphics);
        if (this.allowShowHint && this.getDocument().getLength() == 0) {
            Graphics g = origGraphics.create();
            Font f = this.getFont();
            FontMetrics fm = g.getFontMetrics(f);
            g.setColor(Color.LIGHT_GRAY);
            g.setFont(f);
            Insets margin = this.getInsets();
            int x = margin.left;
            int y = margin.top + fm.getAscent();
            g.drawString(" " + this.getHint(), x, y);
            g.dispose();
        }
    }

    public void refresh() {
    }

    public void load() {
        this.setInputVerifier(UIInputUtil.VERIFIER);
        this.setDocument(this.textDocument);
    }

    public void configureHandlerObject(Object handerObject) {
        if (handerObject instanceof TextDocumentModel) {
            ((TextDocumentModel)handerObject).setProvider(new DocumentProvider());
        }
        if (handerObject instanceof TextWriter) {
            ((TextWriter)handerObject).setHandler(this.textWriterHandler);
        }
    }

    public TextCase getTextCase() {
        return this.textDocument.getTextCase();
    }

    public void setTextCase(TextCase textCase) {
        this.textDocument.setTextCase(textCase);
    }

    public TrimSpaceOption getTrimSpaceOption() {
        return this.trimSpaceOption;
    }

    public void setTrimSpaceOption(TrimSpaceOption trimSpaceOption) {
        this.trimSpaceOption = trimSpaceOption;
    }

    public String getHint() {
        return this.hint;
    }

    public void setHint(String hint) {
        this.hint = hint;
        this.allowShowHint = hint != null && hint.trim().length() > 0;
    }

    public Color getFocusBackground() {
        return this.focusBackground;
    }

    public void setFocusBackground(Color focusBackground) {
        this.focusBackground = focusBackground;
    }

    public Color getDisabledBackground() {
        return this.disabledBackground;
    }

    public void setDisabledBackground(Color disabledBackground) {
        this.disabledBackground = disabledBackground;
    }

    public Color getEnabledBackground() {
        return this.enabledBackground;
    }

    public void setEnabledBackground(Color enabledBackground) {
        this.enabledBackground = enabledBackground;
    }

    public boolean isExitOnTabKey() {
        return this.exitOnTabKey;
    }

    public void setExitOnTabKey(boolean exitOnTabKey) {
        this.exitOnTabKey = exitOnTabKey;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean readonly) {
        if (!this.isEnabled()) {
            return;
        }
        this.readonly = readonly;
        this.setEditable(!readonly);
        super.firePropertyChange("editable", readonly, !readonly);
    }

    @Override
    public Color getBackground() {
        Color newColor;
        Color discolor;
        if (Beans.isDesignTime()) {
            return super.getBackground();
        }
        Color encolor = this.getEnabledBackground();
        if (encolor == null) {
            encolor = UIManager.getLookAndFeelDefaults().getColor("TextField.background");
        }
        if ((discolor = this.getDisabledBackground()) == null) {
            discolor = UIManager.getLookAndFeelDefaults().getColor("TextField.disabledBackground");
        }
        Color preferredColor = null;
        boolean enabled = this.isEnabled();
        preferredColor = enabled ? (this.hasFocus() ? ((newColor = this.getFocusBackground()) == null ? encolor : newColor) : encolor) : discolor;
        return preferredColor == null ? super.getBackground() : preferredColor;
    }

    public void updateBackground() {
        Color discolor;
        Color encolor = this.getEnabledBackground();
        if (encolor == null) {
            encolor = UIManager.getLookAndFeelDefaults().getColor("TextField.background");
        }
        if ((discolor = this.getDisabledBackground()) == null) {
            discolor = UIManager.getLookAndFeelDefaults().getColor("TextField.disabledBackground");
        }
        Color newColor = this.getBackground();
        this.setBackground(newColor);
        this.repaint();
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        if (e.getID() == 1004) {
            this.updateBackground();
        } else if (e.getID() == 1005 && !e.isTemporary()) {
            this.updateBackground();
        }
        super.processFocusEvent(e);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.getParent() instanceof JViewport && this.getParent().getParent() instanceof JScrollPane) {
            JScrollPane jsp = (JScrollPane)this.getParent().getParent();
            jsp.getVerticalScrollBar().addAdjustmentListener(this.verticalAdjHandler);
        }
    }

    protected Object getFormattedText(Object item) {
        return item;
    }

    protected String getTemplate(Object item) {
        return null;
    }

    private String getSearchtext() {
        try {
            String str;
            int caretpos = this.getCaretPosition();
            StringBuffer sb = new StringBuffer();
            for (int i = caretpos - 1; i >= 0 && !(str = this.getDocument().getText(i, 1)).matches("\\s"); --i) {
                if (sb.length() == 0) {
                    sb.append(str);
                    continue;
                }
                sb.insert(0, str);
            }
            return sb.length() == 0 ? null : sb.toString();
        }
        catch (Throwable t) {
            return null;
        }
    }

    private void fireSearch() {
        if (!this.isEnabled() || !this.isEditable()) {
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("searchtext", this.getSearchtext());
        TimerManager.getInstance().schedule(new LookupTask(params), 300L);
    }

    private int getWhitespacePositionBefore(int pos) {
        try {
            for (int i = pos - 1; i >= 0; --i) {
                String str = this.getDocument().getText(i, 1);
                if (!str.matches("\\s")) continue;
                return i;
            }
            return -1;
        }
        catch (Throwable t) {
            return -1;
        }
    }

    private void fireSelectItem() {
        PopupItem pi = this.getPopup().getSelectedItem();
        if (pi == null) {
            return;
        }
        String template = this.getTemplate(pi.getUserObject());
        if (template == null) {
            template = "";
        }
        Document doc = this.getDocument();
        int doclen = doc.getLength();
        int curpos = this.getCaretPosition();
        int startpos = this.getWhitespacePositionBefore(curpos) + 1;
        try {
            doc.remove(startpos, curpos - startpos);
            doc.insertString(startpos, template, null);
            this.getPopup().setVisible(false);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void fireEscapeKeyEvent() {
        if (this.getPopup().isVisible() && this.getPopup().isShowing()) {
            this.getPopup().setVisible(false);
        }
    }

    protected void fireMoveDown() {
        if (this.getPopup().isVisible() && this.getPopup().isShowing()) {
            this.getPopup().moveDown();
        }
    }

    protected void fireMoveUp() {
        if (this.getPopup().isVisible() && this.getPopup().isShowing()) {
            this.getPopup().moveUp();
        }
    }

    protected List fetchList(Map params) {
        return null;
    }

    private TextEditorPopupSelector getPopup() {
        if (this.jpopup == null) {
            this.jpopup = new TextEditorPopupSelector(this);
            this.jpopup.add(new TextEditorPopupSelector.SelectionListener(){

                @Override
                public void onselect(PopupItem item) {
                    TextAreaImpl.this.fireSelectItem();
                }
            });
        }
        return this.jpopup;
    }

    private void showPopup() {
        try {
            Rectangle rect = this.modelToView(this.getCaretPosition());
            TextEditorPopupSelector popup = this.getPopup();
            popup.pack();
            popup.setSize(100, 20);
            popup.show(this, rect.x, rect.y + rect.height);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public boolean isAutoScrollDown() {
        return this.autoScrollDown;
    }

    public void setAutoScrollDown(boolean autoScrollDown) {
        this.autoScrollDown = autoScrollDown;
    }

    private class TextWriterHandler
    implements TextWriter.Handler {
        final TextAreaImpl root;

        private TextWriterHandler() {
            this.root = TextAreaImpl.this;
        }

        @Override
        public void write(String str) {
            this.root.append(str == null ? "null" : str);
            this.root.verticalAdjHandler.setAllowScrollDown(true);
            this.repaint();
        }

        @Override
        public void clear() {
            this.root.setText("");
            this.repaint();
        }

        private void repaint() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TextWriterHandler.this.root.repaint();
                }
            });
        }
    }

    private class VerticalAdjustmentListener
    implements AdjustmentListener {
        final TextAreaImpl root;
        boolean allowScrollDown;

        private VerticalAdjustmentListener() {
            this.root = TextAreaImpl.this;
        }

        public void setAllowScrollDown(boolean allowScrollDown) {
            this.allowScrollDown = allowScrollDown;
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            if (this.allowScrollDown || this.root.isAutoScrollDown()) {
                try {
                    e.getAdjustable().setValue(e.getAdjustable().getMaximum());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.allowScrollDown = false;
            }
        }
    }

    private class ResultDataLoader
    implements Runnable {
        final TextAreaImpl root;
        private List result;

        ResultDataLoader(List result) {
            this.root = TextAreaImpl.this;
            this.result = result;
        }

        @Override
        public void run() {
            TextEditorPopupSelector popup = this.root.getPopup();
            if (this.result == null || this.result.isEmpty()) {
                popup.setVisible(false);
                return;
            }
            ArrayList<PopupItem> items = new ArrayList<PopupItem>();
            for (int i = 0; i < popup.getRowSize(); ++i) {
                try {
                    Object o = this.result.get(i);
                    Object caption = this.root.getFormattedText(o);
                    items.add(new PopupItem(o, caption == null ? "" : caption.toString()));
                    continue;
                }
                catch (Throwable t) {
                    break;
                }
            }
            if (items.isEmpty()) {
                popup.setVisible(false);
                return;
            }
            popup.setData(items);
            this.root.showPopup();
        }
    }

    private class LookupTask
    implements Runnable {
        final TextAreaImpl root;
        private String searchtext;
        private Map params;

        LookupTask(Map params) {
            this.root = TextAreaImpl.this;
            this.params = params;
            this.searchtext = params == null ? null : (String)params.get("searchtext");
        }

        @Override
        public void run() {
            String str = this.root.getSearchtext() + "";
            if (!str.equals(this.searchtext + "")) {
                return;
            }
            List list = this.root.fetchList(this.params);
            EventQueue.invokeLater(new ResultDataLoader(list));
        }
    }

    private class KeyAdapterImpl
    extends KeyAdapter {
        final TextAreaImpl root;

        private KeyAdapterImpl() {
            this.root = TextAreaImpl.this;
        }

        @Override
        public void keyPressed(KeyEvent e) {
            switch (e.getKeyCode()) {
                case 9: {
                    if (!this.root.isExitOnTabKey() || !this.root.hasFocus() || e.isControlDown() || e.isAltDown()) break;
                    if (e.isShiftDown()) {
                        e.consume();
                        this.root.transferFocusBackward();
                        break;
                    }
                    e.consume();
                    this.root.transferFocus();
                    break;
                }
                case 27: {
                    break;
                }
                case 40: {
                    if (!this.root.getPopup().isVisible() || !this.root.getPopup().isShowing()) break;
                    e.consume();
                    this.root.getPopup().moveDown();
                    break;
                }
                case 38: {
                    if (!this.root.getPopup().isVisible() || !this.root.getPopup().isShowing()) break;
                    e.consume();
                    this.root.getPopup().moveUp();
                    break;
                }
                case 10: {
                    if (!this.root.getPopup().isVisible() || !this.root.getPopup().isShowing()) break;
                    e.consume();
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            KeyAdapterImpl.this.root.fireSelectItem();
                        }
                    });
                    break;
                }
                default: {
                    try {
                        boolean ctrlDown;
                        boolean bl = ctrlDown = (e.getModifiers() & 2) == 2;
                        if (ctrlDown && e.getKeyCode() == 32) {
                            e.consume();
                            return;
                        }
                        int pos = this.root.getCaretPosition() - 1;
                        if (pos < 0) {
                            return;
                        }
                        String str = e.getKeyChar() + "";
                        boolean whitespace = str.matches("\\s");
                        if (whitespace) {
                            this.root.getPopup().setVisible(false);
                            return;
                        }
                        if (!this.root.getPopup().isVisible() || !this.root.getPopup().isShowing() || whitespace) break;
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                KeyAdapterImpl.this.root.fireSearch();
                            }
                        });
                        break;
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
        }
    }

    private class DocumentProvider
    implements DocViewModel.Provider {
        final TextAreaImpl root;

        private DocumentProvider() {
            this.root = TextAreaImpl.this;
        }

        @Override
        public String getText() {
            return this.root.getText();
        }

        @Override
        public void setText(String text) {
            this.root.setText(text == null ? "" : text);
            this.repaint();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertText(String text) {
            if (text == null) {
                return;
            }
            int caretPos = this.root.getCaretPosition();
            try {
                int caretCharPos;
                int n = caretCharPos = text == null ? -1 : text.indexOf(124);
                if (caretCharPos >= 0) {
                    StringBuffer sb = new StringBuffer();
                    sb.append(text.substring(0, caretCharPos));
                    sb.append(' ');
                    sb.append(text.substring(caretCharPos + 1));
                    text = sb.toString();
                }
                this.root.textDocument.insertString(caretPos, text, null);
                if (caretCharPos >= 0) {
                    this.root.setCaretPosition(caretPos + caretCharPos);
                }
            }
            catch (BadLocationException ex) {
                System.out.println("[TextAreaImpl] failed to insert text at position " + caretPos + " caused by " + ex.getMessage());
            }
            finally {
                this.repaint();
            }
        }

        @Override
        public void appendText(String text) {
            this.root.append(text == null ? "null" : text);
            this.root.verticalAdjHandler.setAllowScrollDown(true);
            this.repaint();
        }

        @Override
        public void requestFocus() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DocumentProvider.this.root.requestFocus();
                    DocumentProvider.this.root.grabFocus();
                }
            });
        }

        @Override
        public void load() {
            this.root.load();
        }

        @Override
        public void refresh() {
            this.root.refresh();
        }

        private void repaint() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DocumentProvider.this.root.repaint();
                }
            });
        }

        @Override
        public int getWidth() {
            return 0;
        }

        @Override
        public int getHeight() {
            return 0;
        }
    }
}

