/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.control.webbrowser;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.net.URL;

public class BrowserUtil {
    private static final int BUFF_SIZE = 32768;

    public static URL getCache(String u, String context, String prefix) throws Exception {
        return BrowserUtil.getCache(new URL(u), context, prefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URL getCache(URL u, String context, String prefix) throws Exception {
        File f;
        File dir = new File(BrowserUtil.getCacheDir(context));
        if (!dir.exists()) {
            dir.mkdirs();
        }
        long lastModified = u.openConnection().getLastModified();
        String hash = (prefix + u.toExternalForm().hashCode()).replace("-", "_");
        File file = f = new File(dir, hash + "-" + lastModified);
        synchronized (file) {
            if (!f.exists()) {
                BrowserUtil.cache(f, u);
            } else {
                long modified = 0L;
                try {
                    modified = Long.parseLong(f.getName().split("-")[1]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (lastModified != modified) {
                    BrowserUtil.cache(f, u);
                }
            }
        }
        return f.toURL();
    }

    public static void clearCache(String context) {
        File dir = new File(BrowserUtil.getCacheDir(context));
        BrowserUtil.cleanUp(dir);
    }

    private static void cleanUp(File f) {
        if (f.isDirectory()) {
            for (File subFile : f.listFiles()) {
                BrowserUtil.cleanUp(subFile);
            }
        }
        f.delete();
    }

    private static String getCacheDir(String context) {
        return System.getProperty("user.dir") + File.separator + "web-cache" + File.separator + context + File.separator;
    }

    private static void cache(File target, URL source) throws Exception {
        FilterOutputStream bos = null;
        BufferedInputStream bis = null;
        try {
            bos = new BufferedOutputStream(new FileOutputStream(target), 32768);
            bis = new BufferedInputStream(source.openStream(), 32768);
            byte[] buffer = new byte[32768];
            int bytesRead = -1;
            while ((bytesRead = bis.read(buffer)) != -1) {
                ((BufferedOutputStream)bos).write(buffer, 0, bytesRead);
            }
            ((BufferedOutputStream)bos).flush();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                bos.close();
            }
            catch (Exception exception) {}
            try {
                bis.close();
            }
            catch (Exception exception) {}
        }
    }
}

