/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.framework;

import com.rameses.rcp.framework.ClientContext;
import com.rameses.util.URLStreamHandler;
import java.net.URL;
import java.net.URLStreamHandlerFactory;

public class CustomURLStreamHandlerFactory
implements URLStreamHandlerFactory {
    @Override
    public java.net.URLStreamHandler createURLStreamHandler(String protocol) {
        if (protocol != null && "classpath".equalsIgnoreCase(protocol)) {
            return new ClasspathURLStreamHandler();
        }
        return null;
    }

    private class ClasspathURLStreamHandler
    extends URLStreamHandler {
        CustomURLStreamHandlerFactory root;

        private ClasspathURLStreamHandler() {
            this.root = CustomURLStreamHandlerFactory.this;
        }

        public String getProtocol() {
            return "classpath";
        }

        public URL getResource(String spath) {
            ClassLoader loader = ClientContext.getCurrentContext().getClassLoader();
            URL result = loader.getResource(spath);
            if (result == null) {
                result = this.root.getClass().getClassLoader().getResource(spath);
            }
            return result;
        }
    }
}

