/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.impl;

import com.rameses.platform.interfaces.MainWindow;
import com.rameses.platform.interfaces.MainWindowListener;
import com.rameses.rcp.impl.ExtTabbedPane;
import com.rameses.rcp.impl.GlassPaneImpl;
import com.rameses.rcp.impl.PlatformImpl;
import com.rameses.rcp.impl.PlatformTabWindow;
import com.rameses.rcp.impl.TestPlatformContentPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;

class MainDialog
implements MainWindow {
    private JFrame dialog;
    private MainWindowListener listener;
    private Component toolbar;
    private Component statusbar;
    private ExtTabbedPane tabbedPane;
    private Component defaultContentPane;
    private GlassPaneImpl glassPane;
    private PlatformImpl platform;

    public MainDialog(PlatformImpl platform) {
        this.platform = platform;
        this.dialog = new JFrame();
        this.dialog.setTitle("Main Dialog");
        this.dialog.setDefaultCloseOperation(3);
        try {
            URL ico = this.getClass().getResource("/com/rameses/rcp/icons/os2-icon.png");
            this.dialog.setIconImage(new ImageIcon(ico).getImage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dialog.getContentPane().setLayout(new BorderLayout());
        this.glassPane = new GlassPaneImpl(platform, this);
        this.dialog.setGlassPane(this.glassPane);
        this.defaultContentPane = new TestPlatformContentPane();
        this.dialog.add(this.defaultContentPane, "Center");
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MainDialog.this.close();
            }
        });
    }

    public JFrame getComponent() {
        return this.dialog;
    }

    @Override
    public void show() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainDialog.this.showImpl();
            }
        });
    }

    private void showImpl() {
        this.dialog.pack();
        KeyStroke ks = KeyStroke.getKeyStroke("ctrl shift I");
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainDialog.this.showInfo(e);
            }
        };
        JRootPane rootPane = this.dialog.getRootPane();
        rootPane.registerKeyboardAction(al, ks, 2);
        this.dialog.setVisible(true);
    }

    private void showInfo(ActionEvent e) {
        if (this.tabbedPane != null) {
            this.tabbedPane.showInfo();
        }
    }

    @Override
    public void close() {
        if (this.listener != null) {
            try {
                if (!this.listener.onClose()) {
                    return;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.dialog.dispose();
    }

    @Override
    public void setTitle(String title) {
        this.dialog.setTitle(title);
    }

    @Override
    public void setListener(MainWindowListener listener) {
        this.listener = listener;
    }

    @Override
    public void setComponent(JComponent comp, String constraint) {
        if (comp == null || constraint == null) {
            return;
        }
        if (constraint.equals("menubar")) {
            this.dialog.setJMenuBar((JMenuBar)comp);
        } else if (constraint.equals("toolbar")) {
            if (comp instanceof JToolBar) {
                ((JToolBar)comp).setFloatable(false);
            }
            if (this.toolbar != null) {
                this.dialog.remove(this.toolbar);
            }
            this.toolbar = comp;
            comp.setBorder(new ToolbarBorder());
            this.dialog.add(comp, "North", 1);
        } else if (constraint.equals("content")) {
            if (comp instanceof PlatformTabWindow) {
                PlatformTabWindow tab = (PlatformTabWindow)comp;
                if (this.tabbedPane == null) {
                    if (this.defaultContentPane != null) {
                        this.dialog.remove(this.defaultContentPane);
                    }
                    this.tabbedPane = new ExtTabbedPane();
                    this.dialog.add((Component)this.tabbedPane, "Center");
                }
                this.tabbedPane.add(tab);
            }
        } else if (constraint.endsWith("statusbar")) {
            if (this.statusbar != null) {
                this.dialog.remove(this.statusbar);
            }
            this.statusbar = comp;
            comp.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
            this.dialog.add((Component)comp, "South");
        }
        SwingUtilities.updateComponentTreeUI(this.dialog.getContentPane());
    }

    void showGlassPane() {
        this.glassPane.setVisible(true);
        SwingUtilities.updateComponentTreeUI(this.glassPane);
    }

    void hideGlassPane() {
        this.glassPane.setVisible(false);
        this.glassPane.removeAll();
    }

    Container getGlassPane() {
        return this.glassPane;
    }

    void requestFocus() {
        if (this.tabbedPane != null) {
            Component comp = this.tabbedPane.getSelectedComponent();
            if (comp != null) {
                this.tabbedPane.setFocusable(true);
                this.tabbedPane.requestFocus();
                this.tabbedPane.transferFocus();
            }
        } else {
            this.dialog.requestFocus();
            this.dialog.transferFocus();
        }
    }

    private class StatusbarBorder
    extends AbstractBorder {
        private StatusbarBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Graphics g2 = g.create();
            g2.setColor(UIManager.getColor("controlShadow"));
            g2.drawLine(x, y, width - 1, y);
            g2.setColor(UIManager.getColor("controlHighlight"));
            g2.drawLine(x, y + 1, width - 1, y + 1);
            g2.dispose();
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(4, 1, 1, 1);
        }
    }

    private class ToolbarBorder
    extends AbstractBorder {
        private ToolbarBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Graphics g2 = g.create();
            g2.setColor(UIManager.getColor("controlShadow"));
            g2.drawLine(x, height - 1, width - 1, height - 1);
            g2.setColor(UIManager.getColor("controlHighlight"));
            g2.drawLine(x, height - 2, width - 1, height - 2);
            g2.dispose();
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(1, 1, 4, 1);
        }
    }
}

