/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.impl;

import com.rameses.platform.interfaces.SubWindow;
import com.rameses.platform.interfaces.SubWindowListener;
import com.rameses.platform.interfaces.ViewContext;
import com.rameses.rcp.impl.PlatformImpl;
import java.awt.Container;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class PopupDialog
extends JDialog
implements SubWindow,
WindowListener {
    private ViewContext viewContext;
    private PlatformImpl platformImpl;
    private boolean canClose = true;
    private String id;
    private JComponent source;

    public PopupDialog() {
        this.init();
    }

    public PopupDialog(JFrame parent) {
        super(parent);
        this.init();
    }

    public PopupDialog(JDialog parent) {
        super(parent);
        this.init();
    }

    private void init() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
    }

    public JComponent getSource() {
        return this.source;
    }

    public void setSource(JComponent source) {
        this.source = source;
    }

    @Override
    public void setContentPane(Container contentPane) {
        super.setContentPane(contentPane);
        if (contentPane instanceof ViewContext) {
            this.viewContext = (ViewContext)((Object)contentPane);
        }
    }

    public boolean isCanClose() {
        return this.canClose;
    }

    public void setCanClose(boolean canClose) {
        this.canClose = canClose;
    }

    public PlatformImpl getPlatformImpl() {
        return this.platformImpl;
    }

    public void setPlatformImpl(PlatformImpl platformImpl) {
        this.platformImpl = platformImpl;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void setListener(SubWindowListener listener) {
    }

    @Override
    public String getName() {
        return this.getId();
    }

    @Override
    public void closeWindow() {
        if (!this.canClose) {
            return;
        }
        if (this.viewContext != null && !this.viewContext.close()) {
            return;
        }
        super.dispose();
        this.platformImpl.getWindows().remove(this.id);
        this.getContentPane().firePropertyChange("Window.close", 0L, 1L);
        JComponent source = this.getSource();
        if (source != null) {
            source.firePropertyChange("Window.close", false, true);
        }
    }

    @Override
    public void update(Map windowAttributes) {
        Object oid;
        if (windowAttributes == null || windowAttributes.isEmpty()) {
            return;
        }
        Object otitle = windowAttributes.remove("title");
        if (otitle != null) {
            this.setTitle(otitle.toString());
        }
        if ((oid = windowAttributes.remove("id")) != null) {
            String newId = oid.toString();
            String oldId = this.getName();
            if (newId != null && oldId != null && !newId.equals(oldId)) {
                this.platformImpl.getWindows().remove(oldId);
                this.setId(newId);
                this.platformImpl.getWindows().put(newId, this);
            }
        }
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.closeWindow();
    }

    @Override
    public void windowOpened(WindowEvent e) {
        if (this.viewContext != null) {
            this.viewContext.display();
            this.viewContext.setSubWindow(this);
        }
    }
}

