/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.support;

import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.support.ImageIconSupport;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.KeyStroke;

public class ActionButtonSupport {
    private static ActionButtonSupport instance = null;
    private static ActionThemeConfig actionThemeConfig;

    public static ActionButtonSupport getInstance() {
        if (instance == null) {
            instance = new ActionButtonSupport();
        }
        return instance;
    }

    public void loadDefaults(JButton button, String actionName, String caption, ActionListener listener) {
        Properties props;
        String resname;
        if (caption != null && caption.length() > 0) {
            resname = "button." + caption;
            props = this.getConfig().find(resname);
            if (!props.isEmpty()) {
                this.applyDefaults(button, resname, props, listener);
                return;
            }
        }
        if (actionName != null && actionName.length() > 0) {
            resname = "button." + actionName;
            props = this.getConfig().find(resname);
            if (!props.isEmpty()) {
                this.applyDefaults(button, resname, props, listener);
            }
        }
    }

    private void applyDefaults(JButton button, String resname, Properties props, ActionListener listener) {
        String accelerator;
        String mnemonic;
        String sicon;
        String caption = props.getProperty((resname = resname.toLowerCase()) + ".caption");
        if (caption != null && caption.trim().length() > 0) {
            button.setText(caption);
        }
        if ((sicon = props.getProperty(resname + ".icon")) != null && sicon.trim().length() > 0) {
            button.setIcon(ImageIconSupport.getInstance().getIcon(sicon));
        }
        if ((mnemonic = props.getProperty(resname + ".mnemonic")) != null && mnemonic.trim().length() > 0) {
            button.setMnemonic(mnemonic.trim().charAt(0));
        }
        if ((accelerator = props.getProperty(resname + ".accelerator")) != null && accelerator.trim().length() > 0 && listener != null) {
            try {
                KeyStroke ks = KeyStroke.getKeyStroke(accelerator.trim());
                InputMap inputMap = button.getInputMap(2);
                inputMap.remove(ks);
                inputMap.put(ks, "fireActionPerformed");
                button.getActionMap().remove("fireActionPerformed");
                button.getActionMap().put("fireActionPerformed", new ActionProxy(listener));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private synchronized ActionThemeConfig getConfig() {
        if (actionThemeConfig == null) {
            actionThemeConfig = new ActionThemeConfig();
            actionThemeConfig.parse();
        }
        return actionThemeConfig;
    }

    private class ActionProxy
    extends AbstractAction {
        private ActionListener listener;

        ActionProxy(ActionListener listener) {
            this.listener = listener;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.listener != null) {
                this.listener.actionPerformed(e);
            }
        }
    }

    private class ActionThemeConfig {
        private Properties properties = new Properties();

        private ActionThemeConfig() {
        }

        void parse() {
            try {
                Enumeration en = this.getResources("META-INF/action-theme.properties");
                while (en.hasMoreElements()) {
                    try {
                        URL url = (URL)en.nextElement();
                        this.properties.load(url.openStream());
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        Properties find(String name) {
            String lname = name.toLowerCase();
            Properties results = new Properties();
            Set<Map.Entry<Object, Object>> entries = this.properties.entrySet();
            for (Map.Entry<Object, Object> o : entries) {
                Map.Entry<Object, Object> me = o;
                String key = me.getKey().toString().toLowerCase();
                if (!key.startsWith(lname)) continue;
                results.put(key, me.getValue());
            }
            return results;
        }

        private Enumeration getResources(String name) throws IOException {
            ClassLoader cloader = ClientContext.getCurrentContext().getClassLoader();
            if (cloader == null) {
                return ClassLoader.getSystemResources(name);
            }
            return cloader.getResources(name);
        }
    }
}

