/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.support;

import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class ComponentSupport {
    private Map<String, int[]> alignment_options = new HashMap<String, int[]>();

    public ComponentSupport() {
        this.alignment_options.put("CENTER", new int[]{0, 0});
        this.alignment_options.put("LEFT", new int[]{0, 2});
        this.alignment_options.put("RIGHT", new int[]{0, 4});
        this.alignment_options.put("TOP", new int[]{1, 2});
        this.alignment_options.put("TOP_LEFT", new int[]{1, 2});
        this.alignment_options.put("TOP_CENTER", new int[]{1, 0});
        this.alignment_options.put("TOP_RIGHT", new int[]{1, 4});
        this.alignment_options.put("BOTTOM", new int[]{3, 2});
        this.alignment_options.put("BOTTOM_LEFT", new int[]{3, 2});
        this.alignment_options.put("BOTTOM_CENTER", new int[]{3, 0});
        this.alignment_options.put("BOTTOM_RIGHT", new int[]{3, 4});
    }

    public void alignText(JComponent comp, String textAlignment) {
        if (comp == null || textAlignment == null) {
            return;
        }
        String str_align = textAlignment.toUpperCase();
        int[] values = this.alignment_options.get(str_align);
        if (values == null) {
            return;
        }
        if (comp instanceof AbstractButton) {
            AbstractButton jc = (AbstractButton)comp;
            jc.setVerticalAlignment(values[0]);
            jc.setHorizontalAlignment(values[1]);
        } else if (comp instanceof JLabel) {
            JLabel jc = (JLabel)comp;
            jc.setVerticalAlignment(values[0]);
            jc.setHorizontalAlignment(values[1]);
        } else if (comp instanceof JTextField) {
            JTextField jc = (JTextField)comp;
            jc.setHorizontalAlignment(values[1]);
        } else if (comp instanceof JCheckBox) {
            JCheckBox jc = (JCheckBox)comp;
            if (str_align.startsWith("TOP") || str_align.startsWith("BOTTOM")) {
                jc.setVerticalAlignment(values[0]);
                jc.setVerticalTextPosition(values[0]);
            }
            jc.setHorizontalAlignment(values[1]);
        }
    }

    public void alignTextPosition(JComponent comp, String textPosition) {
        if (comp == null) {
            return;
        }
        int[] values = this.alignment_options.get(textPosition.toUpperCase());
        if (values == null) {
            return;
        }
        if (comp instanceof AbstractButton) {
            AbstractButton jc = (AbstractButton)comp;
            jc.setVerticalTextPosition(values[0]);
            jc.setHorizontalTextPosition(values[1]);
        } else if (comp instanceof JLabel) {
            JLabel jc = (JLabel)comp;
            jc.setVerticalTextPosition(values[0]);
            jc.setHorizontalTextPosition(values[1]);
        }
    }

    public Border createEmptyBorder(Insets margin) {
        if (margin == null) {
            margin = new Insets(0, 0, 0, 0);
        }
        return BorderFactory.createEmptyBorder(margin.top, margin.left, margin.bottom, margin.right);
    }

    public void setEmptyBorder(JComponent comp, Insets margin) {
        if (comp != null) {
            comp.setBorder(this.createEmptyBorder(margin));
        }
    }
}

