/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.support;

import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.util.ControlSupport;
import java.awt.Image;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;

public class ImageIconSupport {
    private static ImageIconSupport instance;
    private Map<String, Image> cache = new HashMap<String, Image>();

    public static ImageIconSupport getInstance() {
        if (instance == null) {
            instance = new ImageIconSupport();
        }
        return instance;
    }

    public static Resizer getResizer() {
        return new Resizer();
    }

    private ImageIconSupport() {
    }

    public synchronized void removeIcon(String path) {
        if (path == null || path.length() == 0) {
            return;
        }
        this.cache.remove(path);
    }

    public synchronized ImageIcon getIcon(String path) {
        if (path == null || path.length() == 0) {
            return null;
        }
        Image image = this.cache.get(path);
        if (image == null) {
            try {
                if (path.toLowerCase().indexOf("://") > 0) {
                    URL url = ClientContext.getCurrentContext().getResource(path);
                    if (url == null) {
                        url = new URL(path);
                    }
                    return new ImageIcon(url);
                }
                byte[] bytes = ControlSupport.getByteFromResource(path);
                if (bytes == null) {
                    URL url = this.getResource(path);
                    if (url == null) {
                        return null;
                    }
                    ImageIcon icon = new ImageIcon(url);
                    this.cache.put(path, icon.getImage());
                    return icon;
                }
                ImageIcon icon = new ImageIcon(bytes);
                this.cache.put(path, icon.getImage());
                return icon;
            }
            catch (Throwable ex) {
                return null;
            }
        }
        return new ImageIcon(image);
    }

    private URL getResource(String path) {
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            URL url = classLoader.getResource(path);
            if (url == null) {
                return classLoader.getSystemClassLoader().getResource(path);
            }
            return url;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static class Resizer {
        public static final int SCALE_AREA_AVERAGING = 16;
        public static final int SCALE_DEFAULT = 1;
        public static final int SCALE_FAST = 2;
        public static final int SCALE_REPLICATE = 8;
        public static final int SCALE_SMOOTH = 4;

        private Resizer() {
        }

        public Image resizeWidth(Image image, int size) {
            return this.resizeWidth(image, size, 2);
        }

        public Image resizeWidth(Image image, int size, int scaleType) {
            return this.resize(image, size, -1, scaleType);
        }

        public Image resizeHeight(Image image, int size) {
            return this.resizeHeight(image, size, 2);
        }

        public Image resizeHeight(Image image, int size, int scaleType) {
            return this.resize(image, -1, size, scaleType);
        }

        public Image resize(Image image, int width, int height) {
            return this.resize(image, width, height, 2);
        }

        public Image resize(Image image, int width, int height, int scaleType) {
            if (image == null) {
                return null;
            }
            if (width < 0 && height < 0) {
                return image;
            }
            if (width > 0 && height < 0) {
                return image.getScaledInstance(width, -1, scaleType);
            }
            if (width < 0 && height > 0) {
                return image.getScaledInstance(-1, height, scaleType);
            }
            return image.getScaledInstance(width, height, scaleType);
        }
    }
}

