/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.support;

import com.rameses.rcp.common.StyleRule;
import com.rameses.rcp.framework.ClientContext;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;

public class StyleRuleParser {
    /*
     * Enabled aggressive block sorting
     */
    public void parse(InputStream is, ParseHandler handler) throws Exception {
        boolean startStyle = false;
        boolean startExpr = false;
        String pattern = null;
        Object expr = null;
        String propertyName = null;
        StringBuffer buffer = new StringBuffer();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StreamTokenizer tokenizer = new StreamTokenizer(reader);
        tokenizer.ordinaryChar(46);
        tokenizer.ordinaryChar(47);
        tokenizer.ordinaryChars(48, 57);
        tokenizer.slashSlashComments(true);
        tokenizer.slashStarComments(true);
        int ttype = 0;
        while (tokenizer.nextToken() != -1) {
            ttype = tokenizer.ttype;
            if (ttype == 34) {
                if (!startStyle) {
                    startStyle = true;
                    buffer.delete(0, buffer.length());
                    handler.startStyle();
                }
                if (startExpr) {
                    buffer.append("'" + tokenizer.sval + "'");
                    continue;
                }
                buffer.append(tokenizer.sval);
                continue;
            }
            if (ttype == 91) {
                pattern = buffer.toString();
                buffer.delete(0, buffer.length());
                startExpr = true;
                continue;
            }
            if (ttype == 93) {
                handler.setStyle(pattern, buffer.toString());
                buffer.delete(0, buffer.length());
                startExpr = false;
                continue;
            }
            if (ttype == 123) {
                handler.startProperties();
                continue;
            }
            if (ttype == 125) {
                handler.endProperties();
                handler.endStyle();
                continue;
            }
            if (ttype == 58) {
                propertyName = buffer.toString();
                buffer.delete(0, buffer.length());
                continue;
            }
            if (ttype == 59) {
                handler.addProperty(propertyName, buffer.toString());
                propertyName = null;
                buffer.delete(0, buffer.length());
                continue;
            }
            if (ttype == 39) {
                if (startExpr) {
                    buffer.append("'" + tokenizer.sval + "'");
                    continue;
                }
                buffer.append(tokenizer.sval);
                continue;
            }
            if (ttype == -2) {
                buffer.append(tokenizer.nval);
                continue;
            }
            if (ttype == -3) {
                buffer.append(tokenizer.sval);
                continue;
            }
            buffer.append((char)ttype);
        }
        return;
    }

    public static class DefaultPropertyResolver
    implements PropertyResolver {
        @Override
        public String resolve(String name) {
            if ("background-color".equals(name)) {
                return "background";
            }
            if ("forecolor".equals(name)) {
                return "foreground";
            }
            return null;
        }
    }

    public static class DataTypeResolver
    implements ValueResolver {
        @Override
        public Object resolve(String name, String value) {
            if ("true".equals(value)) {
                return true;
            }
            if ("false".equals(value)) {
                return false;
            }
            if ("icon".equals(name)) {
                ClassLoader loader = ClientContext.getCurrentContext().getClassLoader();
                URL u = loader.getResource(value);
                return new ImageIcon(u);
            }
            return null;
        }
    }

    public static class ColorResolver
    implements ValueResolver {
        @Override
        public Object resolve(String name, String value) {
            String exp;
            Matcher m;
            if (value.startsWith("#")) {
                return Color.decode(value);
            }
            if (value.startsWith("rgb") && (m = Pattern.compile(exp = "rgb\\((\\d+),(\\d+),(\\d+)\\)").matcher(value.replace(" ", ""))).matches()) {
                int r = Integer.parseInt(m.group(1));
                int g = Integer.parseInt(m.group(2));
                int b = Integer.parseInt(m.group(3));
                return new Color(r, g, b);
            }
            return null;
        }
    }

    public static class DefaultParseHandler
    implements ParseHandler {
        private StyleRule currentStyle;
        private List<StyleRule> list = new ArrayList<StyleRule>();
        private List<ValueResolver> vResolvers = new ArrayList<ValueResolver>();
        private List<PropertyResolver> pResolvers = new ArrayList<PropertyResolver>();

        public DefaultParseHandler() {
            this.addValueResolver(new ColorResolver());
            this.addValueResolver(new DataTypeResolver());
            this.addPropertyResolver(new DefaultPropertyResolver());
        }

        @Override
        public void startStyle() {
        }

        @Override
        public void startProperties() {
        }

        @Override
        public void endProperties() {
        }

        @Override
        public void endStyle() {
        }

        @Override
        public void setStyle(String pattern, String expr) {
            if (!expr.startsWith("#{")) {
                expr = "#{" + expr + "}";
            }
            this.currentStyle = new StyleRule(pattern, expr);
            this.list.add(this.currentStyle);
        }

        @Override
        public void addProperty(String name, String property) {
            String xname = this.resolveProperty(name);
            Object value = this.resolveValue(name, property);
            this.currentStyle.add(xname, value);
        }

        private Object resolveValue(String name, String value) {
            if (value == null) {
                return null;
            }
            if (value.toLowerCase().equals("null")) {
                return null;
            }
            String o = value;
            for (ValueResolver vr : this.vResolvers) {
                Object x = vr.resolve(name, value);
                if (x == null) continue;
                return x;
            }
            return o;
        }

        private String resolveProperty(String name) {
            if (name == null) {
                return null;
            }
            String propName = name;
            for (PropertyResolver res : this.pResolvers) {
                String s = res.resolve(name);
                if (s == null) continue;
                return s;
            }
            return propName;
        }

        public List<StyleRule> getList() {
            return this.list;
        }

        public void addValueResolver(ValueResolver res) {
            if (!this.vResolvers.contains(res)) {
                this.vResolvers.add(res);
            }
        }

        public void addPropertyResolver(PropertyResolver res) {
            if (!this.pResolvers.contains(res)) {
                this.pResolvers.add(res);
            }
        }
    }

    public static interface PropertyResolver {
        public String resolve(String var1);
    }

    public static interface ValueResolver {
        public Object resolve(String var1, String var2);
    }

    public static interface ParseHandler {
        public void startStyle();

        public void setStyle(String var1, String var2);

        public void startProperties();

        public void addProperty(String var1, String var2);

        public void endProperties();

        public void endStyle();
    }
}

