/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.ui;

import com.rameses.rcp.constant.TrimSpaceOption;
import com.rameses.rcp.ui.ControlProperty;
import com.rameses.rcp.ui.UIControlPanel;
import com.rameses.rcp.ui.UIInput;
import com.rameses.rcp.ui.Validatable;
import com.rameses.rcp.util.ActionMessage;
import com.rameses.util.ValueUtil;
import java.util.Map;

public abstract class UIControlInput
extends UIControlPanel
implements UIInput,
Validatable {
    private boolean nullWhenEmpty;
    private boolean readonly;
    private boolean requestFocus;
    private boolean immediate;
    private boolean required;
    private ActionMessage actionMessage;
    private TrimSpaceOption trimSpaceOption;

    @Override
    protected void initComponent() {
        super.initComponent();
        this.trimSpaceOption = TrimSpaceOption.NONE;
    }

    @Override
    public abstract void load();

    @Override
    public abstract void refresh();

    @Override
    public abstract void setValue(Object var1);

    @Override
    public boolean isNullWhenEmpty() {
        return this.nullWhenEmpty;
    }

    public void setNullWhenEmpty(boolean nullWhenEmpty) {
        this.nullWhenEmpty = nullWhenEmpty;
    }

    @Override
    public boolean isReadonly() {
        return this.readonly;
    }

    @Override
    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    public boolean isRequestFocus() {
        return this.requestFocus;
    }

    @Override
    public void setRequestFocus(boolean requestFocus) {
        this.requestFocus = requestFocus;
    }

    @Override
    public boolean isImmediate() {
        return this.immediate;
    }

    public void setImmediate(boolean immediate) {
        this.immediate = immediate;
    }

    public TrimSpaceOption getTrimSpaceOption() {
        return this.trimSpaceOption;
    }

    public void setTrimSpaceOption(TrimSpaceOption option) {
        this.trimSpaceOption = option;
    }

    @Override
    protected void loadComponentInfo(Map info) {
        super.loadComponentInfo(info);
        info.put("immediate", this.isImmediate());
        info.put("nullWhenEmpty", this.isNullWhenEmpty());
        info.put("readonly", this.isReadonly());
        info.put("trimSpaceOption", this.getTrimSpaceOption());
        info.put("caption", this.getCaption());
        info.put("required", this.isRequired());
    }

    @Override
    public String getCaption() {
        return super.getCaption();
    }

    @Override
    public void setCaption(String caption) {
        super.setCaption(caption);
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public void setRequired(boolean required) {
        this.required = required;
    }

    @Override
    public ActionMessage getActionMessage() {
        if (this.actionMessage == null) {
            this.actionMessage = new ActionMessage();
        }
        return this.actionMessage;
    }

    @Override
    public void validateInput() {
        ActionMessage am = this.getActionMessage();
        am.clearMessages();
        ControlProperty cp = this.getControlProperty();
        cp.setErrorMessage(null);
        if (this.isRequired() && ValueUtil.isEmpty((Object)this.getValue())) {
            am.addMessage("", "{0} is required", new Object[]{this.getCaption()});
            cp.setErrorMessage(am.toString());
        }
    }
}

