/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.util;

import com.rameses.platform.interfaces.Platform;
import com.rameses.rcp.common.LookupOpenerSupport;
import com.rameses.rcp.common.Opener;
import com.rameses.rcp.common.WindowUtil;
import com.rameses.rcp.framework.UIController;
import com.rameses.rcp.framework.UIControllerContext;
import com.rameses.rcp.framework.UIControllerPanel;
import com.rameses.rcp.impl.ClientContextImpl;
import com.rameses.rcp.util.ControlSupport;
import java.util.HashMap;
import java.util.Map;

public class OpenerUtil {
    public static void show(Opener opener) {
        new OpenerUtil().showImpl(opener, null);
    }

    public static void show(Opener opener, Map windowOptions) {
        new OpenerUtil().showImpl(opener, windowOptions);
    }

    public static void show(String openerName, Map params) {
        new OpenerUtil().showImpl(openerName, params, null);
    }

    public static void show(String openerName, Map params, Map windowOptions) {
        new OpenerUtil().showImpl(openerName, params, windowOptions);
    }

    private OpenerUtil() {
    }

    private void showImpl(String openerName, Map params, Map windowOptions) {
        if (params == null) {
            params = new HashMap();
        }
        Opener opener = LookupOpenerSupport.lookupOpener(openerName + "", params);
        this.showImpl(opener, windowOptions);
    }

    private void showImpl(Opener opener, Map windowOptions) {
        String target;
        if (windowOptions == null) {
            windowOptions = opener.getProperties();
        }
        HashMap props = new HashMap();
        Map opmap = opener.getProperties();
        if (opmap != null) {
            props.putAll(opmap);
            props.putAll(WindowUtil.extractWindowAttrs(opmap));
        }
        props.putAll(WindowUtil.extractWindowAttrs(windowOptions));
        if (this.hasValue(props, "title")) {
            opener.setCaption(this.getString(props, "title"));
        }
        if ((target = (opener = ControlSupport.initOpener(opener, null)).getTarget() + "").matches("process|_process")) {
            return;
        }
        String sid = opener.getController().getId();
        Platform platform = ClientContextImpl.getCurrentContext().getPlatform();
        if (platform.isWindowExists(sid)) {
            platform.activateWindow(sid);
            return;
        }
        UIController uic = opener.getController();
        String permission = opener.getPermission();
        String role = opener.getRole();
        String domain = opener.getDomain();
        if (permission != null && permission.length() > 0 && !ControlSupport.isPermitted(domain, role, permission = uic.getName() + "." + permission)) {
            String msg = "You don't have permission to perform this transaction.";
            platform.showError(null, new IllegalStateException(msg));
            return;
        }
        UIControllerContext uicx = new UIControllerContext(uic);
        String outcome = opener.getOutcome();
        if (outcome != null && outcome.length() > 0) {
            uicx.setCurrentView(outcome);
        }
        UIControllerPanel uicp = new UIControllerPanel(uicx);
        HashMap map = new HashMap();
        map.putAll(props);
        map.put("id", sid);
        if (!this.hasValue(map, "title")) {
            map.put("title", uicx.getTitle());
        }
        uicp.putClientProperty("Opener.properties", map);
        uicp.buildFormAttrs(map);
        if ("popup".equals(target)) {
            platform.showPopup(null, uicp, map);
        } else {
            platform.showWindow(null, uicp, map);
        }
    }

    private String getString(Map map, String name) {
        Object value = map == null ? null : (Object)map.get(name);
        return value == null ? null : value.toString();
    }

    private boolean hasValue(Map map, String name) {
        Object value;
        Object object = value = map == null ? null : (Object)map.get(name);
        if (value == null) {
            return false;
        }
        return value.toString().length() != 0;
    }
}

