/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class Title
extends JPanel {
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private JLabel label;
    private Color background1;
    private Color background2;

    public Title() {
        this.initComponent();
    }

    private void initComponent() {
        this.background1 = Color.decode("#D3E0F7");
        this.background2 = new Color(158, 184, 221);
        this.label = new JLabel("Title");
        super.setLayout(new CustomLayout());
        this.add(this.label);
        this.label.setBorder(BorderFactory.createEmptyBorder(2, 7, 2, 5));
        this.setForeground(Color.decode("#022D7B"));
        Font f = UIManager.getFont("Label.font");
        this.setFont(new Font(f.getFontName(), 1, 11));
        try {
            Object o = UIManager.get("Title.font");
            if (o != null && o instanceof Font) {
                this.setFont((Font)o);
            }
            if ((o = UIManager.get("Title.background1")) != null && o instanceof Color) {
                this.setBackground1((Color)o);
            }
            if ((o = UIManager.get("Title.background2")) != null && o instanceof Color) {
                this.setBackground2((Color)o);
            }
            if ((o = UIManager.get("Title.foreground")) != null && o instanceof Color) {
                this.setForeground((Color)o);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setLayout(LayoutManager mgr) {
    }

    public Color getBackground1() {
        return this.background1;
    }

    public void setBackground1(Color color1) {
        this.background1 = color1;
    }

    public Color getBackground2() {
        return this.background2;
    }

    public void setBackground2(Color color2) {
        this.background2 = color2;
    }

    public String getText() {
        return this.label.getText();
    }

    public void setText(String text) {
        this.label.setText(text != null ? text : "");
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.label != null) {
            this.label.setFont(font);
        }
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.label != null) {
            this.label.setForeground(fg);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Insets ins = this.getInsets();
        int w = this.getWidth();
        int h = this.getHeight();
        Color c1 = this.getBackground1();
        Color c2 = this.getBackground2();
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setPaint(new GradientPaint(0.0f, 0.0f, c1, 0.0f, h, c2, true));
        g2.fillRect(0, 0, w, h);
    }

    private class CustomLayout
    implements LayoutManager {
        private CustomLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets margin = parent.getInsets();
                int x = margin.left;
                int y = margin.top;
                int w = parent.getWidth() - (margin.left + margin.right);
                int h = parent.getHeight() - (margin.top + margin.bottom);
                if (Title.this.label != null && Title.this.label.isVisible()) {
                    Dimension dim = Title.this.label.getPreferredSize();
                    Title.this.label.setBounds(x, y, w, h);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Dimension getLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                int width = 0;
                int height = 0;
                if (Title.this.label != null && Title.this.label.isVisible()) {
                    Dimension dim = Title.this.label.getPreferredSize();
                    width = dim.width;
                    height = dim.height;
                }
                Insets margin = parent.getInsets();
                return new Dimension(width += margin.left + margin.right, height += margin.top + margin.bottom);
            }
        }
    }
}

