/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.util;

import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.ui.UIControl;
import com.rameses.rcp.util.UIControlUtil;
import java.awt.Component;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class UIExpression {
    public boolean isEmpty(String expr) {
        return expr == null || expr.trim().length() == 0;
    }

    public Object getBindingBean(UIControl uic) {
        if (uic == null) {
            return null;
        }
        Binding binding = uic.getBinding();
        return binding == null ? null : binding.getBean();
    }

    public void disableWhen(UIControl uic, String expr) {
        if (uic == null || this.isEmpty(expr)) {
            return;
        }
        try {
            Object bean = this.getBindingBean(uic);
            if (bean == null) {
                return;
            }
            if (uic instanceof Component) {
                Component comp = (Component)((Object)uic);
                boolean b = UIControlUtil.evaluateExprBoolean(bean, expr);
                comp.setEnabled(!b);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void enableWhen(UIControl uic, String expr) {
        if (uic == null || this.isEmpty(expr)) {
            return;
        }
        try {
            Object bean = this.getBindingBean(uic);
            if (bean == null) {
                return;
            }
            if (uic instanceof Component) {
                Component comp = (Component)((Object)uic);
                boolean b = UIControlUtil.evaluateExprBoolean(bean, expr);
                comp.setEnabled(b);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void visibleWhen(UIControl uic, String expr) {
        if (uic == null || this.isEmpty(expr)) {
            return;
        }
        try {
            Object bean = this.getBindingBean(uic);
            if (bean == null) {
                return;
            }
            if (uic instanceof Component) {
                Component comp = (Component)((Object)uic);
                boolean b = UIControlUtil.evaluateExprBoolean(bean, expr);
                comp.setVisible(b);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public Object translateExpr(UIControl uic, String expr, String itemName, Object itemObj) {
        if (uic == null || this.isEmpty(expr)) {
            return null;
        }
        Object bean = this.getBindingBean(uic);
        Object exprBean = this.createExpressionBean(bean, itemName, itemObj);
        return UIControlUtil.evaluateExpr(exprBean, expr);
    }

    public Object createExpressionBean(Object bean, String itemName, Object itemObj) {
        ExprBean eb = new ExprBean(bean);
        eb.setItem(itemName, itemObj);
        return eb.createProxy();
    }

    public class ExprBean
    extends HashMap
    implements InvocationHandler {
        private Object root;
        private String _toString;

        public ExprBean(Object root) {
            this.root = root;
            this._toString = "$ExprBeanSupport@" + new UID();
        }

        public void setItem(String name, Object item) {
            if (name == null) {
                name = "item";
            }
            super.put(name, item);
        }

        @Override
        public Object get(Object key) {
            Object[] params;
            if (key == null) {
                return null;
            }
            if (this.containsKey(key)) {
                return super.get(key);
            }
            String skey = key.toString();
            String propName = "get" + skey.substring(0, 1).toUpperCase() + skey.substring(1);
            Method method = this.findGetterMethod(this.root, propName, params = new Object[0]);
            if (method == null) {
                return null;
            }
            try {
                return method.invoke(this.root, params);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
            return null;
        }

        @Override
        public Object put(Object key, Object value) {
            return null;
        }

        public Object createProxy() {
            ClassLoader classLoader = this.root.getClass().getClassLoader();
            Class<?>[] interfaces = this.root.getClass().getInterfaces();
            ArrayList classes = new ArrayList();
            for (int i = 0; i < interfaces.length; ++i) {
                classes.add(interfaces[i]);
            }
            if (!(this.root instanceof Map)) {
                classes.add(Map.class);
            }
            return Proxy.newProxyInstance(classLoader, classes.toArray(new Class[0]), (InvocationHandler)this);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("toString".equals(method.getName())) {
                return this._toString;
            }
            if ("hashCode".equals(method.getName())) {
                return proxy.hashCode();
            }
            try {
                return method.invoke((Object)this, args);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            return null;
        }

        private Method findGetterMethod(Object bean, String name, Object[] args) {
            if (bean == null || name == null) {
                return null;
            }
            if (args == null) {
                args = new Object[]{};
            }
            Class<?> beanClass = bean.getClass();
            Method[] methods = beanClass.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                int argSize;
                Method m = methods[i];
                if (!m.getName().equals(name)) continue;
                int paramSize = m.getParameterTypes() == null ? 0 : m.getParameterTypes().length;
                int n = argSize = args == null ? 0 : args.length;
                if (paramSize != argSize) continue;
                return m;
            }
            return null;
        }
    }
}

