/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.rcp.workspace;

import com.rameses.platform.interfaces.SubWindow;
import com.rameses.platform.interfaces.ViewContext;
import com.rameses.rcp.framework.Binding;
import com.rameses.rcp.ui.ControlContainer;
import com.rameses.rcp.ui.UIControl;
import com.rameses.rcp.workspace.Workspace;
import com.rameses.rcp.workspace.WorkspaceDefaultTpl;
import com.rameses.rcp.workspace.WorkspaceWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class WorkspaceViewContext
extends JPanel
implements ViewContext {
    private ViewContext viewCtx;
    private Workspace workspace;
    private String title;

    public WorkspaceViewContext(String title, Workspace workspace) {
        this.workspace = workspace;
        this.viewCtx = ((WorkspaceWindow)workspace.getMainWindow()).getViewContext();
        this.title = title;
        this.init((Component)((Object)workspace.getMainWindow()));
    }

    public WorkspaceViewContext(String title, Workspace workspace, ViewContext viewCtx) {
        this.workspace = workspace;
        this.viewCtx = viewCtx;
        this.title = title;
        this.init((Component)((Object)viewCtx));
    }

    private void init(Component comp) {
        super.setLayout(new BorderLayout());
        Class<? extends JComponent> template = this.workspace.getTemplate();
        String tplTitle = this.workspace.getTemplateTitle();
        if (template != null) {
            try {
                JComponent tpl = template.newInstance();
                if (tplTitle != null && tpl instanceof WorkspaceDefaultTpl) {
                    ((WorkspaceDefaultTpl)tpl).setTitle(tplTitle);
                }
                Binding b = new Binding();
                this.bindRecursive(tpl, b);
                HashMap<String, Object> bean = new HashMap<String, Object>();
                bean.put("conf", this.workspace.getConf());
                bean.put("title", this.title);
                b.setBean(bean);
                b.refresh();
                tpl.add(comp);
                comp = tpl;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        super.add(comp);
    }

    private void bindRecursive(Container comp, Binding binding) {
        for (Component c : comp.getComponents()) {
            if (c instanceof UIControl) {
                UIControl uic = (UIControl)((Object)c);
                binding.bind(uic);
                binding.register(uic);
                if (!(c instanceof ControlContainer) || !((ControlContainer)((Object)c)).isHasNonDynamicContents() || !(c instanceof Container)) continue;
                this.bindRecursive((Container)c, binding);
                continue;
            }
            if (!(c instanceof Container)) continue;
            this.bindRecursive((Container)c, binding);
        }
    }

    @Override
    public void setLayout(LayoutManager mgr) {
    }

    @Override
    public boolean close() {
        if (this.viewCtx != null) {
            return this.viewCtx.close();
        }
        return true;
    }

    @Override
    public void display() {
        if (this.viewCtx != null) {
            this.viewCtx.display();
        }
    }

    @Override
    public void setSubWindow(SubWindow subWindow) {
        if (this.viewCtx != null) {
            this.viewCtx.setSubWindow(subWindow);
        }
    }

    @Override
    public SubWindow getSubWindow() {
        if (this.viewCtx != null) {
            return this.viewCtx.getSubWindow();
        }
        return null;
    }

    @Override
    public void activate() {
        if (this.viewCtx != null) {
            this.viewCtx.activate();
        }
    }
}

