/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import com.rameses.osiris2.reports.ReportModel;
import com.rameses.rcp.common.IReportDesigner;
import com.rameses.rcp.common.IReportDesignerModel;
import com.rameses.rcp.common.MsgBox;
import com.rameses.rcp.framework.ClientContext;
import it.businesslogic.ireport.IReportConnection;
import it.businesslogic.ireport.ReportClassLoader;
import it.businesslogic.ireport.gui.ContentPanel;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.TestJRCustomDataSourceConnection;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class MainFrameImpl
extends MainFrame {
    private ContentPanel contentPanel;
    private IReportDesignerModel model;

    public MainFrameImpl(IReportDesignerModel model) {
        super(0);
        this.model = model;
    }

    ReportClassLoader createReportClassLoader() {
        ClassLoader parent;
        ClientContext ctx = ClientContext.getCurrentContext();
        ClassLoader classLoader = parent = ctx == null ? null : ctx.getClassLoader();
        if (parent == null) {
            return new ReportClassLoaderImpl();
        }
        return new ReportClassLoaderImpl(parent);
    }

    protected void beforeInit(Map map) {
        List<File> files;
        String home_dir = IReportDesigner.getConfig().getLocation();
        if (home_dir == null || home_dir.trim().length() == 0) {
            throw new RuntimeException("Please specify first the location of your IReport folder");
        }
        File file_dir = new File(home_dir);
        if (!file_dir.exists() || !file_dir.isDirectory()) {
            try {
                throw new RuntimeException("'" + file_dir.getCanonicalPath() + "' is not a valid file directory");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        map.put("ireport-home", home_dir);
        map.put("tmp-dir", IReportDesigner.getConfig().getTempDir().getPath());
        map.put("temp-dir", IReportDesigner.getConfig().getTempDir().getPath());
        map.put("user-home", IReportDesigner.getConfig().getUserDir().getPath());
        List<File> list = files = this.model == null ? null : this.model.getFiles();
        if (files != null && files.size() > 0) {
            map.put("files", files);
        }
    }

    protected void afterInit(Map map) {
        this.initComponents();
    }

    public boolean isEmbedded() {
        return true;
    }

    protected void adjustDockablesOnWindowOpened(WindowEvent evt) {
    }

    protected IReportConnection getDefaultConnection() {
        ReportModel rm = this.model == null ? null : this.model.getReportModel();
        return new TestJRCustomDataSourceConnection(this, rm);
    }

    public void reopen(IReportDesignerModel model) {
        try {
            super.reopen(model.getFiles());
            this.model = model;
        }
        catch (Throwable t) {
            MsgBox.err((Throwable)t);
        }
    }

    private void initComponents() {
        JMenuBar jbar;
        int count;
        Component c = this.findComponentDownward((Component)((Object)this), JMenuBar.class);
        if (c instanceof JMenuBar && (count = (jbar = (JMenuBar)c).getMenuCount()) > 1) {
            JMenu jm = jbar.getMenu(0);
            Component[] comps = jm.getMenuComponents();
            for (int i = 0; i < comps.length; ++i) {
                if (i == 0) continue;
                if (i < 3) {
                    jm.remove(comps[i]);
                    continue;
                }
                if (!(comps[i] instanceof JMenuItem)) continue;
                JMenuItem jmi = (JMenuItem)comps[i];
                String text = (jmi.getText() + "").toString().toLowerCase().trim();
                if (text.startsWith("recent")) {
                    jm.remove(jmi);
                    continue;
                }
                if (!text.startsWith("save as")) continue;
                jm.remove(jmi);
            }
        }
    }

    void removeActions(AbstractButton ab) {
        ActionListener[] als = ab.getActionListeners();
        if (als == null || als.length == 0) {
            return;
        }
        for (ActionListener al : als) {
            ab.removeActionListener(al);
        }
    }

    Component findComponentDownward(Component source, Class findClass) {
        if (source == null) {
            return source;
        }
        if (findClass.isAssignableFrom(source.getClass())) {
            return source;
        }
        if (source instanceof Container) {
            Component[] comps = ((Container)source).getComponents();
            if (comps == null) {
                return null;
            }
            for (Component cc : comps) {
                if (!findClass.isAssignableFrom(cc.getClass())) continue;
                return cc;
            }
            for (Component cc : comps) {
                Component res = this.findComponentDownward(cc, findClass);
                if (res == null) continue;
                return res;
            }
        }
        return null;
    }

    void scanDown(Component c, int level) {
        if (c == null) {
            return;
        }
        String str = this.createSpaces(level) + "(" + level + ") " + c;
        System.out.println(str);
        if (c instanceof Container) {
            Component[] comps = ((Container)c).getComponents();
            for (int i = 0; i < comps.length; ++i) {
                this.scanDown(comps[i], level + 1);
            }
        }
    }

    String createSpaces(int level) {
        StringBuilder buff = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            buff.append("   ");
        }
        return buff.toString();
    }

    public Container getContentPane() {
        if (this.contentPanel == null) {
            this.contentPanel = new ContentPanelImpl();
            this.setContentPane(this.contentPanel);
        }
        return super.getContentPane();
    }

    public URL findResource(String name) {
        URL url = this.findResourceImpl(name);
        if (url != null) {
            return url;
        }
        return super.findResource(name);
    }

    private URL findResourceImpl(String name) {
        if (name != null && name.startsWith("/")) {
            File custom_dir = IReportDesigner.getConfig().getCustomDir();
            File file = new File(custom_dir, name.substring(1));
            try {
                if (file.exists()) {
                    return file.toURI().toURL();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static void main(MainFrameImpl frame) {
        MainFrame.main((String[])new String[0], (MainFrame)frame);
    }

    static {
        System.out.println("static load from MainFrameImpl");
    }

    class ReportClassLoaderImpl
    extends ReportClassLoader {
        MainFrameImpl root;

        public ReportClassLoaderImpl() {
            this.root = MainFrameImpl.this;
        }

        public ReportClassLoaderImpl(ClassLoader parent) {
            super(parent);
            this.root = MainFrameImpl.this;
        }

        public URL findResource(String name) {
            URL url = this.root.findResourceImpl(name);
            if (url != null) {
                return url;
            }
            return super.findResource(name);
        }
    }

    class SaveAllAction
    implements ActionListener {
        SaveAllAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    class SaveAction
    implements ActionListener {
        SaveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    class ContentPanelImpl
    extends ContentPanel {
        MainFrameImpl root;

        ContentPanelImpl() {
            this.root = MainFrameImpl.this;
        }

        @Override
        protected void upload() {
            if (this.root.model == null) {
                return;
            }
            if (this.root.isSaveAllRequired()) {
                String message = "There are unsaved files.  Please save them first";
                JOptionPane.showMessageDialog((Component)((Object)this.root), message, "Unsaved files", 2);
                return;
            }
            if (this.root.model.upload()) {
                this.root.close();
            }
        }

        @Override
        protected void download() {
            if (this.root.model != null) {
                this.root.model.download();
            }
        }

        @Override
        protected void showImageList() {
            if (this.root.model != null) {
                this.root.model.showImageList();
            }
        }
    }
}

