/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris2.client;

import com.rameses.common.ExpressionResolver;
import com.rameses.osiris2.Folder;
import com.rameses.osiris2.Invoker;
import com.rameses.osiris2.SessionContext;
import com.rameses.osiris2.client.InvokerAction;
import com.rameses.osiris2.client.InvokerFilter;
import com.rameses.osiris2.client.InvokerOpener;
import com.rameses.osiris2.client.InvokerParameter;
import com.rameses.osiris2.client.OsirisContext;
import com.rameses.platform.interfaces.Platform;
import com.rameses.rcp.common.Action;
import com.rameses.rcp.common.Opener;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.framework.ControllerProvider;
import com.rameses.rcp.framework.UIController;
import com.rameses.rcp.framework.UIControllerContext;
import com.rameses.rcp.framework.UIControllerPanel;
import com.rameses.rcp.util.ControlSupport;
import com.rameses.util.BreakException;
import com.rameses.util.ExceptionManager;
import com.rameses.util.ValueUtil;
import java.awt.EventQueue;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;

class InvokerUtilImpl {
    InvokerUtilImpl() {
    }

    public static UIController createController(Invoker invoker) {
        ClientContext ctx = ClientContext.getCurrentContext();
        Platform platform = ctx.getPlatform();
        String wuId = invoker.getWorkunitid();
        ControllerProvider cp = ctx.getControllerProvider();
        UIController u = cp.getController(wuId, null);
        Object callee = u.getCodeBean();
        ControlSupport.injectInvoker((Object)callee, callee.getClass(), (Object)invoker);
        return u;
    }

    public static void invoke(Invoker invoker) {
        InvokerUtilImpl.invoke(invoker, null);
    }

    public static void invoke(Invoker invoker, Map params) {
        InvokerUtilImpl.invoke(invoker, params, null);
    }

    public static void invoke(Invoker invoker, Map params, Object caller) {
        block17: {
            try {
                if (params == null) {
                    params = new HashMap();
                }
                ClientContext ctx = ClientContext.getCurrentContext();
                Platform platform = ctx.getPlatform();
                String wuId = invoker.getWorkunitid();
                ControllerProvider cp = ctx.getControllerProvider();
                UIController u = cp.getController(wuId, (UIController)caller);
                Object callee = u.getCodeBean();
                ControlSupport.injectInvoker((Object)callee, callee.getClass(), (Object)invoker);
                if (caller != null) {
                    ControlSupport.injectCaller((Object)callee, callee.getClass(), (Object)caller);
                }
                String action = invoker.getAction();
                u.setId(InvokerUtilImpl.createInvokerId(invoker));
                u.setName(wuId);
                u.setTitle(invoker.getCaption());
                Object outcome = null;
                Object[] args = new Object[]{invoker};
                outcome = Tools.hasMethod(callee, action, args) ? u.init(params, action, args) : u.init(params, action);
                if (outcome instanceof String && outcome.toString().matches("_close|_exit")) {
                    return;
                }
                String windowId = u.getId();
                if (platform.isWindowExists(windowId)) {
                    platform.activateWindow(windowId);
                    return;
                }
                String target = (String)invoker.getProperties().get("target");
                if (target == null) {
                    target = "_window";
                }
                if (target.endsWith("process") || target.endsWith("action")) {
                    if (outcome instanceof Opener) {
                        InvokerUtilImpl.invoke((Opener)outcome, u);
                    }
                } else {
                    UIControllerContext uic = new UIControllerContext(u);
                    uic.setId(windowId);
                    if (outcome instanceof Object[] && outcome instanceof Collection) {
                        throw new Exception("outcome must an instance of String or Opener");
                    }
                    if (!ValueUtil.isEmpty((Object)outcome)) {
                        uic.setCurrentView(outcome.toString());
                    }
                    UIControllerPanel panel = new UIControllerPanel(uic);
                    HashMap<String, Object> winParams = new HashMap<String, Object>();
                    if (invoker.getProperties() != null) {
                        Map props = invoker.getProperties();
                        winParams.putAll(props);
                        if (props.get("alwaysOnTop") != null) {
                            winParams.put("alwaysOnTop", Boolean.valueOf(props.get("alwaysOnTop") + ""));
                        }
                    }
                    winParams.put("id", windowId);
                    winParams.put("title", uic.getTitle());
                    if ("_popup".equals(target) || "popup".equals(target)) {
                        platform.showPopup(null, (JComponent)panel, winParams);
                    } else {
                        platform.showWindow(null, (JComponent)panel, winParams);
                    }
                }
            }
            catch (BreakException ctx) {
            }
            catch (Exception ex) {
                Exception e = ExceptionManager.getOriginal((Exception)ex);
                if (ExceptionManager.getInstance().handleError(e)) break block17;
                ClientContext.getCurrentContext().getPlatform().showError(null, ex);
            }
        }
    }

    public static void invoke(Opener opener) {
        InvokerUtilImpl.invoke(opener, null);
    }

    public static void invoke(Opener opener, UIController caller) {
        ControlSupport.initOpener((Opener)opener, (UIController)caller);
        String target = opener.getTarget();
        if ("process".equalsIgnoreCase(target + "")) {
            return;
        }
        UIControllerContext uic = new UIControllerContext(opener.getController());
        String outcome = opener.getOutcome();
        if (outcome != null && opener.getController().containsView(outcome)) {
            uic.setCurrentView(outcome);
        }
        UIControllerPanel panel = new UIControllerPanel(uic);
        HashMap<String, String> winParams = new HashMap<String, String>();
        if (opener.getProperties() != null) {
            winParams.putAll(opener.getProperties());
        }
        winParams.put("id", uic.getId());
        winParams.put("title", uic.getTitle());
        if ("_popup".equals(target) || "popup".equals(target)) {
            ClientContext.getCurrentContext().getPlatform().showPopup(null, (JComponent)panel, winParams);
        } else {
            ClientContext.getCurrentContext().getPlatform().showWindow(null, (JComponent)panel, winParams);
        }
    }

    public static void showWindow(Invoker invoker, String target, Map winParams) {
        if (!ValueUtil.isEmpty((Object)target)) {
            invoker.setType(target);
        }
        if (winParams != null) {
            invoker.getProperties().putAll(winParams);
        }
        InvokerUtilImpl.invoke(invoker, null, null);
    }

    public static Object invokeAction(InvokerAction action) {
        try {
            Invoker inv = action.getInvoker();
            InvokerParameter invParam = action.getInvokerParam();
            String target = (String)inv.getProperties().get("target");
            if (target == null) {
                target = "_window";
            }
            Map props = null;
            String caption = null;
            if (invParam != null) {
                props = invParam.getParams(inv);
                caption = (String)props.remove("formTitle");
            }
            action.getProperties().put("Action.Invoker", inv);
            if (caption == null) {
                caption = inv.getCaption();
            }
            if (target.endsWith("process") || target.endsWith("action")) {
                InvokerUtilImpl.invoke(inv, props);
                return null;
            }
            return InvokerUtilImpl.createOpener(inv, props, caption);
        }
        catch (Exception ex) {
            Exception e = ExceptionManager.getOriginal((Exception)ex);
            if (!ExceptionManager.getInstance().handleError(e)) {
                ClientContext.getCurrentContext().getPlatform().showError(null, ex);
            }
            return null;
        }
    }

    public static List lookupActions(String type) {
        return InvokerUtilImpl.lookupActions(type, null, null);
    }

    public static List lookupActions(String type, InvokerFilter filter) {
        return InvokerUtilImpl.lookupActions(type, null, filter);
    }

    public static List lookupActions(String type, Map params) {
        final Map p = params;
        InvokerParameter inv = new InvokerParameter(){

            @Override
            public Map getParams(Invoker inv) {
                return p;
            }
        };
        return InvokerUtilImpl.lookupActions(type, inv, null);
    }

    public static List lookupActions(String type, InvokerParameter param) {
        return InvokerUtilImpl.lookupActions(type, param, null);
    }

    public static List lookupActions(String type, InvokerParameter param, InvokerFilter filter) {
        ArrayList<Action> actions = new ArrayList<Action>();
        List invList = InvokerUtilImpl.lookup(type, null, filter);
        for (Object o : invList) {
            Invoker inv = (Invoker)o;
            actions.add(InvokerUtilImpl.createInvokerAction(inv, param));
        }
        return actions;
    }

    private static Action createInvokerAction(Invoker inv, InvokerParameter param) {
        Object tooltip;
        InvokerAction a = new InvokerAction(inv, param);
        HashMap invProps = new HashMap(inv.getProperties());
        a.setName(inv.getAction());
        a.setCaption(inv.getCaption());
        if (inv.getIndex() != null) {
            a.setIndex(inv.getIndex());
        }
        a.setIcon((String)invProps.remove("icon"));
        a.setImmediate("true".equals(invProps.remove("immediate") + ""));
        a.setUpdate("true".equals(invProps.remove("update") + ""));
        a.setVisibleWhen((String)invProps.remove("visibleWhen"));
        String mnemonic = (String)invProps.remove("mnemonic");
        if (!ValueUtil.isEmpty((Object)mnemonic)) {
            a.setMnemonic(mnemonic.charAt(0));
        }
        if (!ValueUtil.isEmpty(tooltip = invProps.remove("tooltip"))) {
            a.setTooltip(tooltip + "");
        }
        if (!invProps.isEmpty()) {
            a.getProperties().putAll(invProps);
        }
        a.getProperties().put("Action.Invoker", inv);
        return a;
    }

    public static List lookup(String type) {
        return InvokerUtilImpl.lookup(type, null, null);
    }

    public static List lookup(String type, Object obj) {
        return InvokerUtilImpl.lookup(type, obj, null);
    }

    public static List lookup(String type, Object obj, InvokerFilter filter) {
        return InvokerUtilImpl.lookup(type, obj, filter, true);
    }

    public static List lookup(String type, Object obj, InvokerFilter filter, boolean applySecurity) {
        SessionContext app = OsirisContext.getSession();
        List list = app.getInvokers(type, applySecurity);
        ExpressionResolver er = ExpressionResolver.getInstance();
        ArrayList<Invoker> data = new ArrayList<Invoker>();
        for (Object o : list) {
            Invoker inv = (Invoker)o;
            if (filter != null && !filter.accept(inv)) continue;
            if (inv.getProperties().get("eval") != null) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("param", obj);
                params.put("context", inv);
                String cond = (String)inv.getProperties().get("eval");
                if (cond.trim().length() <= 0) continue;
                boolean b = false;
                try {
                    b = (Boolean)er.eval(cond, params);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!b) continue;
                data.add(inv);
                continue;
            }
            data.add(inv);
        }
        return data;
    }

    public static List lookupFolder(String name) {
        if (name == null) {
            return null;
        }
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        ArrayList<Invoker> invokers = new ArrayList<Invoker>();
        SessionContext app = OsirisContext.getSession();
        List items = app.getFolders(name);
        if (items != null) {
            for (Object o : items) {
                Folder f = (Folder)o;
                if (f.getInvoker() == null) continue;
                Invoker v = f.getInvoker();
                invokers.add(v);
            }
        }
        return invokers;
    }

    public static Opener lookupOpener(String invType) {
        return InvokerUtilImpl.lookupOpener(invType, null);
    }

    public static Opener lookupOpener(String invType, Map params) {
        List list = InvokerUtilImpl.lookup(invType);
        if (list.size() == 0) {
            System.out.println("[WARN] No invokers found for type [" + invType + "]");
            throw new RuntimeException("No access privilege for this item. Please contact your administrator.");
        }
        return InvokerUtilImpl.createOpener((Invoker)list.get(0), params);
    }

    public static void lookupAsync(String invType) {
        InvokerUtilImpl.lookupAsync(invType, null);
    }

    public static void lookupAsync(String invType, Map params) {
        EventQueue.invokeLater(new AsyncOpenerRunnable(invType, params));
    }

    public static List lookupOpeners(String invType) {
        return InvokerUtilImpl.lookupOpeners(invType, null, null);
    }

    public static List lookupOpeners(String invType, Map params) {
        return InvokerUtilImpl.lookupOpeners(invType, params, null);
    }

    public static List lookupOpeners(String invType, Map params, InvokerFilter filter) {
        List list = InvokerUtilImpl.lookup(invType, null, filter);
        if (list.size() == 0) {
            System.out.println("[WARN] No invokers found for type [" + invType + "]");
            throw new RuntimeException("No access privilege for this item. Please contact your administrator.");
        }
        ArrayList<Opener> openers = new ArrayList<Opener>();
        for (Invoker inv : list) {
            Opener opener = InvokerUtilImpl.createOpener(inv, params);
            openers.add(opener);
        }
        return openers;
    }

    public static Object invokeOpener(Opener opener) {
        return InvokerUtilImpl.invokeOpener(opener, null);
    }

    public static Object invokeOpener(Opener opener, UIController caller) {
        ControlSupport.initOpener((Opener)opener, (UIController)caller, (boolean)false);
        return ControlSupport.init((Object)opener.getController().getCodeBean(), (Map)opener.getParams(), (String)opener.getAction());
    }

    public static Opener createOpener(Invoker inv) {
        return InvokerUtilImpl.createOpener(inv, null);
    }

    public static Opener createOpener(Invoker inv, Map params) {
        return InvokerUtilImpl.createOpener(inv, params, null);
    }

    public static Opener createOpener(Invoker inv, Map params, String caption) {
        return new InvokerOpener(inv, params, caption);
    }

    private static String createInvokerId(Invoker inv) {
        StringBuffer sb = new StringBuffer();
        sb.append(inv.getWorkunitid());
        String id = (String)inv.getProperties().get("id");
        if (id != null && id.trim().length() > 0) {
            sb.append("_" + id);
        } else if (inv.getCaption() != null && inv.getCaption().trim().length() > 0) {
            sb.append("_" + inv.getCaption());
        }
        return sb.toString();
    }

    static class Tools {
        Tools() {
        }

        public static boolean hasMethod(Object bean, String name, Object[] args) {
            if (bean == null || name == null) {
                return false;
            }
            for (Class<?> beanClass = bean.getClass(); beanClass != null; beanClass = beanClass.getSuperclass()) {
                Method[] methods = beanClass.getMethods();
                for (int i = 0; i < methods.length; ++i) {
                    int argSize;
                    Method m = methods[i];
                    if (!m.getName().equals(name)) continue;
                    int paramSize = m.getParameterTypes() == null ? 0 : m.getParameterTypes().length;
                    int n = argSize = args == null ? 0 : args.length;
                    if (paramSize == argSize && paramSize == 0) {
                        return true;
                    }
                    if (paramSize != argSize || m.getParameterTypes()[0] != Object.class) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private static class AsyncOpenerRunnable
    implements Runnable {
        private String invType;
        private Map params;

        AsyncOpenerRunnable(String invType, Map params) {
            this.invType = invType;
            this.params = params;
        }

        @Override
        public void run() {
            List list = InvokerUtilImpl.lookup(this.invType, null, null);
            if (list.isEmpty()) {
                System.out.println("[WARN] No invokers found for type [" + this.invType + "]");
                throw new RuntimeException("No access privilege for this item. Please contact your administrator.");
            }
            Invoker invoker = (Invoker)list.remove(0);
            list.clear();
            InvokerUtilImpl.invoke(invoker, this.params);
        }
    }
}

