/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris2.client;

import com.rameses.osiris2.Folder;
import com.rameses.osiris2.Invoker;
import com.rameses.osiris2.SessionContext;
import com.rameses.osiris2.client.InvokerUtil;
import com.rameses.osiris2.client.OsirisContext;
import com.rameses.rcp.support.ImageIconSupport;
import com.rameses.rcp.util.ControlSupport;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public final class MenuUtil {
    public static JMenuBar getMenuBar(String name) {
        JMenuBar menuBar = new JMenuBar();
        for (JMenuItem m : MenuUtil.getMenuCollection(name)) {
            if (m instanceof JMenu && !MenuUtil.hasChildren((JMenu)m)) continue;
            menuBar.add(m);
        }
        return menuBar;
    }

    private static boolean hasChildren(JMenu jm) {
        jm.getComponentCount();
        if (jm.getMenuComponentCount() == 0) {
            return false;
        }
        boolean hasChildren = false;
        ArrayList<JMenu> emptyMenus = new ArrayList<JMenu>();
        for (int i = 0; i < jm.getMenuComponentCount(); ++i) {
            Component c = jm.getMenuComponent(i);
            if (c instanceof JMenu) {
                JMenu subMenu = (JMenu)c;
                if (!MenuUtil.hasChildren(subMenu)) {
                    emptyMenus.add(subMenu);
                    continue;
                }
                hasChildren = true;
                continue;
            }
            hasChildren = true;
        }
        while (!emptyMenus.isEmpty()) {
            JMenu mnu = (JMenu)emptyMenus.remove(0);
            jm.remove(mnu);
        }
        return hasChildren;
    }

    public static List<JMenuItem> getMenuCollection(String name) {
        SessionContext app;
        List items;
        ArrayList<JMenuItem> list = new ArrayList<JMenuItem>();
        if (name != null && (items = (app = OsirisContext.getSession()).getFolders(name)) != null) {
            for (Object o : items) {
                Folder f = (Folder)o;
                String separator = null;
                JMenuItem mi = null;
                if (f.getInvoker() == null) {
                    separator = (String)f.getProperties().get("separator");
                    mi = new MenuProxy((Folder)o);
                } else {
                    separator = (String)f.getInvoker().getProperties().get("separator");
                    mi = new MenuItemProxy((Folder)o);
                }
                if (separator != null && separator.trim().length() > 0) {
                    mi.putClientProperty("separator", separator);
                }
                list.add(mi);
            }
        }
        return list;
    }

    private static char getFirstChar(String value) {
        if (value != null && value.trim().length() > 0) {
            return value.charAt(0);
        }
        return '\u0000';
    }

    private static class MenuItemProxy
    extends JMenuItem
    implements ActionListener {
        private Invoker invoker;

        MenuItemProxy(Folder menu) {
            this.setText(menu.getCaption());
            Object mnemonic = menu.getProperties().get("mnemonic");
            if (mnemonic != null) {
                this.setMnemonic(MenuUtil.getFirstChar(mnemonic.toString()));
            }
            this.invoker = menu.getInvoker();
            String icon = (String)this.invoker.getProperties().get("icon");
            if (icon != null) {
                this.setIcon(ImageIconSupport.getInstance().getIcon(icon));
            }
            this.setActionCommand(this.invoker.getAction());
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                InvokerUtil.invoke(this.invoker, null);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex.getMessage(), ex);
            }
        }
    }

    private static class MenuProxy
    extends JMenu {
        private boolean init;
        private String id;

        MenuProxy(Folder menu) {
            String icon;
            this.id = menu.getFullId();
            this.setText(menu.getCaption());
            Object mnemonic = menu.getProperties().get("mnemonic");
            if (mnemonic != null) {
                this.setMnemonic(MenuUtil.getFirstChar(mnemonic.toString()));
            }
            if ((icon = (String)menu.getProperties().get("icon")) != null) {
                this.setIcon(ControlSupport.getImageIcon((String)icon));
            }
        }

        @Override
        public int getComponentCount() {
            if (!this.init) {
                List<JMenuItem> menus = MenuUtil.getMenuCollection(this.id);
                int sz = menus.size();
                for (int i = 0; i < sz; ++i) {
                    String pseparator;
                    JMenuItem mi = menus.get(i);
                    String separator = (String)mi.getClientProperty("separator");
                    if (i > 0 && separator != null && separator.equalsIgnoreCase("before") && ((pseparator = (String)menus.get(i - 1).getClientProperty("separator")) == null || !pseparator.equalsIgnoreCase("after"))) {
                        this.addSeparator();
                    }
                    this.add(mi);
                    if (i == sz - 1 || separator == null || !separator.equalsIgnoreCase("after")) continue;
                    this.addSeparator();
                }
                this.init = true;
            }
            return super.getComponentCount();
        }
    }
}

