/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris2.client;

import com.rameses.osiris2.AppContext;
import com.rameses.osiris2.client.OsirisAppContext;
import com.rameses.osiris2.client.OsirisContext;
import com.rameses.osiris2.client.OsirisSessionContext;
import com.rameses.osiris2.client.UILoaderStack;
import com.rameses.platform.interfaces.AppLoader;
import com.rameses.platform.interfaces.MainWindowListener;
import com.rameses.platform.interfaces.Platform;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.framework.ClientSecurityProvider;
import com.rameses.rcp.framework.UIControllerPanel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.swing.JComponent;

public class OsirisAppLoader
implements AppLoader {
    public static final String KEY_LOADER_TYPE = "LOADER_TYPE";
    public static final String KEY_PROPERTIES = "PROPERTIES";
    public static final String KEY_CLIENT_ENV = "CLIENT_ENV";
    public static final String KEY_CLIENT_PERMISSIONS = "CLIENT_PERMISSIONS";

    public void load(ClassLoader loader, Map env, Platform platform) {
        try {
            List loaders;
            if (env == null) {
                env = new HashMap<String, String>();
            }
            OsirisAppContext dac = new OsirisAppContext(loader);
            if (env.get("readTimeout") == null) {
                env.put("readTimeout", "20000");
            }
            dac.setEnvMap(env);
            dac.load();
            AppContext.setInstance((AppContext)dac);
            OsirisSessionContext startupApp = (OsirisSessionContext)dac.createSession();
            ClientSecurityProvider cs = (ClientSecurityProvider)startupApp.getSecurityProvider();
            ClientContext ctx = ClientContext.getCurrentContext();
            ctx.getProperties().clear();
            ctx.setSecurityProvider(cs);
            ctx.setPlatform(platform);
            ctx.setClassLoader(loader);
            ctx.setAppEnv(env);
            OsirisContext.setSession(startupApp);
            this.afterSetSession();
            if (env.get(KEY_CLIENT_ENV) != null) {
                Map clientEnv = (Map)env.remove(KEY_CLIENT_ENV);
                OsirisContext.getEnv().putAll(clientEnv);
            }
            if (env.get(KEY_PROPERTIES) != null) {
                Map properties = (Map)env.remove(KEY_PROPERTIES);
                ctx.getProperties().putAll(properties);
            }
            if (env.get("app.debugMode") != null) {
                ctx.setDebugMode("true".equals(env.get("app.debugMode").toString()));
            }
            String loaderType = "loader";
            if (env.get(KEY_LOADER_TYPE) != null) {
                loaderType = (String)env.remove(KEY_LOADER_TYPE);
            }
            if ((loaders = startupApp.getInvokers(loaderType, false)).size() > 0) {
                UIControllerPanel uip = new UIControllerPanel();
                UILoaderStack uls = new UILoaderStack();
                uls.setLoaders(loaders);
                uip.setControllers((Stack)uls);
                HashMap<String, String> winProps = new HashMap<String, String>();
                winProps.put("canclose", "false");
                winProps.put("title", "Home");
                winProps.put("id", "loader_workunits");
                platform.showStartupWindow(null, (JComponent)uip, winProps);
            }
            startupApp.load();
            ctx.getTaskManager().start();
            platform.getMainWindow().setListener((MainWindowListener)OsirisContext.getMainWindowListener());
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
    }

    public void restore() {
    }

    protected void afterSetSession() {
    }
}

