/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris2.client;

import com.rameses.osiris2.Invoker;
import com.rameses.osiris2.SessionContext;
import com.rameses.osiris2.client.InvokerUtil;
import com.rameses.osiris2.client.OsirisContext;
import com.rameses.rcp.framework.ClientContext;
import com.rameses.rcp.framework.ControllerProvider;
import com.rameses.rcp.framework.UIController;
import com.rameses.rcp.framework.UIControllerContext;
import com.rameses.rcp.framework.UIControllerPanel;
import com.rameses.rcp.support.ImageIconSupport;
import com.rameses.rcp.support.ResourceUtil;
import com.rameses.util.BreakException;
import com.rameses.util.ValueUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;

public final class ToolbarUtil {
    public static JToolBar getToolBar() {
        SessionContext app = OsirisContext.getSession();
        JToolBar toolbar = new JToolBar();
        toolbar.setLayout(new ToolBarLayout());
        Object obj = OsirisContext.getEnv().get("toolbar.type");
        if (obj == null) {
            obj = "toolbar";
        }
        ButtonHelper buttonHelper = new ButtonHelper();
        List invokers = app.getInvokers(obj.toString());
        for (Invoker inv : invokers) {
            boolean isButton = true;
            MapHelper helper = new MapHelper(inv.getProperties());
            try {
                Boolean bool = helper.getBoolean("button");
                if (bool != null) {
                    isButton = bool;
                }
            }
            catch (Throwable bool) {
                // empty catch block
            }
            if (isButton) {
                String strclass = helper.getString("buttonClass");
                if (strclass == null || strclass.length() == 0) {
                    toolbar.add(new InvokerAction(inv));
                    continue;
                }
                try {
                    Class clazz = helper.getClass("buttonClass");
                    JButton btn = (JButton)clazz.newInstance();
                    btn.addActionListener(new InvokerActionHandler(inv));
                    buttonHelper.setProperties(btn, inv, helper);
                    toolbar.add(btn);
                }
                catch (Throwable t) {
                    System.out.println("error caused by " + t.getClass().getName() + ": " + t.getMessage());
                    t.printStackTrace();
                }
                continue;
            }
            toolbar.add(ToolbarUtil.getViewComponent(inv));
        }
        return toolbar;
    }

    public static Component getViewComponent(Invoker inv) {
        String out;
        ControllerProvider cp = ClientContext.getCurrentContext().getControllerProvider();
        UIController c = cp.getController(inv.getWorkunitid(), null);
        String action = inv.getAction();
        UIControllerContext uic = new UIControllerContext(c);
        if (action != null && !ValueUtil.isEmpty((Object)(out = (String)c.init(new HashMap(), action)))) {
            uic.setCurrentView(out);
        }
        return new UIControllerPanel(uic);
    }

    public static interface CustomAction {
        public void setInvoker(Invoker var1);

        public void setController(UIController var1);
    }

    private static class ToolBarLayout
    implements LayoutManager {
        private static final int SPACING = 2;

        private ToolBarLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Dimension getLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                int w = 0;
                int h = 0;
                Component[] comps = parent.getComponents();
                for (int i = 0; i < comps.length; ++i) {
                    if (!comps[i].isVisible()) continue;
                    Dimension dim = comps[i].getPreferredSize();
                    w += dim.width + 2;
                    h = Math.max(h, dim.height);
                }
                return new Dimension(w, h);
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.getLayoutSize(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets margin = new Insets(2, 2, 2, 2);
                int x = margin.left;
                int y = margin.top;
                int w = parent.getWidth() - (margin.left + margin.right);
                int h = parent.getHeight() - (margin.top + margin.bottom);
                Component[] comps = parent.getComponents();
                for (int i = 0; i < comps.length; ++i) {
                    Component comp = comps[i];
                    if (!comp.isVisible()) continue;
                    Dimension dim = comp.getPreferredSize();
                    comp.setBounds(x, y, dim.width, h);
                    x += dim.width + 2;
                }
            }
        }
    }

    private static class InvokerActionHandler
    implements ActionListener {
        private Invoker invoker;

        public InvokerActionHandler(Invoker invoker) {
            this.invoker = invoker;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                InvokerUtil.invoke(this.invoker, null);
            }
            catch (BreakException breakException) {
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex.getMessage(), ex);
            }
        }
    }

    private static class InvokerAction
    extends JButton {
        private Invoker invoker;

        public InvokerAction(Invoker invoker) {
            this.invoker = invoker;
            this.setFocusable(false);
            this.setText(invoker.getCaption());
            this.addActionListener(new InvokerActionHandler(invoker));
            try {
                String icn;
                String tooltip = (String)invoker.getProperties().get("tooltip");
                if (tooltip != null) {
                    this.setToolTipText(tooltip);
                }
                if ((icn = (String)invoker.getProperties().get("icon")) != null) {
                    this.setIcon(ResourceUtil.getImageIcon((String)icn));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static class ButtonHelper {
        private ButtonHelper() {
        }

        void setProperties(JButton btn, Invoker inv, MapHelper helper) {
            String icon;
            String tooltip;
            btn.setFocusable(false);
            String caption = helper.getString("caption");
            if (caption != null) {
                btn.setText(caption);
            }
            if ((tooltip = helper.getString("tooltip")) != null) {
                btn.setToolTipText(tooltip);
            }
            if ((icon = helper.getString("icon")) != null) {
                ImageIcon iicon = ImageIconSupport.getInstance().getIcon(icon);
                btn.setIcon(iicon);
            }
        }
    }

    private static class MapHelper {
        private Map props;

        MapHelper(Map props) {
            this.props = props;
        }

        private Object get(String key) {
            return this.props == null ? null : this.props.get(key);
        }

        public Boolean getBoolean(String key) {
            Object value = this.get(key);
            if (value == null) {
                return null;
            }
            if ("true".equals(value.toString())) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public String getString(String key) {
            Object value = this.get(key);
            return value == null ? null : value.toString();
        }

        public Class getClass(String key) {
            String str = this.getString(key);
            if (str == null || str.length() == 0) {
                return null;
            }
            try {
                return ClientContext.getCurrentContext().getClassLoader().loadClass(str);
            }
            catch (Throwable t) {
                return null;
            }
        }
    }
}

