/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris2.client;

import com.rameses.classutils.ClassDefUtil;
import com.rameses.common.MethodResolver;
import com.rameses.common.PropertyResolver;
import com.rameses.osiris2.Page;
import com.rameses.osiris2.WorkUnit;
import com.rameses.osiris2.WorkUnitInstance;
import com.rameses.osiris2.client.OsirisContext;
import com.rameses.rcp.annotations.FormId;
import com.rameses.rcp.annotations.FormTitle;
import com.rameses.rcp.framework.UIController;
import com.rameses.rcp.util.ControlSupport;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class WorkUnitUIController
extends UIController {
    private WorkUnitInstance workunit;
    private String id;
    private String title;
    private String name;
    private String defaultPageName = "default";
    private String formId;
    private String formTitle;

    public WorkUnitUIController(WorkUnitInstance wu) {
        this.workunit = wu;
        this.id = wu.getId();
        this.name = wu.getId();
        this.title = wu.getTitle();
    }

    public Object getCodeBean() {
        return this.workunit.getController();
    }

    public String getDefaultView() {
        if (this.defaultPageName == null && this.workunit.getWorkunit().getPages().size() > 0) {
            this.defaultPageName = this.workunit.getCurrentPage().getName();
        }
        return this.defaultPageName;
    }

    public UIController.View[] getViews() {
        ArrayList<UIController.View> list = new ArrayList<UIController.View>();
        for (Object o : this.workunit.getWorkunit().getPages().values()) {
            Page p = (Page)o;
            list.add(new UIController.View(p.getName(), p.getTemplate()));
        }
        return list.toArray(new UIController.View[0]);
    }

    public boolean containsView(String name) {
        try {
            return this.workunit.getWorkunit().getPages().containsKey(name);
        }
        catch (Throwable t) {
            return false;
        }
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getId() {
        if (this.formId == null) {
            Object codeBean = this.getCodeBean();
            try {
                Field fld = ClassDefUtil.getInstance().findAnnotatedField(codeBean.getClass(), FormId.class);
                if (fld != null) {
                    this.formId = (String)PropertyResolver.getInstance().getProperty(codeBean, fld.getName());
                }
            }
            catch (Exception fld) {
                // empty catch block
            }
            if (this.formId == null) {
                try {
                    Method m = ClassDefUtil.getInstance().findAnnotatedMethod(codeBean.getClass(), FormId.class);
                    if (m != null) {
                        this.formId = (String)MethodResolver.getInstance().invoke(codeBean, m.getName(), null, null);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.formId == null) {
                this.formId = "";
            }
        }
        if (this.formId.trim().length() > 0) {
            return this.formId;
        }
        return this.id;
    }

    public String getTitle() {
        if (this.formTitle == null) {
            Object codeBean = this.getCodeBean();
            try {
                Field fld = ClassDefUtil.getInstance().findAnnotatedField(codeBean.getClass(), FormTitle.class);
                if (fld != null) {
                    this.formTitle = (String)PropertyResolver.getInstance().getProperty(codeBean, fld.getName());
                }
            }
            catch (Exception fld) {
                // empty catch block
            }
            if (this.formTitle == null) {
                try {
                    Method m = ClassDefUtil.getInstance().findAnnotatedMethod(codeBean.getClass(), FormTitle.class);
                    if (m != null) {
                        this.formTitle = (String)MethodResolver.getInstance().invoke(codeBean, m.getName(), null, null);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.formTitle == null) {
                this.formTitle = "";
            }
        }
        if (this.formTitle.trim().length() > 0) {
            return this.formTitle;
        }
        return this.title;
    }

    public Object init(Map properties, String action, Object[] actionParams) {
        Object codeBean;
        ControlSupport.setProperties((Object)this.getCodeBean(), (Map)properties);
        if (this.workunit.getPageFlow() != null && this.workunit.isStarted()) {
            if (action == null) {
                this.workunit.signal();
            } else {
                this.workunit.signal(action);
            }
            if (this.workunit.isPageFlowCompleted()) {
                return "_close";
            }
            return this.workunit.getCurrentPage().getName();
        }
        if (this.workunit.getWorkunit().getPages().size() > 0) {
            this.defaultPageName = this.workunit.getCurrentPage().getName();
        }
        if (action == null) {
            return null;
        }
        if (action.startsWith("_")) {
            return action.substring(1);
        }
        if (actionParams == null) {
            actionParams = new Object[]{};
        }
        if (this.hasMethod(codeBean = this.getCodeBean(), action, actionParams)) {
            return ControlSupport.invoke((Object)codeBean, (String)action, (Object[])actionParams);
        }
        return ControlSupport.invoke((Object)codeBean, (String)action, null);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WorkUnitInstance getWorkunit() {
        return this.workunit;
    }

    public Map getInfo() {
        String workunitId = this.getWorkunit().getId();
        WorkUnit wu = this.getWorkunit().getWorkunit();
        if ("true".equals(wu.getProperties().get("disableWorkunitInfo") + "")) {
            return null;
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("workunit_name", wu.getName());
        map.put("workunit_properties", wu.getProperties());
        map.put("workunit_path", wu.getModule().getContextPath() + "/workunits/" + wu.getName() + ".xml");
        map.put("module_name", wu.getModule().getName());
        map.put("module_domain", wu.getModule().getDomain());
        map.put("module_properties", wu.getModule().getProperties());
        List invokers = OsirisContext.getSession().getInvokersByWorkunitid(workunitId);
        map.put("invokers", invokers);
        return map;
    }

    private boolean hasMethod(Object bean, String name, Object[] args) {
        if (bean == null || name == null) {
            return false;
        }
        for (Class<?> beanClass = bean.getClass(); beanClass != null; beanClass = beanClass.getSuperclass()) {
            Method[] methods = beanClass.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                int argSize;
                Method m = methods[i];
                if (!m.getName().equals(name)) continue;
                int paramSize = m.getParameterTypes() == null ? 0 : m.getParameterTypes().length;
                int n = argSize = args == null ? 0 : args.length;
                if (paramSize == argSize && paramSize == 0) {
                    return true;
                }
                if (paramSize != argSize || m.getParameterTypes()[0] != Object.class) continue;
                return true;
            }
        }
        return false;
    }
}

