/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.classutils;

import com.rameses.classutils.AnnotationField;
import com.rameses.classutils.AnnotationHandler;
import com.rameses.classutils.AnnotationMethod;
import com.rameses.classutils.ClassDef;
import java.lang.annotation.Annotation;

public class AnnotationParser {
    private ClassDef classDef;

    public AnnotationParser(Object o) {
        try {
            this.classDef = new ClassDef(o.getClass());
        }
        catch (Exception e) {
            System.out.println("Error: " + e.getStackTrace());
        }
    }

    public AnnotationParser(Class clazz) {
        try {
            this.classDef = new ClassDef(clazz);
        }
        catch (Exception e) {
            System.out.println("Error: " + e.getStackTrace());
        }
    }

    public void parseType(AnnotationHandler handler) {
        Class clazz = this.classDef.getSource();
        for (Annotation a : clazz.getAnnotations()) {
            handler.handle(a);
        }
    }

    public void parseFields(AnnotationHandler handler) {
        for (AnnotationField f : this.classDef.getAnnotatedFields()) {
            handler.handle(f.getField(), f.getAnnotation());
        }
    }

    public void parseMethods(AnnotationHandler handler) {
        for (AnnotationMethod m : this.classDef.getAnnotatedMethods()) {
            handler.handle(m.getMethod(), m.getAnnotation());
        }
    }
}

