/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.common;

import com.rameses.util.Service;
import java.util.Iterator;

public abstract class CacheProvider {
    private static CacheProvider instance;

    public static CacheProvider getInstance() {
        return CacheProvider.getInstance(CacheProvider.class.getClassLoader());
    }

    public static CacheProvider getInstance(ClassLoader classLoader) {
        if (instance == null) {
            Iterator iter = Service.providers(CacheProvider.class, classLoader);
            if (iter.hasNext()) {
                instance = (CacheProvider)iter.next();
            }
            if (instance == null) {
                throw new RuntimeException("There are no Cache Providers installed");
            }
        }
        return instance;
    }

    public abstract CacheContext createContext();

    public abstract CacheContext getContext(String var1);

    public abstract CacheContext removeContext(String var1);

    public static abstract class CacheContext {
        public abstract String getId();

        public abstract Object get(Object var1);

        public abstract void put(Object var1, Object var2);

        public abstract void remove(Object var1);
    }
}

