/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.ftp;

import com.rameses.ftp.FtpException;
import com.rameses.ftp.FtpLocationConf;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.io.CopyStreamEvent;
import org.apache.commons.net.io.CopyStreamListener;

public class FtpSession {
    private static final int DEFAULT_BUFFER_SIZE = 102400;
    private FtpLocationConf conf;
    private FTPClient ftp;
    private int bufferSize;
    private Handler handler;

    public FtpSession(FtpLocationConf conf) {
        this.conf = conf;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public FTPClient getClient() {
        return this.ftp;
    }

    public void connect() {
        if (this.ftp != null) {
            this.disconnect();
        }
        try {
            this.ftp = new FTPClient();
            this.ftp.connect(this.conf.getHost(), this.conf.getPort());
            int respcode = this.ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)respcode)) {
                throw new FtpException(this.ftp.getReplyString(), respcode);
            }
        }
        catch (RuntimeException re) {
            System.out.println("failed to connect... " + this.conf.getHost() + ":" + this.conf.getPort());
            throw re;
        }
        catch (Exception e) {
            System.out.println("failed to connect... " + this.conf.getHost() + ":" + this.conf.getPort());
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void login() {
        try {
            this.ftp.login(this.conf.getUser(), this.conf.getPassword());
            if (!FTPReply.isPositiveCompletion((int)this.ftp.getReplyCode())) {
                throw new FtpException(this.ftp.getReplyString(), this.ftp.getReplyCode());
            }
        }
        catch (RuntimeException re) {
            System.out.println("failed to login as " + this.conf.getUser());
            throw re;
        }
        catch (Exception e) {
            System.out.println("failed to login as " + this.conf.getUser());
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void logout() {
        try {
            this.ftp.logout();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void disconnect() {
        try {
            this.ftp.disconnect();
        }
        catch (Throwable throwable) {
        }
        finally {
            this.ftp = null;
        }
    }

    public void close() {
        try {
            this.logout();
        }
        finally {
            this.disconnect();
        }
    }

    public void deleteFolder(String remoteName) {
        try {
            this.login();
            this.applySettings();
            StringBuilder buff = new StringBuilder();
            String rootdir = this.conf.getRootDir();
            if (rootdir != null && rootdir.trim().length() > 0) {
                buff.append(rootdir).append("/");
            }
            buff.append(remoteName);
            String[] folders = buff.toString().split("/");
            for (int i = folders.length; i > 0; --i) {
                String sdir = this.concat(folders, i);
                boolean pass = this.ftp.removeDirectory(sdir);
                if (pass) continue;
                break;
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        finally {
            this.logout();
        }
    }

    public void deleteFile(String remoteName) {
        block8: {
            try {
                this.login();
                this.applySettings();
                StringBuilder buff = new StringBuilder();
                String rootdir = this.conf.getRootDir();
                if (rootdir != null && rootdir.trim().length() > 0) {
                    buff.append(rootdir).append("/");
                }
                buff.append(remoteName);
                this.ftp.deleteFile(buff.toString());
                int respcode = this.ftp.getReplyCode();
                if (!FTPReply.isPositiveCompletion((int)respcode)) {
                    throw new FtpException(this.ftp.getReplyString(), respcode);
                }
                int idx = buff.lastIndexOf("/");
                if (idx <= 0) break block8;
                String[] folders = buff.substring(0, idx).split("/");
                for (int i = folders.length; i > 0; --i) {
                    String sdir = this.concat(folders, i);
                    if (this.ftp.removeDirectory(sdir)) continue;
                    break;
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            finally {
                this.logout();
            }
        }
    }

    public void download(String remoteName, File targetFile) {
        DownloadStreamProxy dsp = null;
        try {
            this.login();
            this.applySettings();
            targetFile.getParentFile().mkdirs();
            StringBuilder buff = new StringBuilder();
            String rootdir = this.conf.getRootDir();
            if (rootdir != null && rootdir.trim().length() > 0) {
                buff.append(rootdir).append("/");
            }
            buff.append(remoteName);
            dsp = new DownloadStreamProxy(targetFile);
            dsp.setOffset(dsp.getLength());
            this.ftp.setRestartOffset(dsp.getOffset());
            this.ftp.retrieveFile(buff.toString(), (OutputStream)dsp);
            int respcode = this.ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)respcode)) {
                throw new FtpException(this.ftp.getReplyString(), respcode);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        finally {
            try {
                dsp.close();
            }
            catch (Throwable throwable) {}
            this.logout();
        }
        Handler handler = this.getHandler();
        if (handler != null) {
            handler.onComplete();
        }
    }

    public void download(String remoteName, ByteArrayOutputStream baos) {
        DownloadStreamProxy dsp = null;
        try {
            this.login();
            this.applySettings();
            StringBuilder buff = new StringBuilder();
            String rootdir = this.conf.getRootDir();
            if (rootdir != null && rootdir.trim().length() > 0) {
                buff.append(rootdir).append("/");
            }
            buff.append(remoteName);
            dsp = new DownloadStreamProxy(baos);
            dsp.setOffset(dsp.getLength());
            this.ftp.setRestartOffset(dsp.getOffset());
            this.ftp.retrieveFile(buff.toString(), (OutputStream)dsp);
            int respcode = this.ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)respcode)) {
                throw new FtpException(this.ftp.getReplyString(), respcode);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        finally {
            try {
                dsp.close();
            }
            catch (Throwable throwable) {}
            this.logout();
        }
        Handler handler = this.getHandler();
        if (handler != null) {
            handler.onComplete();
        }
    }

    public void upload(String remoteName, URL url) {
        this.uploadImpl(remoteName, url, -1L);
    }

    public void upload(String remoteName, File file) {
        this.upload(remoteName, file, -1L);
    }

    public void upload(String remoteName, File file, long startpos) {
        this.uploadImpl(remoteName, file, startpos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void uploadImpl(String remoteName, Object source, long startpos) {
        block11: {
            InputStreamProxy inp = null;
            try {
                this.login();
                this.applySettings();
                StringBuilder buff = new StringBuilder();
                String rootdir = this.conf.getRootDir();
                if (rootdir != null && rootdir.trim().length() > 0) {
                    buff.append(rootdir).append("/");
                }
                buff.append(remoteName);
                inp = source instanceof File ? new InputStreamProxy((File)source) : new InputStreamProxy((URL)source);
                if (inp.upload(this.ftp, buff.toString(), startpos)) {
                    break block11;
                }
                Throwable error = inp.getError();
                if (error instanceof RuntimeException) {
                    throw (RuntimeException)error;
                }
                throw new RuntimeException(error.getMessage(), error);
            }
            finally {
                try {
                    inp.close();
                }
                catch (Throwable buff) {}
                this.logout();
            }
        }
        Handler handler = this.getHandler();
        if (handler != null) {
            handler.onComplete();
        }
    }

    private void applySettings() {
        this.ftp.enterLocalPassiveMode();
        this.ftp.setControlKeepAliveTimeout(300L);
        int buffsize = this.getBufferSize();
        this.ftp.setBufferSize(buffsize > 0 ? buffsize : 102400);
        try {
            this.ftp.setFileType(2);
        }
        catch (IOException e) {
            throw new FtpException(e.getMessage(), e);
        }
    }

    private String concat(String[] values, int pos) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < pos && i < values.length; ++i) {
            if (sb.length() > 0) {
                sb.append("/");
            }
            sb.append(values[i]);
        }
        return sb.toString();
    }

    private class ByteBuffer {
        private final Object LOCKED = new Object();
        private int index;
        private int capacity;
        private byte[] bytes;
        private boolean markAsClosed;

        ByteBuffer(int capacity) {
            this.capacity = capacity;
            this.reset();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void reset() {
            Object object = this.LOCKED;
            synchronized (object) {
                if (this.markAsClosed) {
                    throw new RuntimeException("already marked as closed");
                }
                this.index = 0;
                this.bytes = new byte[this.capacity];
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean add(int b) {
            Object object = this.LOCKED;
            synchronized (object) {
                if (this.markAsClosed) {
                    throw new RuntimeException("already marked as closed");
                }
                if (this.index >= 0 && this.index < this.bytes.length) {
                    this.bytes[this.index] = (byte)b;
                    ++this.index;
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        byte[] getBytes() {
            Object object = this.LOCKED;
            synchronized (object) {
                if (this.index <= 0) {
                    return null;
                }
                if (this.bytes == null || this.bytes.length == 0) {
                    return null;
                }
                byte[] newbytes = new byte[this.index];
                System.arraycopy(this.bytes, 0, newbytes, 0, newbytes.length);
                return newbytes;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() {
            Object object = this.LOCKED;
            synchronized (object) {
                this.markAsClosed = true;
                this.bytes = null;
                this.index = 0;
            }
        }
    }

    private class DownloadStreamProxy
    extends OutputStream {
        FtpSession root;
        private File targetFile;
        private FileOutputStream fos;
        private ByteArrayOutputStream baos;
        private OutputStream out;
        private long offset;
        private long nextOffset;

        DownloadStreamProxy(File targetFile) {
            this.root = FtpSession.this;
            this.targetFile = targetFile;
            try {
                this.fos = new FileOutputStream(targetFile);
            }
            catch (FileNotFoundException fnfe) {
                throw new RuntimeException(fnfe);
            }
            this.out = this.fos;
        }

        DownloadStreamProxy(ByteArrayOutputStream baos) {
            this.root = FtpSession.this;
            this.baos = baos;
            this.out = baos;
        }

        long getOffset() {
            return this.offset;
        }

        void setOffset(long offset) {
            this.offset = offset;
            this.nextOffset = offset;
        }

        public long getLength() {
            if (this.baos != null) {
                return this.baos.size();
            }
            if (!this.targetFile.exists()) {
                return 0L;
            }
            RandomAccessFile raf = null;
            AbstractInterruptibleChannel fc = null;
            try {
                raf = new RandomAccessFile(this.targetFile, "r");
                fc = raf.getChannel();
                long l = ((FileChannel)fc).size();
                return l;
            }
            catch (FileNotFoundException fnfe) {
                throw new RuntimeException(fnfe);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            finally {
                try {
                    fc.close();
                }
                catch (Throwable throwable) {}
                try {
                    raf.close();
                }
                catch (Throwable throwable) {}
            }
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
            this.nextOffset += (long)len;
            this.fireOnTransfer(this.nextOffset);
        }

        @Override
        public void close() throws IOException {
            try {
                this.out.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            super.close();
        }

        @Override
        public void flush() throws IOException {
            try {
                this.out.flush();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            super.flush();
        }

        private void fireOnTransfer(long byteprocessed) {
            try {
                Handler handler = this.root.getHandler();
                if (handler == null) {
                    return;
                }
                handler.onTransfer(byteprocessed);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private class InputStreamProxy
    extends InputStream
    implements CopyStreamListener {
        FtpSession root;
        private URL srcUrl;
        private File srcfile;
        private RandomAccessFile raf;
        private FileChannel fc;
        private long filesize;
        private long startpos;
        private Throwable error;

        InputStreamProxy(File srcfile) {
            this.root = FtpSession.this;
            this.srcfile = srcfile;
        }

        InputStreamProxy(URL url) {
            this.root = FtpSession.this;
            this.srcUrl = url;
        }

        @Override
        public int read() throws IOException {
            return this.raf.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.raf.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.raf.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.raf.skipBytes((int)n);
        }

        @Override
        public int available() throws IOException {
            Long num = this.raf.getChannel().size();
            return ((Number)num).intValue();
        }

        @Override
        public void close() throws IOException {
            try {
                this.fc.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.raf.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @Override
        public synchronized void mark(int readlimit) {
            super.mark(readlimit);
        }

        @Override
        public synchronized void reset() throws IOException {
            super.reset();
        }

        @Override
        public boolean markSupported() {
            return super.markSupported();
        }

        Throwable getError() {
            return this.error;
        }

        boolean upload(FTPClient ftp, String remoteName, long offset) {
            if (this.srcUrl != null) {
                return this.uploadURL(ftp, remoteName, offset);
            }
            return this.uploadFile(ftp, remoteName, offset);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean uploadURL(FTPClient ftp, String remoteName, long offset) {
            InputStream urlStream;
            HttpURLConnection httpConn;
            block25: {
                block24: {
                    URLConnection conn = null;
                    httpConn = null;
                    urlStream = null;
                    this.error = null;
                    this.filesize = this.getContentLength(this.srcUrl);
                    conn = this.srcUrl.openConnection();
                    if (conn instanceof HttpURLConnection) {
                        httpConn = (HttpURLConnection)conn;
                    }
                    urlStream = conn.getInputStream();
                    long l = this.startpos = offset >= 0L ? offset : 0L;
                    if (this.startpos < this.filesize) break block24;
                    boolean bl = true;
                    try {
                        urlStream.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        httpConn.disconnect();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return bl;
                }
                ftp.setRestartOffset(this.startpos);
                ftp.setCopyStreamListener((CopyStreamListener)this);
                ftp.storeFile(remoteName, urlStream);
                if (!FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) break block25;
                boolean bl = true;
                try {
                    urlStream.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    httpConn.disconnect();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return bl;
            }
            try {
                try {
                    throw new RuntimeException("[ftp_error] " + ftp.getReplyString());
                }
                catch (Throwable t) {
                    this.error = t;
                    boolean bl = false;
                    return bl;
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    urlStream.close();
                }
                catch (Throwable throwable) {}
                try {
                    httpConn.disconnect();
                }
                catch (Throwable throwable) {}
            }
        }

        boolean uploadFile(FTPClient ftp, String remoteName, long offset) {
            this.error = null;
            try {
                this.raf = new RandomAccessFile(this.srcfile, "r");
                this.fc = this.raf.getChannel();
                this.filesize = this.fc.size();
                long l = this.startpos = offset >= 0L ? offset : 0L;
                if (this.startpos >= this.filesize) {
                    return true;
                }
                this.raf.seek(this.startpos);
                byte[] src = new byte[ftp.getBufferSize()];
                int read = this.raf.read(src);
                if (read < 0) {
                    return true;
                }
                this.raf.seek(this.startpos);
                int idx = remoteName.lastIndexOf(47);
                if (idx > 0) {
                    String[] folders = remoteName.substring(0, idx).split("/");
                    for (int i = 0; i < folders.length; ++i) {
                        String sdir = FtpSession.this.concat(folders, i + 1);
                        ftp.makeDirectory(sdir);
                    }
                }
                ftp.setRestartOffset(this.startpos);
                ftp.setCopyStreamListener((CopyStreamListener)this);
                ftp.storeFile(remoteName, (InputStream)this);
                if (FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                    return true;
                }
                throw new RuntimeException("[ftp_error] " + ftp.getReplyString());
            }
            catch (Throwable t) {
                this.error = t;
                return false;
            }
        }

        public void bytesTransferred(CopyStreamEvent cse) {
        }

        public void bytesTransferred(long totalBytesTransferred, int byteTransferred, long streamSize) {
            Handler handler = this.root.getHandler();
            if (handler == null) {
                return;
            }
            long procbytes = this.startpos + totalBytesTransferred;
            handler.onTransfer(this.filesize, procbytes);
        }

        long getContentLength(URL url) {
            URLConnection conn = null;
            HttpURLConnection httpConn = null;
            try {
                conn = url.openConnection();
                if (conn instanceof HttpURLConnection) {
                    httpConn = (HttpURLConnection)conn;
                    httpConn.setRequestMethod("HEAD");
                }
                conn.getInputStream();
                long l = conn.getContentLength();
                return l;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    httpConn.disconnect();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private class FTPClientImpl
    extends FTPClient {
        private FTPClientImpl() {
        }

        void test() {
        }
    }

    public static interface Handler {
        public void onTransfer(long var1, long var3);

        public void onTransfer(long var1);

        public void onComplete();
    }
}

