/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.server;

import com.rameses.server.ServerConf;
import com.rameses.server.ServerLoader;
import com.rameses.server.ServerLoaderProvider;
import com.rameses.server.ServerPID;
import com.rameses.server.Shutdown;
import com.rameses.util.Service;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class BootLoader {
    private ExecutorService thread;
    private Map<String, ServerLoaderProvider> providers = new Hashtable<String, ServerLoaderProvider>();
    private Map<String, ServerLoader> servers = new Hashtable<String, ServerLoader>();

    private void initProviders() {
        this.providers.clear();
        Iterator iter = Service.providers(ServerLoaderProvider.class, BootLoader.class.getClassLoader());
        while (iter.hasNext()) {
            ServerLoaderProvider p = (ServerLoaderProvider)iter.next();
            this.providers.put(p.getName(), p);
        }
    }

    public static void main(String[] args) throws Throwable {
        BootLoader main = new BootLoader();
        main.start();
    }

    public void start() throws Exception {
        String userdir = System.getProperty("user.dir");
        String basedir = System.getProperty("osiris.base.dir", userdir);
        String rundir = System.getProperty("osiris.run.dir", userdir);
        System.getProperties().put("osiris.base.dir", basedir);
        System.getProperties().put("osiris.run.dir", rundir);
        Shutdown.removePID();
        this.createInstancePID();
        this.initProviders();
        String baseURL = "file:///" + basedir;
        ServerConf.load(rundir + "/server.conf");
        for (Map.Entry<String, Map> entry : ServerConf.getGroups().entrySet()) {
            String groupName = entry.getKey().toString();
            Map groupConf = this.resolveConf(entry.getValue());
            String providerName = (String)groupConf.get("provider");
            if (providerName == null) continue;
            ServerLoaderProvider sp = this.providers.get(providerName);
            if (sp == null) {
                System.out.println("[WARN] '" + providerName + "' provider name not found");
                continue;
            }
            ServerLoader loader = sp.createServer(groupName);
            loader.init(baseURL, groupConf);
            this.servers.put(groupName, loader);
            ServerPID.add(groupName);
        }
        this.thread = Executors.newFixedThreadPool(this.servers.size());
        System.out.println("starting servers");
        for (final ServerLoader loader : this.servers.values()) {
            this.thread.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        loader.start();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (Exception e) {
                        System.out.println("failed to start caused by " + e.getMessage());
                        e.printStackTrace();
                    }
                    finally {
                        try {
                            loader.stop();
                        }
                        catch (Exception exception) {}
                    }
                }
            });
        }
        final ShutdownAgent shutdownAgent = new ShutdownAgent();
        Runnable shutdownHook = new Runnable(){

            @Override
            public void run() {
                shutdownAgent.cancel();
                BootLoader.this.onshutdown();
            }
        };
        Runtime.getRuntime().addShutdownHook(new Thread(shutdownHook));
        new Thread(shutdownAgent).start();
    }

    private void onshutdown() {
        for (ServerLoader svr : this.servers.values()) {
            try {
                System.out.println("Stopping Server: " + svr.getClass().getSimpleName() + "...");
                svr.stop();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        this.removeInstancePID();
        Shutdown.removePID();
    }

    private File getPID() {
        String rundir = System.getProperty("osiris.run.dir");
        return new File(rundir + "/.osiris_pid");
    }

    private void createInstancePID() {
        File file = this.getPID();
        if (file.exists()) {
            throw new RuntimeException("Cannot start the server because there is already a process-ID instance.");
        }
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void removeInstancePID() {
        File file = this.getPID();
        if (file.exists()) {
            try {
                file.delete();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private Map resolveConf(Map conf) {
        LinkedHashMap newconf = new LinkedHashMap();
        if (conf == null) {
            return newconf;
        }
        for (Object key : conf.keySet()) {
            Object val = this.resolveValue(conf.get(key), newconf);
            newconf.put(key, val);
        }
        return newconf;
    }

    private Object resolveValue(Object value, Map conf) {
        int idx1;
        int idx0;
        if (value == null) {
            return null;
        }
        int startidx = 0;
        boolean has_expression = false;
        String str = value.toString();
        StringBuilder builder = new StringBuilder();
        while ((idx0 = str.indexOf("${", startidx)) >= 0 && (idx1 = str.indexOf("}", idx0)) >= 0) {
            has_expression = true;
            String skey = str.substring(idx0 + 2, idx1);
            builder.append(str.substring(startidx, idx0));
            Object objval = null;
            if (skey.startsWith("@@")) {
                String[] arr = skey.split(":");
                String sname = arr.length == 2 ? arr[1] : "";
                Map<String, Map> group = ServerConf.getGroup(skey);
                objval = group.get(sname);
            } else {
                objval = conf.get(skey);
            }
            if (objval == null) {
                objval = System.getProperty(skey);
            }
            if (objval == null) {
                builder.append(str.substring(idx0, idx1 + 1));
            } else {
                builder.append(objval);
            }
            startidx = idx1 + 1;
        }
        if (has_expression) {
            builder.append(str.substring(startidx));
            return builder.toString();
        }
        return value;
    }

    private class ShutdownAgent
    implements Runnable {
        BootLoader root;
        private boolean cancelled;

        private ShutdownAgent() {
            this.root = BootLoader.this;
        }

        void cancel() {
            this.cancelled = true;
        }

        @Override
        public void run() {
            while (!this.cancelled) {
                try {
                    Thread.sleep(2000L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (this.cancelled) break;
                if (Shutdown.hasPID()) {
                    this.processShutdown();
                    break;
                }
                File file = this.root.getPID();
                if (file.exists()) continue;
                this.processShutdown();
                break;
            }
        }

        void processShutdown() {
            this.cancelled = true;
            try {
                this.root.onshutdown();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            try {
                System.out.println("Stopping JVM...");
                System.exit(1);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

