/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class AESCipher {
    private static final String ENC_MODE = "AES";
    private static final String CIPHER_MODE = "AES/ECB/PKCS5Padding";

    public byte[] generateKey() {
        try {
            KeyGenerator kg = KeyGenerator.getInstance(ENC_MODE);
            kg.init(256);
            return kg.generateKey().getEncoded();
        }
        catch (NoSuchAlgorithmException nse) {
            throw new IllegalStateException(nse);
        }
    }

    public byte[] encode(Object value, SecretKey key) {
        return this.encode(value, key.getEncoded());
    }

    public byte[] encode(Object value, byte[] key) {
        try {
            byte[] data = this.toBytes(value);
            SecretKeySpec sk = new SecretKeySpec(key, ENC_MODE);
            Cipher ci = Cipher.getInstance(CIPHER_MODE);
            ci.init(1, sk);
            return ci.doFinal(data);
        }
        catch (IllegalBlockSizeException ibse) {
            throw new IllegalStateException(ibse);
        }
        catch (BadPaddingException bpe) {
            throw new IllegalStateException(bpe);
        }
        catch (InvalidKeyException ike) {
            throw new IllegalStateException(ike);
        }
        catch (NoSuchAlgorithmException nse) {
            throw new IllegalStateException(nse);
        }
        catch (NoSuchPaddingException nspe) {
            throw new IllegalStateException(nspe);
        }
    }

    public Object decode(byte[] encbytes, SecretKey key) {
        return this.decode(encbytes, key.getEncoded());
    }

    public byte[] decode(byte[] encbytes, byte[] key) {
        try {
            SecretKeySpec sk = new SecretKeySpec(key, ENC_MODE);
            Cipher ci = Cipher.getInstance(CIPHER_MODE);
            ci.init(2, sk);
            return ci.doFinal(encbytes);
        }
        catch (IllegalBlockSizeException ibse) {
            throw new IllegalStateException(ibse);
        }
        catch (BadPaddingException bpe) {
            throw new IllegalStateException(bpe);
        }
        catch (InvalidKeyException ike) {
            throw new IllegalStateException(ike);
        }
        catch (NoSuchAlgorithmException nse) {
            throw new IllegalStateException(nse);
        }
        catch (NoSuchPaddingException nspe) {
            throw new IllegalStateException(nspe);
        }
    }

    public Object decodeToObject(byte[] encbytes, byte[] key) {
        byte[] decBytes = this.decode(encbytes, key);
        return this.toObject(decBytes);
    }

    public String decodeToString(byte[] encbytes, byte[] key) {
        Object res = this.decodeToObject(encbytes, key);
        if (res == null) {
            return null;
        }
        if (res instanceof byte[]) {
            return new String((byte[])res);
        }
        return res.toString();
    }

    private byte[] toBytes(Object value) {
        ObjectOutputStream oos = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            oos = new ObjectOutputStream(baos);
            oos.writeObject(value);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
        finally {
            try {
                baos.close();
            }
            catch (Throwable throwable) {}
            try {
                oos.close();
            }
            catch (Throwable throwable) {}
        }
    }

    private Object toObject(byte[] bytes) {
        ObjectInputStream ois = null;
        ByteArrayInputStream bais = null;
        try {
            bais = new ByteArrayInputStream(bytes);
            ois = new ObjectInputStream(bais);
            Object object = ois.readObject();
            return object;
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalStateException(cnfe);
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
        finally {
            try {
                bais.close();
            }
            catch (Throwable throwable) {}
            try {
                ois.close();
            }
            catch (Throwable throwable) {}
        }
    }
}

