/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class CloneHelper {
    public Map clone(Map source, String fieldExpr) {
        String[] fields;
        if (fieldExpr == null || fieldExpr.trim().length() == 0) {
            fieldExpr = ".*";
        }
        ArrayList<KeyVal> keyvals = new ArrayList<KeyVal>();
        this.extract(keyvals, null, source);
        HashMap target = new HashMap();
        for (String text : fields = fieldExpr.split(",")) {
            String str = text.trim();
            if (str.length() == 0) continue;
            for (KeyVal kv : keyvals) {
                if (!kv.accept(str)) continue;
                kv.copyTo(target);
            }
        }
        return target;
    }

    private void extract(List<KeyVal> keyvals, String name, Map source) {
        for (Object key : source.keySet()) {
            Object val = source.get(key);
            if (val instanceof Map) {
                Map map = (Map)val;
                if (name == null) {
                    keyvals.add(new KeyVal(key + "", key, map));
                    this.extract(keyvals, key + "", map);
                    continue;
                }
                keyvals.add(new KeyVal(name + "." + key, key, map));
                this.extract(keyvals, name + "." + key, map);
                continue;
            }
            if (name == null) {
                keyvals.add(new KeyVal(key + "", key, val));
                continue;
            }
            keyvals.add(new KeyVal(name + "." + key, key, val));
        }
    }

    private class KeyVal {
        String path;
        Object key;
        Object value;

        KeyVal(String path, Object key, Object value) {
            this.path = path;
            this.key = key;
            this.value = value;
        }

        boolean accept(String expr) {
            if (expr == null || expr.trim().length() == 0) {
                return false;
            }
            return this.path.matches(expr);
        }

        void copyTo(Map target) {
            if (target == null) {
                return;
            }
            HashMap<String, Object> current = target;
            String[] names = this.path.split("\\.");
            for (int i = 0; i < names.length - 1; ++i) {
                Object o = current.get(names[i]);
                if (o instanceof Map) {
                    current = (Map)o;
                    continue;
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                current.put(names[i], map);
                current = map;
            }
            current.put(names[names.length - 1], this.value);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            sb.append(this.path == null ? "null" : this.path).append("=");
            sb.append(this.value == null ? "null" : this.value.toString());
            sb.append("]");
            return sb.toString();
        }
    }
}

