/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class ConfigProperties {
    private Map map = new LinkedHashMap();
    private Map<String, Map> groups = new LinkedHashMap<String, Map>();
    private File file;
    private boolean updatable = true;
    private Resolver resolver;
    private int resolve_value_stack_counter = 0;

    private ConfigProperties() {
    }

    public ConfigProperties(String filename) {
        this(new File(filename));
    }

    public ConfigProperties(File sfile) {
        this(sfile, null);
    }

    public ConfigProperties(File sfile, Resolver resolver) {
        try {
            this.file = sfile;
            if (this.file.getParentFile() != null && !this.file.getParentFile().exists()) {
                this.file.getParentFile().mkdirs();
            }
            if (!this.file.exists()) {
                this.file.createNewFile();
            }
            this.resolver = resolver;
            this.parse(new FileInputStream(this.file), null);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public ConfigProperties(InputStream inp) {
        this(inp, null);
    }

    public ConfigProperties(InputStream inp, Resolver resolver) {
        try {
            this.resolver = resolver;
            this.updatable = false;
            this.parse(inp, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ConfigProperties(URL u) {
        this(u, null);
    }

    public ConfigProperties(URL u, Resolver resolver) {
        try {
            this.resolver = resolver;
            this.updatable = false;
            this.parse(u.openStream(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void clear() {
        for (Map m : this.groups.values()) {
            m.clear();
        }
        this.groups.clear();
        this.map.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(InputStream inp, Map ref) {
        try {
            this.updatable = false;
            this.load(new BufferedReader(new InputStreamReader(inp)), ref);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                inp.close();
            }
            catch (Exception exception) {}
        }
    }

    private void load(BufferedReader reader, Map ref) throws Exception {
        this.map = new LinkedHashMap();
        Map[] refs = new Map[]{this.map, ref};
        String s = null;
        Group groupMap = null;
        while ((s = reader.readLine()) != null) {
            if ((s = s.trim()).length() == 0 || s.startsWith("#")) continue;
            if (s.startsWith("[")) {
                String groupName = s.substring(1, s.lastIndexOf("]"));
                groupMap = new Group(refs);
                this.groups.put(groupName.trim(), groupMap);
                continue;
            }
            int idxdelim = s.indexOf("=");
            if (idxdelim <= 0) continue;
            String name = s.substring(0, idxdelim).trim();
            String value = s.substring(idxdelim + 1).trim();
            if (groupMap != null) {
                groupMap.put(name, value);
                continue;
            }
            this.map.put(name, this.resolveValue(value, refs));
        }
    }

    public Object getProperty(String name) {
        if (name.indexOf(":") > 0) {
            String groupName = name.substring(0, name.indexOf(":"));
            String propName = name.substring(name.indexOf(":") + 1);
            return this.groups.get(groupName).get(propName);
        }
        return this.map.get(name);
    }

    public Map getProperties(String groupName) {
        return this.groups.get(groupName);
    }

    public Map getProperties() {
        return this.map;
    }

    public void put(String name, String data) {
        this.setProperty(name.trim(), data.trim());
    }

    public String get(String name) {
        return (String)this.getProperty(name);
    }

    public void setProperty(String name, String data) {
        if (name.indexOf(":") > 0) {
            String groupName = name.substring(0, name.indexOf(":"));
            String propName = name.substring(name.indexOf(":") + 1);
            this.groups.get(groupName).put(propName, data);
        } else {
            this.map.put(name.trim(), data.trim());
        }
    }

    public void update() {
        StringBuilder sb = new StringBuilder();
        for (Object k : this.map.keySet()) {
            String skey = (String)k;
            sb.append(skey + "=" + this.map.get(skey) + "\n");
        }
        sb.append("\n\n");
        for (Object object : this.groups.keySet()) {
            sb.append("[" + object + "]\n");
            Map gm = this.groups.get(object);
            for (Object k : gm.keySet()) {
                String gkey = (String)k;
                sb.append(gkey + "=" + gm.get(gkey) + "\n");
            }
            sb.append("\n\n");
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.file);
            fos.write(sb.toString().trim().getBytes());
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage(), exception);
        }
        finally {
            try {
                fos.close();
            }
            catch (Exception exception) {}
        }
    }

    public Map<String, Map> getGroups() {
        return this.groups;
    }

    public void putAll(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry me = o = iterator.next();
            this.put(me.getKey() + "", me.getValue() + "");
        }
    }

    public boolean isUpdatable() {
        return this.updatable;
    }

    private Object resolveValue(Object value, Map[] refs) {
        this.resolve_value_stack_counter = 0;
        return this.resolveValueImpl(value, refs);
    }

    private Object resolveValueImpl(Object value, Map[] refs) {
        int idx1;
        int idx0;
        ++this.resolve_value_stack_counter;
        if (this.resolve_value_stack_counter > 10) {
            return value;
        }
        if (value == null) {
            return null;
        }
        if (!(value instanceof String)) {
            return value;
        }
        int startidx = 0;
        boolean has_expression = false;
        String str = value.toString();
        StringBuilder builder = new StringBuilder();
        while ((idx0 = str.indexOf("${", startidx)) >= 0 && (idx1 = str.indexOf("}", idx0)) >= 0) {
            has_expression = true;
            String skey = str.substring(idx0 + 2, idx1);
            builder.append(str.substring(startidx, idx0));
            Object objval = null;
            for (Map mref : refs) {
                if (mref != null && (objval = mref.get(skey)) != null) break;
            }
            if (objval == null && this.resolver != null) {
                objval = this.resolver.resolve(skey);
            }
            if (objval == null) {
                objval = System.getProperty(skey);
            }
            if (objval == null) {
                objval = System.getenv(skey);
            }
            if (objval == null) {
                builder.append(str.substring(idx0, idx1 + 1));
            } else {
                builder.append(objval);
            }
            startidx = idx1 + 1;
        }
        Object finalResult = null;
        if (has_expression) {
            builder.append(str.substring(startidx));
            finalResult = builder.toString();
        } else {
            finalResult = value;
        }
        if (finalResult != null && this.hasExpression(finalResult)) {
            return this.resolveValueImpl(finalResult, refs);
        }
        return finalResult;
    }

    private boolean hasExpression(Object value) {
        String str;
        String string = str = value == null ? null : value.toString();
        if (str == null || str.length() == 0) {
            return false;
        }
        int idx0 = str.indexOf("${");
        if (idx0 < 0) {
            return false;
        }
        int idx1 = str.indexOf("}", idx0);
        return idx1 > 0;
    }

    public static synchronized Parser newParser() {
        return new Parser();
    }

    public static class Parser {
        private Resolver _resolver;

        public Parser resolver(Resolver res) {
            this._resolver = res;
            return this;
        }

        public Map parse(File file, Map ref) {
            try {
                return this.parse(new FileInputStream(file), ref);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        public Map parse(URL url, Map ref) {
            try {
                InputStream inp = url.openStream();
                return this.parse(inp, ref);
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        public Map parse(InputStream inp, Map ref) {
            ConfigProperties conf = new ConfigProperties();
            conf.resolver = this._resolver;
            conf.parse(inp, ref);
            LinkedHashMap result = new LinkedHashMap();
            result.putAll(conf.map);
            for (Map.Entry me : conf.groups.entrySet()) {
                LinkedHashMap grp = new LinkedHashMap();
                grp.putAll((Map)me.getValue());
                result.put(me.getKey(), grp);
            }
            return result;
        }
    }

    public static class Resolver {
        public Object resolve(String name) {
            return null;
        }
    }

    class Group
    extends LinkedHashMap {
        private Map[] refs;

        Group(Map[] deps) {
            if (deps == null) {
                deps = new Map[]{};
            }
            this.refs = new Map[deps.length + 1];
            this.refs[0] = this;
            for (int i = 0; i < deps.length; ++i) {
                this.refs[i + 1] = deps[i];
            }
        }

        @Override
        public Object put(Object key, Object value) {
            value = ConfigProperties.this.resolveValue(value, this.refs);
            return super.put(key, value);
        }
    }
}

