/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.util;

import com.rameses.util.DateUtil;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateBean {
    private Date date;
    private Calendar cal;
    private SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");

    public DateBean() {
        this(new Date());
    }

    public DateBean(Date d) {
        try {
            String s = this.df.format(d);
            this.date = this.df.parse(s);
            this.cal = Calendar.getInstance();
            this.cal.setTime(this.date);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public DateBean(String s) {
        try {
            this.date = this.df.parse(s);
            this.cal = Calendar.getInstance();
            this.cal.setTime(this.date);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public DateBean(Date d, String pattern) {
        try {
            SimpleDateFormat df = new SimpleDateFormat(pattern);
            String s = df.format(d);
            this.date = df.parse(s);
            this.cal = Calendar.getInstance();
            this.cal.setTime(this.date);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public DateBean(String s, String pattern) {
        try {
            SimpleDateFormat df = new SimpleDateFormat(pattern);
            this.date = df.parse(s);
            this.cal = Calendar.getInstance();
            this.cal.setTime(this.date);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Date getDate() {
        return this.date;
    }

    public int getMonth() {
        return this.cal.get(2) + 1;
    }

    public int getDay() {
        return this.cal.get(5);
    }

    public int getYear() {
        return this.cal.get(1);
    }

    public int getHour() {
        return this.cal.get(10);
    }

    public int getMinute() {
        return this.cal.get(12);
    }

    public int getSecond() {
        return this.cal.get(13);
    }

    public int getMillisecond() {
        return this.cal.get(14);
    }

    public int getQtr() {
        int month = this.getMonth();
        if (month >= 1 && month <= 3) {
            return 1;
        }
        if (month >= 4 && month <= 6) {
            return 2;
        }
        if (month >= 7 && month <= 9) {
            return 3;
        }
        return 4;
    }

    public int getDayOfWeek() {
        return this.cal.get(7);
    }

    public Date getMonthEnd() {
        Date cloneDate = this.cal.getTime();
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(cloneDate);
        int ds = cal2.getActualMaximum(5);
        cal2.set(5, ds);
        return cal2.getTime();
    }

    public Date add(String interval) {
        Date newDate = DateUtil.add(this.getDate(), interval);
        Calendar newCal = Calendar.getInstance();
        newCal.setTime(newDate);
        this.cal = newCal;
        this.date = newDate;
        return this.getDate();
    }

    public String format(String pattern) {
        return new SimpleDateFormat(pattern).format(this.getDate());
    }
}

