/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public final class DateUtil {
    private static long MILLISECS_PER_SEC = 1000L;
    private static long MILLISECS_PER_MIN = 60000L;
    private static long MILLISECS_PER_HOUR = 3600000L;
    private static long MILLISECS_PER_DAY = 86400000L;
    private static SimpleDateFormat basicFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static String[] _monthStr = new String[]{"JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"};

    private static String getType(String interval) {
        String type = "day";
        if (interval.contains("M")) {
            type = "month";
        } else if (interval.contains("h")) {
            type = "hour";
        } else if (interval.contains("m")) {
            type = "minute";
        } else if (interval.contains("s")) {
            type = "second";
        } else if (interval.contains("y")) {
            type = "year";
        }
        return type;
    }

    public static Date add(Date fromDate, String interval) {
        if (interval == null) {
            return fromDate;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(fromDate);
        String type = DateUtil.getType(interval);
        boolean neg = false;
        if (interval.trim().startsWith("-")) {
            neg = true;
        }
        int num = Integer.parseInt(interval.replaceAll("\\D", ""));
        if (neg) {
            num *= -1;
        }
        if (type.equals("hour")) {
            cal.add(10, num);
        } else if (type.equals("minute")) {
            cal.add(12, num);
        } else if (type.equals("second")) {
            cal.add(13, num);
        } else if (type.equals("month")) {
            cal.add(2, num);
        } else if (type.equals("year")) {
            cal.add(1, num);
        } else {
            cal.add(5, num);
        }
        return cal.getTime();
    }

    public static Date calculateNextDate(Date d, String mode) {
        if (mode == null || mode.length() == 0) {
            return null;
        }
        int itype = 5;
        if (mode.contains("d")) {
            itype = 5;
        }
        if (mode.contains("y")) {
            itype = 1;
        }
        if (mode.contains("w")) {
            itype = 3;
        }
        if (mode.contains("M")) {
            itype = 2;
        }
        if (mode.contains("m")) {
            itype = 12;
        }
        if (mode.contains("h")) {
            itype = 10;
        }
        if (mode.contains("s")) {
            itype = 13;
        }
        String s = mode.replaceAll("[^\\d]", "").trim();
        int i = Integer.parseInt(s);
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        cal.add(itype, i);
        return cal.getTime();
    }

    public static String getFormattedTime(Date d, String timezone) {
        String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        TimeZone tz = TimeZone.getTimeZone(timezone);
        if (tz == null) {
            throw new RuntimeException("Timezone " + timezone + " is not available");
        }
        sdf.setTimeZone(tz);
        return sdf.format(d);
    }

    public static String getFormattedTime(Date d, String dtformat, String timezone) {
        if (dtformat == null) {
            dtformat = "yyyy-MM-dd HH:mm:ss";
        }
        String DATE_TIME_FORMAT = dtformat;
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_TIME_FORMAT);
        TimeZone tz = TimeZone.getTimeZone(timezone);
        if (tz == null) {
            throw new RuntimeException("Timezone " + timezone + " is not available");
        }
        sdf.setTimeZone(tz);
        return sdf.format(d);
    }

    public static String convertTime(String time, String sourceTZ, String destTZ) {
        Date specifiedTime;
        String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (sourceTZ != null) {
            sdf.setTimeZone(TimeZone.getTimeZone(sourceTZ));
        } else {
            sdf.setTimeZone(TimeZone.getDefault());
        }
        try {
            specifiedTime = sdf.parse(time);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (destTZ != null) {
            sdf.setTimeZone(TimeZone.getTimeZone(destTZ));
        } else {
            sdf.setTimeZone(TimeZone.getDefault());
        }
        return sdf.format(specifiedTime);
    }

    public static long diff(Date d1, Date d2) {
        Calendar startDate = Calendar.getInstance();
        startDate.setTime(d1);
        Calendar endDate = Calendar.getInstance();
        endDate.setTime(d2);
        Calendar sDate = (Calendar)startDate.clone();
        long daysBetween = 0L;
        int y1 = sDate.get(1);
        int y2 = endDate.get(1);
        int m1 = sDate.get(2);
        int m2 = endDate.get(2);
        while ((y2 - y1) * 12 + (m2 - m1) > 12) {
            if (sDate.get(2) == 0 && sDate.get(5) == sDate.getActualMinimum(5)) {
                daysBetween += (long)sDate.getActualMaximum(6);
                sDate.add(1, 1);
            } else {
                int diff = 1 + sDate.getActualMaximum(6) - sDate.get(6);
                sDate.add(6, diff);
                daysBetween += (long)diff;
            }
            y1 = sDate.get(1);
        }
        while ((m2 - m1) % 12 > 1) {
            daysBetween += (long)sDate.getActualMaximum(5);
            sDate.add(2, 1);
            m1 = sDate.get(2);
        }
        while (sDate.before(endDate)) {
            sDate.add(5, 1);
            ++daysBetween;
        }
        return daysBetween;
    }

    public static long diff(Date dfrom, Date dto, int type) {
        Calendar calendar1 = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar1.setTime(dfrom);
        calendar2.setTime(dto);
        long milliseconds1 = calendar1.getTimeInMillis();
        long milliseconds2 = calendar2.getTimeInMillis();
        long diff = milliseconds2 - milliseconds1;
        if (type == 5) {
            return diff / 86400000L;
        }
        if (type == 10) {
            return diff / 3600000L;
        }
        if (type == 12) {
            return diff / 60000L;
        }
        if (type == 13) {
            return diff / 1000L;
        }
        return diff;
    }

    public static String formatDate(Date d1) {
        return DateUtil.formatDate(null, d1);
    }

    public static String formatDate(String pattern, Date d1) {
        SimpleDateFormat df = null;
        if (pattern == null) {
            df = basicFormat;
        }
        return df.format(d1);
    }

    public static String getMonthStr(int mon) {
        return _monthStr[mon - 1];
    }
}

