/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.util;

import com.rameses.util.AppException;
import com.rameses.util.BreakException;
import com.rameses.util.ExceptionHandler;
import com.rameses.util.IgnoreException;
import com.rameses.util.Service;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class ExceptionManager {
    private static ExceptionManager instance;
    private List<ExceptionHandler> errorHandlers;

    public static ExceptionManager getInstance() {
        if (instance == null) {
            instance = new ExceptionManager();
        }
        return instance;
    }

    public boolean handleError(Exception e) {
        if (this.errorHandlers == null) {
            this.errorHandlers = new ArrayList<ExceptionHandler>();
            Iterator iter = Service.providers(ExceptionHandler.class, this.getClass().getClassLoader());
            while (iter.hasNext()) {
                this.errorHandlers.add((ExceptionHandler)iter.next());
            }
            Collections.sort(this.errorHandlers);
        }
        for (ExceptionHandler eh : this.errorHandlers) {
            if (!eh.accept(e)) continue;
            return true;
        }
        return false;
    }

    public static Exception getOriginal(Exception ex) {
        Throwable t = ex;
        while (t.getCause() != null) {
            t = t.getCause();
        }
        Exception e = null;
        if (t instanceof AppException) {
            e = (AppException)t;
        } else if (t instanceof NullPointerException) {
            e = (NullPointerException)t;
        } else if (t instanceof BreakException) {
            e = (BreakException)t;
        } else if (t instanceof IgnoreException) {
            e = (IgnoreException)t;
        } else {
            String msg = t.getMessage();
            if (t instanceof NoSuchMethodException) {
                e = new NoSuchMethodException(msg);
            } else if (t instanceof NoSuchFieldException) {
                e = new NoSuchFieldException(msg);
            } else {
                if (msg == null) {
                    msg = t.getClass().getName();
                }
                e = new Exception(msg);
            }
        }
        return e;
    }
}

