/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.util;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import net.sf.json.JsonConfig;
import net.sf.json.processors.JsonValueProcessor;

public class JSON {
    public String encode(Object data) {
        if (data instanceof Map || data instanceof List || data instanceof Object[]) {
            net.sf.json.JSON json = JSONSerializer.toJSON((Object)data, (JsonConfig)this.createConf());
            return json.toString();
        }
        throw new RuntimeException("Cannot encode data to JSON string");
    }

    public Object decode(String data) {
        if (data != null) {
            JsonConfig jc = this.createConf();
            net.sf.json.JSON js = JSONSerializer.toJSON((Object)data, (JsonConfig)jc);
            if (js.isArray()) {
                return JSONArray.fromObject((Object)js, (JsonConfig)jc);
            }
            return JSONObject.fromObject((Object)js, (JsonConfig)jc);
        }
        throw new RuntimeException("Cannot decode JSON string to Object");
    }

    private JsonConfig createConf() {
        JsonConfig jc = new JsonConfig();
        jc.registerJsonValueProcessor(Date.class, (JsonValueProcessor)new DateValueProcessor());
        jc.registerJsonValueProcessor(java.sql.Date.class, (JsonValueProcessor)new SqlDateValueProcessor());
        jc.registerJsonValueProcessor(Timestamp.class, (JsonValueProcessor)new SqlDateTimeValueProcessor());
        return jc;
    }

    private class DateValueProcessor
    implements JsonValueProcessor {
        private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        private DateValueProcessor() {
        }

        public Object processArrayValue(Object value, JsonConfig jc) {
            return this.resolve(this.sdf.format((Date)value));
        }

        public Object processObjectValue(String name, Object value, JsonConfig jc) {
            return this.resolve(this.sdf.format((Date)value));
        }

        private String resolve(String value) {
            String[] arr = value.split(" ");
            return arr[0] + "T" + arr[1];
        }
    }

    private class SqlDateTimeValueProcessor
    implements JsonValueProcessor {
        private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        private SqlDateTimeValueProcessor() {
        }

        public Object processArrayValue(Object value, JsonConfig jc) {
            return this.resolve(this.sdf.format((Timestamp)value));
        }

        public Object processObjectValue(String name, Object value, JsonConfig jc) {
            return this.resolve(this.sdf.format((Timestamp)value));
        }

        private String resolve(String value) {
            String[] arr = value.split(" ");
            return arr[0] + "T" + arr[1];
        }
    }

    private class SqlDateValueProcessor
    implements JsonValueProcessor {
        private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

        private SqlDateValueProcessor() {
        }

        public Object processArrayValue(Object value, JsonConfig jc) {
            return this.sdf.format((java.sql.Date)value);
        }

        public Object processObjectValue(String name, Object value, JsonConfig jc) {
            return this.sdf.format((java.sql.Date)value);
        }
    }
}

