/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.util;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.StringReader;

final class MacInfoLinux {
    MacInfoLinux() {
    }

    public String getMachAddress() {
        AbstractMacInfo[] impls;
        for (AbstractMacInfo o : impls = new AbstractMacInfo[]{new MacInfoImpl_1(), new MacInfoImpl_2(), new MacInfoImpl_3()}) {
            try {
                String mac = o.getMachAddress();
                if (mac == null || mac.trim().length() <= 0) continue;
                return mac;
            }
            catch (Throwable t) {
                System.out.println(" ");
                t.printStackTrace();
            }
        }
        return null;
    }

    class MacInfoImpl_3
    extends AbstractMacInfo {
        MacInfoImpl_3() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getMachAddress() {
            String text = null;
            try {
                return this.exec("ifconfig");
            }
            catch (Throwable t) {
                System.out.println(" ");
                t.printStackTrace();
                if (text == null || text.length() == 0) {
                    return null;
                }
                Object mac = null;
                String readLine = null;
                BufferedReader reader = null;
                try {
                    String[] arr;
                    reader = new BufferedReader(new StringReader(text));
                    while ((readLine = reader.readLine()) != null) {
                        arr = readLine.trim().split(" ");
                        if (!"ether".equals(arr[0])) continue;
                        arr[1] = arr[1].toUpperCase();
                        if (!arr[1].matches("^([0-9A-F]{2}[:-]){5}([0-9A-F]{2})$")) continue;
                        mac = arr[1];
                        break;
                    }
                    arr = mac;
                    return arr;
                }
                catch (Throwable t2) {
                    System.out.println(" ");
                    t2.printStackTrace();
                }
                finally {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable) {}
                }
                return null;
            }
        }
    }

    class MacInfoImpl_2
    extends MacInfoImpl_1 {
        MacInfoImpl_2() {
        }

        @Override
        String getCommand() {
            return "ip a";
        }
    }

    class MacInfoImpl_1
    extends AbstractMacInfo {
        MacInfoImpl_1() {
        }

        String getCommand() {
            return "ip link ls up";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getMachAddress() {
            String text = null;
            try {
                text = this.exec(this.getCommand());
            }
            catch (Throwable t) {
                System.out.println(" ");
                t.printStackTrace();
            }
            if (text == null || text.length() == 0) {
                return null;
            }
            Object mac = null;
            String readLine = null;
            BufferedReader reader = null;
            try {
                String[] arr;
                reader = new BufferedReader(new StringReader(text));
                while ((readLine = reader.readLine()) != null) {
                    arr = readLine.trim().split(" ");
                    if (!"link/ether".equals(arr[0])) continue;
                    arr[1] = arr[1].toUpperCase();
                    if (!arr[1].matches("^([0-9A-F]{2}[:-]){5}([0-9A-F]{2})$")) continue;
                    mac = arr[1];
                    break;
                }
                arr = mac;
                return arr;
            }
            catch (Throwable t) {
                System.out.println(" ");
                t.printStackTrace();
            }
            finally {
                try {
                    reader.close();
                }
                catch (Throwable throwable) {}
            }
            return null;
        }
    }

    abstract class AbstractMacInfo {
        AbstractMacInfo() {
        }

        abstract String getMachAddress();

        String exec(String command) throws Exception {
            Process p = Runtime.getRuntime().exec(command);
            String error = this.toString(p.getErrorStream());
            if (error != null && error.trim().length() > 0) {
                System.err.println(error);
                return null;
            }
            return this.toString(p.getInputStream());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        String toString(InputStream inp) throws Exception {
            if (inp == null) {
                return null;
            }
            int read = 0;
            byte[] bytes = new byte[1024];
            StringBuilder sb = new StringBuilder();
            try {
                while ((read = inp.read(bytes)) != -1) {
                    sb.append(new String(bytes, 0, read));
                }
                String string = sb.toString();
                return string;
            }
            finally {
                try {
                    inp.close();
                }
                catch (Throwable throwable) {}
                bytes = null;
                sb = null;
            }
        }
    }
}

