/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.util;

import com.rameses.util.MacInfoLinux;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class MachineInfo {
    private static MachineInfo instance;
    private Map info = new HashMap();
    private String os;

    public Map getInfo() {
        return this.info;
    }

    public String getOs() {
        return this.os;
    }

    public abstract String getMacAddress() throws Exception;

    private static String getProcessResponse(String command) throws Exception {
        int c;
        Process p = Runtime.getRuntime().exec(command);
        BufferedInputStream stdoutStream = new BufferedInputStream(p.getInputStream());
        StringBuffer buffer = new StringBuffer();
        while ((c = ((InputStream)stdoutStream).read()) != -1) {
            buffer.append((char)c);
        }
        String outputText = buffer.toString();
        ((InputStream)stdoutStream).close();
        return outputText;
    }

    private static String getLocalHost() throws ParseException {
        String localHost = null;
        try {
            localHost = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException ex) {
            ex.printStackTrace();
            throw new ParseException(ex.getMessage(), 0);
        }
        return localHost;
    }

    public static MachineInfo getInstance() {
        if (instance == null) {
            String osName = System.getProperty("os.name").toLowerCase();
            if (osName.indexOf("windows") >= 0) {
                instance = new WindowsMachineInfo();
            } else if (osName.indexOf("linux") >= 0) {
                instance = new LinuxMachineInfo();
            } else if (osName.indexOf("mac") >= 0) {
                instance = new MacMachineInfo();
            }
            if (instance == null) {
                throw new RuntimeException("Machine with " + osName + " not supported");
            }
            MachineInfo.instance.os = osName;
        }
        return instance;
    }

    public static class MacMachineInfo
    extends MachineInfo {
        private String macAddress;

        @Override
        public String getMacAddress() throws Exception {
            if (this.macAddress != null) {
                return this.macAddress;
            }
            String localHost = MachineInfo.getLocalHost();
            String ipConfigResponse = MachineInfo.getProcessResponse("ifconfig");
            StringTokenizer tokenizer = new StringTokenizer(ipConfigResponse, "\n");
            Object lastMacAddress = null;
            while (tokenizer.hasMoreTokens()) {
                String macAddressCandidate;
                String line = tokenizer.nextToken().trim();
                int macAddressPosition = line.indexOf("ether ");
                if (macAddressPosition < 0 || (macAddressCandidate = line.substring(macAddressPosition + 5).trim()).length() != 17) continue;
                this.macAddress = macAddressCandidate;
                return this.macAddress;
            }
            throw new ParseException("cannot read MAC address for " + localHost + " from [" + ipConfigResponse + "]", 0);
        }
    }

    public static class LinuxMachineInfo
    extends MachineInfo {
        private String macAddress;

        @Override
        public String getMacAddress() throws Exception {
            if (this.macAddress != null) {
                return this.macAddress;
            }
            String mac = null;
            try {
                mac = new MacInfoLinux().getMachAddress();
                if (mac != null) {
                    this.macAddress = mac;
                    System.out.println("Hardware Address -> " + this.macAddress);
                }
            }
            catch (Throwable t) {
                System.out.println("WARN: " + t.getClass().getName() + ": " + t.getMessage());
            }
            if (mac == null) {
                throw new ParseException("cannot read MAC address", 0);
            }
            return mac;
        }
    }

    public static class WindowsMachineInfo
    extends MachineInfo {
        private String macAddress;

        @Override
        public String getMacAddress() throws Exception {
            if (this.macAddress != null) {
                return this.macAddress;
            }
            try {
                this.macAddress = this.getMacFromIPConfig();
                if (this.macAddress != null) {
                    return this.macAddress;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                String line;
                Process p = Runtime.getRuntime().exec("getmac /fo table /nh");
                BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while ((line = br.readLine()) != null) {
                    if (line.trim().length() <= 0) continue;
                    this.macAddress = line.split("\\s")[0].trim();
                    return this.macAddress;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ParseException("cannot read MAC address ", 0);
        }

        private String getMacFromIPConfig() {
            try {
                String response = MachineInfo.getProcessResponse("ipconfig /all");
                StringTokenizer tokenizer = new StringTokenizer(response, "\n");
                boolean counter = true;
                boolean skipMac = false;
                Pattern macPattern = Pattern.compile("(?:\\w{2}-){5}\\w{2}");
                while (tokenizer.hasMoreTokens()) {
                    Matcher m;
                    String line = tokenizer.nextToken().trim();
                    if (line.toLowerCase().contains("disconnected")) {
                        skipMac = true;
                    }
                    if (!(m = macPattern.matcher(line)).find()) continue;
                    if (!skipMac) {
                        this.macAddress = m.group();
                        return this.macAddress;
                    }
                    skipMac = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }
}

