/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.util;

import com.rameses.util.ValueUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class MapVersionControl {
    private static MapVersionControl instance;

    public static final synchronized MapVersionControl getInstance() {
        if (instance == null) {
            instance = new MapVersionControl();
        }
        return instance;
    }

    private void processDiff(Map map1, Map map2, String prefix, DiffHandler handler) {
        Iterator iterator = map1.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry me = o = iterator.next();
            Object value = me.getValue();
            String name = me.getKey().toString();
            Object x = map2.get(name);
            if (prefix == null) {
                prefix = "";
            }
            String fieldName = prefix + name;
            if (ValueUtil.isStringValueEqual(value, x)) continue;
            if (value != null && value instanceof Map && x instanceof Map) {
                this.processDiff((Map)value, (Map)x, fieldName + ".", handler);
                continue;
            }
            if (value != null && value instanceof List && x instanceof List) {
                List list1 = (List)value;
                List list2 = (List)x;
                if (list1.size() <= 0) continue;
                int sz2 = list2.size();
                for (int i = 0; i < list1.size(); ++i) {
                    Object listVal = list1.get(i);
                    if (i >= sz2) {
                        handler.addItem(fieldName, i, listVal);
                        continue;
                    }
                    Object listVal2 = list2.get(i);
                    if (listVal == listVal2) continue;
                    if (listVal instanceof Map && listVal2 instanceof Map) {
                        this.processDiff((Map)listVal, (Map)listVal2, fieldName + "[" + i + "].", handler);
                        continue;
                    }
                    handler.update(fieldName + "[" + i + "]", listVal);
                }
                continue;
            }
            handler.update(fieldName, value);
        }
    }

    public Map diff(Map comp1, Map comp2) {
        HashMap diff = new HashMap();
        this.processDiff(comp1, comp2, null, new OldAgainstNewDiffHandler(diff));
        this.processDiff(comp2, comp1, null, new NewAgainstOldDiffHandler(diff));
        return diff;
    }

    public Map merge(Map oldVersion, Map diff) {
        TreeMap sortedDiff = new TreeMap(diff);
        HashMap copy = new HashMap();
        this.scanCopy(copy, oldVersion, null, sortedDiff);
        this.applyChanges(copy, sortedDiff);
        return copy;
    }

    public void applyChanges(Map model, Map diff) {
        Iterator iterator = diff.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry me = o = iterator.next();
            String name = (String)me.getKey();
            Map changeEntry = (Map)me.getValue();
            Map context = model;
            if (name.contains(".")) {
                String[] arr = name.substring(0, name.lastIndexOf(".")).split("\\.");
                name = name.substring(name.lastIndexOf(".") + 1);
                for (String s : arr) {
                    if (s.contains("[")) {
                        String xname = s.substring(0, s.indexOf("["));
                        int idx = Integer.valueOf(s.substring(s.indexOf("[") + 1, s.indexOf("]")));
                        List list = (List)context.get(xname);
                        context = (Map)list.get(idx);
                        continue;
                    }
                    context = (Map)context.get(s);
                }
            }
            context.put(name, changeEntry.get("newValue"));
        }
    }

    private void scanCopy(Map context, Map comp2, String prefix, Map diff) {
        Iterator iterator = comp2.entrySet().iterator();
        while (iterator.hasNext()) {
            String name;
            Map.Entry o;
            Map.Entry me = o = iterator.next();
            Object value = me.getValue();
            String fieldName = name = me.getKey().toString();
            if (prefix != null) {
                fieldName = prefix + "." + name;
            }
            if (value != null && value instanceof Map) {
                Map change = (Map)diff.remove(fieldName);
                Map oldContext = (Map)value;
                HashMap subContext = new HashMap();
                context.put(name, subContext);
                if (change != null) {
                    subContext.put(name, change.get("newValue"));
                    continue;
                }
                this.scanCopy(subContext, oldContext, fieldName, diff);
                continue;
            }
            if (value != null && value instanceof List) {
                Map change;
                String testName;
                List list = (List)value;
                ArrayList newList = new ArrayList();
                context.put(name, newList);
                int i = 0;
                for (i = 0; i < list.size(); ++i) {
                    Object ox;
                    testName = fieldName + "[" + i + "]";
                    change = (Map)diff.remove(testName);
                    if (change == null) {
                        ox = list.get(i);
                        if (ox instanceof Map) {
                            Map oldItem = (Map)ox;
                            HashMap newItem = new HashMap();
                            newList.add(newItem);
                            this.scanCopy(newItem, oldItem, testName, diff);
                            continue;
                        }
                        newList.add(ox);
                        continue;
                    }
                    if (!change.get("action").equals("update")) continue;
                    ox = change.get("newValue");
                    newList.add(ox);
                }
                while ((change = (Map)diff.remove(testName = fieldName + "[" + i + "]")) != null) {
                    newList.add(change.get("value"));
                }
                continue;
            }
            Object nv = value;
            Map change = (Map)diff.remove(fieldName);
            if (change != null) {
                nv = change.get("newValue");
            }
            context.put(name, nv);
        }
    }

    public Map checkConflict(Map diff1, Map diff2) {
        HashMap conflict = new HashMap();
        Iterator iterator = diff1.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry me = o = iterator.next();
            String k = (String)me.getKey();
            Object v = me.getValue();
            Object obj = diff2.get(k);
            if (obj == null || ValueUtil.isStringValueEqual(v, obj)) continue;
            HashMap entry = new HashMap();
            entry.put("diff1", v);
            entry.put("diff2", obj);
            conflict.put(k, entry);
        }
        if (conflict.size() == 0) {
            return null;
        }
        return conflict;
    }

    public Map compareAndMerge(Map oldMap, Map newMap) {
        Map diff = this.diff(oldMap, newMap);
        return this.merge(oldMap, diff);
    }

    private class NewAgainstOldDiffHandler
    implements DiffHandler {
        private Map diff;

        public NewAgainstOldDiffHandler(Map l) {
            this.diff = l;
        }

        @Override
        public void update(String name, Object value) {
            HashMap<String, Object> m = (HashMap<String, Object>)this.diff.get(name);
            if (m == null) {
                m = new HashMap<String, Object>();
                m.put("action", "update");
                this.diff.put(name, m);
            }
            m.put("newValue", value);
        }

        @Override
        public void addItem(String name, int pos, Object value) {
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("action", "add");
            m.put("value", value);
            m.put("pos", pos);
            m.put("name", name);
            this.diff.put(name + "[" + pos + "]", m);
        }
    }

    private class OldAgainstNewDiffHandler
    implements DiffHandler {
        private Map diff;

        public OldAgainstNewDiffHandler(Map l) {
            this.diff = l;
        }

        @Override
        public void update(String name, Object value) {
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("action", "update");
            m.put("oldValue", value);
            this.diff.put(name, m);
        }

        @Override
        public void addItem(String name, int pos, Object value) {
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("action", "remove");
            m.put("value", value);
            m.put("pos", pos);
            m.put("name", name);
            this.diff.put(name + "[" + pos + "]", m);
        }
    }

    private static interface DiffHandler {
        public void addItem(String var1, int var2, Object var3);

        public void update(String var1, Object var2);
    }
}

